/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.edb;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.controller.edb.EdbController;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.entity.trade.MallOrderUpdateHistoryEntity;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.deliver.MallProvinceInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallMiniShopInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.util.JsonUtil;

@RestController
@RequestMapping(value={"/edb"})
public class EdbController {
    private static final Logger log = LoggerFactory.getLogger(EdbController.class);
    @Value(value="${cms.url}")
    private String cmsUrl;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallProvinceInterface provinceService;
    @Autowired
    private MallCityInterface cityService;
    @Autowired
    private MallAreaInterface areaService;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallMiniShopInterface mallMiniShopInterface;

    @RequestMapping(value={"/order/refundStatusSync"})
    public BaseJsonVo refundStatusSync(String orderNo, String return_status, String delivery_status, String refund_status) {
        BaseJsonVo returnBaseJson = BaseJsonVo.success((Object)"");
        return returnBaseJson;
    }

    @RequestMapping(value={"/order/refundSync"})
    public BaseJsonVo refundSync(String orderNo, String return_amount, String wechat_refund, String alipay_refund, String balance_refund, HttpServletResponse response) {
        log.info("=============api refundSync=================");
        try {
            Map map;
            String cmsRefundUrl = this.cmsUrl + "/edb/order/refundSync?orderNo=" + orderNo + "&return_amount=" + return_amount + "&wechat_refund=" + wechat_refund + "&alipay_refund=" + alipay_refund + "&balance_refund=" + balance_refund;
            log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + cmsRefundUrl);
            String result = HttpRequest.get((String)cmsRefundUrl, (String)"");
            log.info("edb\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            if (result != null && !result.isEmpty() && "200".equals((map = (Map)JsonUtil.parseObject((String)result, Map.class)).get("status").toString())) {
                return BaseJsonVo.success((Object)"\u91cd\u5b9a\u5411\u8bf7\u6c42\u9000\u6b3e\u6210\u529f");
            }
            return BaseJsonVo.error((String)"\u9000\u6b3e\u5931\u8d25");
        }
        catch (Exception e) {
            log.error(orderNo + "\u91cd\u5b9a\u5411\u5931\u8d25", (Throwable)e);
            return BaseJsonVo.error((String)(orderNo + "\u91cd\u5b9a\u5411\u5931\u8d25"));
        }
    }

    @RequestMapping(value={"/order/check"})
    public BaseJsonVo orderCheck(String orderNo, String createTime) {
        BaseJsonVo baseJsonVo;
        BaseJsonVo returnBaseJson = null;
        1 paramsMap = new /* Unavailable Anonymous Inner Class!! */;
        try {
            log.info("**********\u8fdb\u5165\u5ba1\u6838\u56de\u4f20\u63a5\u53e3********orderNo={},createTime={}", (Object)orderNo, (Object)createTime);
            baseJsonVo = returnBaseJson = this.mallOrderInterface.updateOrderStatusByEdb(orderNo, "7", createTime, null, null, null);
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                returnBaseJson = BaseJsonVo.error((String)sw.toString());
                throw e;
            }
            catch (Throwable throwable) {
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("check");
                entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                entity.setDirection(Integer.valueOf(1));
                entity.setCreateTime(DateUtils.now());
                entity.setSyncName("EDB");
                entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                entity.setWarnLevel(Integer.valueOf(5));
                entity.setOrderNo(orderNo);
                entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                this.orderSyncInfoService.recordInfo(entity);
                throw throwable;
            }
        }
        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
        entity.setApiName("check");
        entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
        entity.setDirection(Integer.valueOf(1));
        entity.setCreateTime(DateUtils.now());
        entity.setSyncName("EDB");
        entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
        entity.setWarnLevel(Integer.valueOf(5));
        entity.setOrderNo(orderNo);
        entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
        this.orderSyncInfoService.recordInfo(entity);
        return baseJsonVo;
    }

    @RequestMapping(value={"/order/deliverGoods"})
    public BaseJsonVo deliverGoods(String orderNo, String waybillNo, String deliverId, String deliverName, String deliverDate) {
        BaseJsonVo baseJsonVo;
        BaseJsonVo returnBaseJson = null;
        2 paramsMap = new /* Unavailable Anonymous Inner Class!! */;
        try {
            log.info("**********\u8fdb\u5165\u53d1\u8d27\u56de\u4f20\u63a5\u53e3********orderNo={},waybillNo={},deliverId={},,deliverName={}deliverDate={}", new Object[]{orderNo, waybillNo, deliverId, deliverName, deliverDate});
            baseJsonVo = returnBaseJson = this.mallOrderInterface.updateOrderStatusByEdb(orderNo, "10", deliverDate, waybillNo, deliverId, deliverName);
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                returnBaseJson = BaseJsonVo.error((String)sw.toString());
                throw e;
            }
            catch (Throwable throwable) {
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("deliverGoods");
                entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                entity.setDirection(Integer.valueOf(1));
                entity.setCreateTime(DateUtils.now());
                entity.setSyncName("EDB");
                entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                entity.setWarnLevel(Integer.valueOf(5));
                entity.setOrderNo(orderNo);
                entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                this.orderSyncInfoService.recordInfo(entity);
                throw throwable;
            }
        }
        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
        entity.setApiName("deliverGoods");
        entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
        entity.setDirection(Integer.valueOf(1));
        entity.setCreateTime(DateUtils.now());
        entity.setSyncName("EDB");
        entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
        entity.setWarnLevel(Integer.valueOf(5));
        entity.setOrderNo(orderNo);
        entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
        this.orderSyncInfoService.recordInfo(entity);
        return baseJsonVo;
    }

    @RequestMapping(value={"/order/modify"})
    public BaseJsonVo orderModify(String orderNo, String consigneeName, String consigneePhone, String consigneeAddr, String consigneeProvincename, String consigneeCityname, String consigneeAreaname) {
        BaseJsonVo baseJsonVo;
        MallAreaEntity area;
        MallOrderEntity orderSearch;
        3 paramsMap;
        BaseJsonVo returnBaseJson;
        block7: {
            block6: {
                returnBaseJson = null;
                paramsMap = new /* Unavailable Anonymous Inner Class!! */;
                log.info("[EDBmodifyorder[{}]\u4fee\u6539\u8ba2\u5355:{}", (Object)orderNo, (Object)JsonUtils.toJson((Object)paramsMap, (boolean)false));
                orderSearch = this.mallOrderInterface.getmallOrder(orderNo);
                if (orderSearch != null) break block6;
                BaseJsonVo baseJsonVo2 = returnBaseJson = BaseJsonVo.error((String)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u4fe1\u606f");
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("modify");
                entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                entity.setDirection(Integer.valueOf(1));
                entity.setCreateTime(DateUtils.now());
                entity.setSyncName("EDB");
                entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                entity.setWarnLevel(Integer.valueOf(5));
                entity.setOrderNo(orderNo);
                entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                this.orderSyncInfoService.recordInfo(entity);
                return baseJsonVo2;
            }
            area = this.areaService.getAreaByName(consigneeAreaname);
            if (area != null) break block7;
            BaseJsonVo entity = returnBaseJson = BaseJsonVo.error((String)"\u672a\u83b7\u53d6\u5230\u5730\u5740\u4fe1\u606f");
            MallOrderSyncInfoEntity entity2 = new MallOrderSyncInfoEntity();
            entity2.setApiName("modify");
            entity2.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
            entity2.setDirection(Integer.valueOf(1));
            entity2.setCreateTime(DateUtils.now());
            entity2.setSyncName("EDB");
            entity2.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
            entity2.setWarnLevel(Integer.valueOf(5));
            entity2.setOrderNo(orderNo);
            entity2.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
            this.orderSyncInfoService.recordInfo(entity2);
            return entity;
        }
        try {
            MallOrderEntity order = new MallOrderEntity();
            order.setOrderNo(orderNo);
            order.setConsigneeName(consigneeName);
            order.setConsigneePhone(consigneePhone);
            order.setConsigneeAddr(consigneeAddr);
            order.setConsigneeProvincename(consigneeProvincename);
            order.setConsigneeCityname(consigneeCityname);
            order.setConsigneeAreaid(area.getAreaId());
            order.setConsigneeAreaname(consigneeAreaname);
            this.mallOrderInterface.updateOrder(order);
            MallOrderUpdateHistoryEntity historyEntity = new MallOrderUpdateHistoryEntity();
            historyEntity.setId(IDGenerate.getUniqueIdStr());
            historyEntity.setUserId("EDB");
            historyEntity.setOrderMainNo(orderSearch.getOrderMainNo());
            historyEntity.setOrderNo(orderNo);
            historyEntity.setCreateTime(DateUtils.now((String)""));
            historyEntity.setUpdateType(Integer.valueOf(22));
            StringBuilder oldAddr = new StringBuilder(orderSearch.getConsigneeName()).append(",").append(orderSearch.getConsigneePhone()).append(",").append(orderSearch.getConsigneeAreaid()).append(",").append(orderSearch.getConsigneeAddr());
            StringBuilder newAddr = new StringBuilder(order.getConsigneeName()).append(",").append(order.getConsigneePhone()).append(",").append(order.getConsigneeAreaid()).append(",").append(order.getConsigneeAddr());
            historyEntity.setOldValue(oldAddr.toString());
            historyEntity.setNewValue(newAddr.toString());
            historyEntity.setValueStr("\u5546\u57ce");
            this.mallOrderInterface.insertOrderUpdateHistory(historyEntity);
            baseJsonVo = returnBaseJson = BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                returnBaseJson = BaseJsonVo.error((String)sw.toString());
                throw e;
            }
            catch (Throwable throwable) {
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("modify");
                entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                entity.setDirection(Integer.valueOf(1));
                entity.setCreateTime(DateUtils.now());
                entity.setSyncName("EDB");
                entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                entity.setWarnLevel(Integer.valueOf(5));
                entity.setOrderNo(orderNo);
                entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                this.orderSyncInfoService.recordInfo(entity);
                throw throwable;
            }
        }
        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
        entity.setApiName("modify");
        entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
        entity.setDirection(Integer.valueOf(1));
        entity.setCreateTime(DateUtils.now());
        entity.setSyncName("EDB");
        entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
        entity.setWarnLevel(Integer.valueOf(5));
        entity.setOrderNo(orderNo);
        entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
        this.orderSyncInfoService.recordInfo(entity);
        return baseJsonVo;
    }

    @RequestMapping(value={"/order/testrefund"})
    public BaseJsonVo testrefund(String activeNo) {
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setActiveNo(activeNo);
        boolean setResult = this.redisService.sadd(activeNo + ":activeNo:refunding", new Object[]{activeNo});
        if (!setResult) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u4e2d...");
        }
        List allList = this.mallOrderMainService.getOrderMainList(orderMainEntity);
        List unrefundList = allList.stream().filter(o -> o.getStatus() >= 2 && o.getStatus() < 20).collect(Collectors.toList());
        ExecutorService pool = Executors.newFixedThreadPool(1);
        pool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        pool.shutdown();
        return BaseJsonVo.success((Object)"\u9000\u6b3e\u4e2d...");
    }

    static /* synthetic */ PayOrderInterface access$000(EdbController x0) {
        return x0.payOrderInterface;
    }
}

