/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.index;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.apiinvoke.bi.TrackInvoke;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.scrollpic.ScrollPicTypeEnum;
import cc.lechun.common.enums.sync.DataSyncStatusEnum;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.object.SpELUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.scrollpic.MallScrollPicDetailEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicDetailInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/index"})
public class IndexController {
    private static final Logger log = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private DeliverInterface deliverService;
    @Autowired
    private MallScrollPicDetailInterface mallScrollPicDetailInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    MallDataSyncInterface syncInterface;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private PrepayCardItemInterface cardItemInterface;
    @Autowired
    private PrepayCardBatchInterface cardBatchInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private TrackInvoke trackInvoke;

    @RequestMapping(value={"getIndexNavProductList"})
    @ResponseBody
    public BaseJsonVo getIndexNavProductList(int itemType) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        String customerId = "";
        if (customerDetailVo != null) {
            customerId = customerDetailVo.getCustomerId();
        }
        return this.indexItemInterface.getIndexNavProductList(Integer.valueOf(platformId), customerId, itemType);
    }

    @RequestMapping(value={"getProductListByIndexNav"})
    @ResponseBody
    public BaseJsonVo getProductListByIndexNav(String indexNavId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        int platformId = this.customerLoginService.getPlatFormId();
        String customerId = "";
        if (customerDetailVo != null) {
            customerId = customerDetailVo.getCustomerId();
        }
        return BaseJsonVo.success((Object)this.indexItemInterface.getIndexNavVo(indexNavId, customerId, Integer.valueOf(platformId)));
    }

    @RequestMapping(value={"getProductList"})
    @ResponseBody
    public BaseJsonVo getProductList(int itemType) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
            String customerId = "";
            if (customerDetailVo != null) {
                customerId = customerDetailVo.getCustomerId();
            }
            baseJsonVo = this.indexItemInterface.getIndexNavProductList(Integer.valueOf(platformId), customerId, itemType);
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getProductListByTicketBatchId"})
    @ResponseBody
    public BaseJsonVo getProductListByTicketBatchId(String ticketBatchId, Integer ticketCustomerId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getCashticketCustomer(ticketCustomerId.intValue());
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f18\u60e0\u5238");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u4f18\u60e0\u5238\u6279\u6b21");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", this.indexItemInterface.getIndexNavProductListWithoutSpeedupNoLogin(customerDetailVo.getPlatformId(), customerDetailVo.getCustomerId(), Integer.valueOf(0), cashticketCustomerEntity.getTicketBatchId()));
        map.put("minUseamount", cashticketBatchEntity.getMinUseamount());
        map.put("ticketAmount", cashticketCustomerEntity.getTicketAmount());
        map.put("ticketAmount", cashticketCustomerEntity.getTicketAmount());
        map.put("discountMode", MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2));
        String str = "";
        if (cashticketBatchEntity.getMinUseamount().doubleValue() == 0.0) {
            str = "\u65e0\u95e8\u69db";
        } else {
            str = new BigDecimal(cashticketBatchEntity.getMinUseamount().intValue()).compareTo(cashticketBatchEntity.getMinUseamount()) == 0 ? str + "\u6ee1" + cashticketBatchEntity.getMinUseamount().intValue() + "\u5143" : str + "\u6ee1" + cashticketBatchEntity.getMinUseamount().doubleValue() + "\u5143";
            if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                str = new BigDecimal(cashticketCustomerEntity.getTicketAmount().intValue()).compareTo(cashticketCustomerEntity.getTicketAmount()) == 0 ? str + "\u51cf" + cashticketCustomerEntity.getTicketAmount().intValue() : str + "\u51cf" + cashticketCustomerEntity.getTicketAmount().doubleValue();
            } else if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                BigDecimal zhe = MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2);
                str = new BigDecimal(zhe.intValue()).compareTo(zhe) == 0 ? str + "\u6253" + zhe.intValue() + "\u6298" : str + "\u6253" + (String.valueOf(zhe.doubleValue()).endsWith("0") ? String.valueOf(zhe.doubleValue()).substring(0, String.valueOf(zhe.doubleValue()).length() - 2) : String.valueOf(zhe.doubleValue()));
            }
        }
        map.put("useDesc", str);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"getFirstPageCount"})
    @ResponseBody
    public BaseJsonVo getFirstPageCount() throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        baseJsonVo.setStatus(200);
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (customerDetailVo == null) {
                map.put("cashCount", 0);
                map.put("balance", 0);
                map.put("isSubscribe", 0);
                int orderCount = 0;
                map.put("isNew", orderCount == 0 ? 1 : 0);
                map.put("isNew2", orderCount == 2 ? 1 : 0);
                map.put("isNew5", orderCount == 5 ? 1 : 0);
                HashMap<String, Object> mapIsOpen = new HashMap<String, Object>();
                mapIsOpen.put("isin", 0);
                mapIsOpen.put("isopen", "0");
                mapIsOpen.put("message", "");
                map.put("isOpen", mapIsOpen);
                HashMap<String, Object> mapVip = new HashMap<String, Object>();
                mapVip.put("isVip", 0);
                mapVip.put("vipOrderCount", 0);
                mapVip.put("maxLevelOrderShort", 0);
                mapVip.put("vipDay", this.vipInterface.getMallVipDay());
                HashMap vipTask = new HashMap();
                mapVip.put("vipTask", vipTask);
                map.put("vipInfo", mapVip);
                baseJsonVo.setValue(map);
                return baseJsonVo;
            }
            map.put("cashCount", this.cashticketCustomerInterface.getCashticketCount(customerDetailVo.getCustomerId(), Integer.valueOf(1)));
            map.put("balance", this.accountBalanceInterface.getGiftBalanceById(customerDetailVo.getCustomerId()));
            map.put("isSubscribe", customerDetailVo.getSubscribe());
            int orderCount = this.orderMainInterface.getOrderCount(customerDetailVo.getCustomerId(), Integer.valueOf(3), Integer.valueOf(16));
            map.put("isNew", orderCount == 0 ? 1 : 0);
            map.put("isNew2", orderCount == 2 ? 1 : 0);
            map.put("isNew5", orderCount == 5 ? 1 : 0);
            HashMap<String, Object> mapIsOpen = new HashMap<String, Object>();
            mapIsOpen.put("isin", 0);
            mapIsOpen.put("isopen", "0");
            mapIsOpen.put("message", "");
            map.put("isOpen", mapIsOpen);
            MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
            Map mapVip = ObjectConvert.objectConvertToObjectMap((Object)vipEntity);
            mapVip.put("isVip", String.valueOf(vipEntity == null ? 0 : (vipEntity.getLevel() > 0 ? 1 : 0)));
            mapVip.put("vipOrderCount", String.valueOf(this.orderInterface.getUserOrderCount(customerDetailVo.getCustomerId())));
            mapVip.put("maxLevelOrderShort", String.valueOf(this.vipInterface.getMaxLevelOrderShort(customerDetailVo.getCustomerId())));
            mapVip.put("vipDay", this.vipInterface.getMallVipDay());
            mapVip.put("isVipDay", this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
            Map vipTask = this.vipInterface.pushCustomerTask(customerDetailVo.getCustomerId());
            if (vipTask != null && vipTask.keySet().size() == 0) {
                vipTask = null;
            }
            mapVip.put("vipTask", vipTask);
            map.put("vipInfo", mapVip);
            baseJsonVo.setValue(map);
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getIndexNavList"})
    @ResponseBody
    public BaseJsonVo getIndexNavList() throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        return BaseJsonVo.success((Object)this.indexItemInterface.getIndexNavList(Integer.valueOf(platformId)));
    }

    @RequestMapping(value={"getItemDetail"})
    @ResponseBody
    public BaseJsonVo getItemDetail(String itemId, int itemType, Integer isQuick, String bindCode) throws AuthorizeException {
        if (StringUtils.isEmpty((String)itemId)) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        int platformId = this.customerLoginService.getPlatFormId();
        if (isQuick == null) {
            isQuick = 0;
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            MallVipEntity vipEntity;
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
            String customerId = "";
            if (customerDetailVo != null) {
                customerId = customerDetailVo.getCustomerId();
            }
            baseJsonVo = this.indexItemInterface.getItemDetail(customerId, itemId, itemType, Integer.valueOf((vipEntity = this.vipInterface.getUserVipInfo(customerId)) == null || vipEntity.getLevel() == null ? 0 : vipEntity.getLevel()));
            if (itemType == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                PrepayCardItemEntity cardItemEntity;
                MallIndexProductVo vo = (MallIndexProductVo)baseJsonVo.getValue();
                vo.setSpeedUp(String.valueOf(isQuick));
                int productStock = this.deliverService.getProductStock(customerId, vo.getProductId());
                vo.setSpeedupStockNum(productStock);
                if (StringUtils.isNotEmpty((String)bindCode) && (cardItemEntity = this.cardItemInterface.getCardItemEntityByBindCode(bindCode, Integer.valueOf(itemType), itemId)) != null) {
                    MallShoppingcartEntity shoppingcartEntity;
                    vo.setSaleValue(cardItemEntity.getSaleValue());
                    vo.setCardOriginPrice(cardItemEntity.getOriginPrice());
                    PrepayCardBatchEntity entity = new PrepayCardBatchEntity();
                    entity.setBindCode(bindCode);
                    entity = (PrepayCardBatchEntity)this.cardBatchInterface.getSingle((Object)entity);
                    if (entity != null) {
                        vo.setLimitMinCount(Integer.valueOf(entity.getPerPrice().intValue()));
                        BaseJsonVo jsonVo = this.balanceAccountInvoke.getSpecialTotal(customerId, entity.getCardType());
                        if (jsonVo.isSuccess()) {
                            vo.setTotalSaleValue((BigDecimal)jsonVo.getValue());
                        }
                    }
                    if ((shoppingcartEntity = this.shoppingcartInterface.getShoppingCart(customerId, itemId, bindCode)) != null) {
                        vo.setQuantity(shoppingcartEntity.getQuantity());
                    }
                }
            }
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"getScrollPicDetailList"})
    @ResponseBody
    public BaseJsonVo getScrollPicDetailList() throws AuthorizeException {
        int platFormId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        CustomerEntity customerEntity = null;
        MallVipEntity mallVipEntity = null;
        if (customerDetailVo != null) {
            customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
            mallVipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
        }
        HashMap<String, String> replace_map = new HashMap<String, String>();
        replace_map.put("indexPageVipDesc", "<b>\u798f\u5229</b>\u53d1\u653e\u4e2d");
        if (mallVipEntity != null && mallVipEntity.getLevel() != null && mallVipEntity.getLevel() != 0) {
            replace_map.put("indexPageVipDesc", "\u4f1a\u5458\u7b49\u7ea7<b>V" + mallVipEntity.getLevel() + "</b>");
        }
        List rs_banner = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageBanner.getValue());
        rs_banner = this.validCustomer(rs_banner, customerEntity, mallVipEntity, replace_map);
        List rs_ggw = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageGGW.getValue());
        rs_ggw = this.validCustomer(rs_ggw, customerEntity, mallVipEntity, replace_map);
        List rs_ksrk = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageKSRK.getValue());
        rs_ksrk = this.validCustomer(rs_ksrk, customerEntity, mallVipEntity, replace_map);
        List rs_kp = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, ScrollPicTypeEnum.mainPageKP.getValue());
        rs_kp = this.validCustomer(rs_kp, customerEntity, mallVipEntity, replace_map);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("banner", rs_banner);
        map.put("ggw", rs_ggw);
        map.put("ksrk", rs_ksrk);
        map.put("kpt", rs_kp);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"getImageTextLinkList"})
    @ResponseBody
    public BaseJsonVo getImageTextLinkList(int picType) throws AuthorizeException {
        int platFormId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        CustomerEntity customerEntity = null;
        MallVipEntity mallVipEntity = null;
        if (customerDetailVo != null) {
            customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
            mallVipEntity = this.vipInterface.getUserVipInfo(customerDetailVo.getCustomerId());
        }
        List ls = this.mallScrollPicDetailInterface.getVailMallScrollPicDetailList(platFormId, picType);
        this.validCustomer(ls, customerEntity, mallVipEntity, null);
        return BaseJsonVo.success((Object)ls);
    }

    private List<MallScrollPicDetailEntity> validCustomer(List<MallScrollPicDetailEntity> rs, CustomerEntity customerEntity, MallVipEntity mallVipEntity, HashMap replace_map) {
        if (rs != null && rs.size() > 0) {
            return rs.stream().filter(mallScrollPicDetailEntity -> {
                if (replace_map != null && replace_map.size() > 0) {
                    mallScrollPicDetailEntity.setSummary(this.replaceVariable(mallScrollPicDetailEntity.getSummary(), replace_map));
                }
                if (mallScrollPicDetailEntity.getScrollType() != 0) {
                    if (mallVipEntity != null && mallVipEntity.getLevel() != null) {
                        if (mallScrollPicDetailEntity.getScrollType() == 1 ? mallVipEntity.getLevel() == 0 : mallScrollPicDetailEntity.getScrollType() == 2 && mallVipEntity.getLevel() != 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (mallScrollPicDetailEntity.getUserType() != 0) {
                    if (customerEntity != null) {
                        if (mallScrollPicDetailEntity.getUserType() == 1 ? customerEntity.getIsNew() != 1 : mallScrollPicDetailEntity.getUserType() == 2 && customerEntity.getIsNew() != 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        }
        return rs;
    }

    private String replaceVariable(String str, HashMap map) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        return SpELUtils.readExpr((String)str, (Map)map);
    }

    @RequestMapping(value={"health"})
    @ResponseBody
    public BaseJsonVo health() throws AuthorizeException {
        return BaseJsonVo.success((Object)"success");
    }

    @RequestMapping(value={"dic"})
    @ResponseBody
    public BaseJsonVo dic() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.dictionaryInterface.getValidDictionaryList(Integer.valueOf(1), Integer.valueOf(8)));
    }

    @RequestMapping(value={"consumer"})
    @ResponseBody
    public BaseJsonVo consumer(int billType, int synchroStatus) throws AuthorizeException {
        return this.syncInterface.consumerData(DataSyncTypeEnum.valueOf((String)DataSyncTypeEnum.getName((int)billType)), DataSyncStatusEnum.valueOf((String)DataSyncStatusEnum.getName((int)synchroStatus)));
    }

    @RequestMapping(value={"getTestProductListByIndexNav"})
    @ResponseBody
    public BaseJsonVo getTestProductListByIndexNav(String indexNavId) throws AuthorizeException {
        int platformId = 4;
        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"");
        String customerId = "10003355426914989387638";
        return BaseJsonVo.success((Object)this.indexItemInterface.getIndexNavVo(indexNavId, customerId, Integer.valueOf(platformId)));
    }

    @RequestMapping(value={"getTestIndexNavProductList"})
    @ResponseBody
    public BaseJsonVo getTestIndexNavProductList(int itemType, int platformId) throws AuthorizeException {
        return this.indexItemInterface.getIndexNavProductList(Integer.valueOf(platformId), "10003355426914989387638", itemType);
    }

    @RequestMapping(value={"updateMiniVersion"})
    @ResponseBody
    public BaseJsonVo updateMiniVersion() {
        List dictionaryEntities = this.dictionaryInterface.getValidDictionaryList(Integer.valueOf(1000), Integer.valueOf(220));
        if (dictionaryEntities.stream().filter(c -> c.getDictionaryKey().equals("version") && c.getDictionaryName().equals("1")).count() > 0L) {
            return BaseJsonVo.success((Object)1);
        }
        return BaseJsonVo.success((Object)0);
    }

    @RequestMapping(value={"trackTest"})
    @ResponseBody
    public BaseJsonVo trackTest() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderMainNo", "1234567890");
        map.put("orderAmount", 123.5);
        throw new Exception("");
    }
}

