/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.prepay;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailProductItemVo;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"prepay"})
public class PrepayController {
    private static final Logger log = LoggerFactory.getLogger(PrepayController.class);
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private PrepayCardInterface cardInterface;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallOrderPlanDomainInterface orderPlanDomainInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @RequestMapping(value={"savePointCardOrderPlan"})
    public BaseJsonVo saveOrderPlan(int detailedId) {
        return this.orderPlanDomainInterface.saveOrderPlan(detailedId);
    }

    @RequestMapping(value={"createPlanOrder"})
    public BaseJsonVo createPlanOrder(String date) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtil.isEmpty((String)date)) {
            this.planDetailInterface.createPlanOrder(DateUtils.currentDate());
        } else {
            this.planDetailInterface.createPlanOrder(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getOrderPlanList"})
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        return this.prepayCardOrderPlanService.getOrderPlanList(orderMainNo);
    }

    @RequestMapping(value={"getCardInfo"})
    public BaseJsonVo getCardInfo(String orderMainNo) {
        return this.prepayCardOrderPlanService.getCardInfo(orderMainNo);
    }

    @RequestMapping(value={"refundOrderPlan"})
    public BaseJsonVo refundOrderPlan(String orderMainNo, BigDecimal amount, List<PrepayCardDetailProductItemVo> productList, String operator) {
        return this.prepayCardOrderPlanService.refundOrderPlan(orderMainNo, amount, productList, operator);
    }

    @RequestMapping(value={"getMyCardList"})
    public BaseJsonVo getMyCardList() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getMyCardList(customerDetailVo.getCustomerId()));
    }

    @RequestMapping(value={"getCardList"})
    public BaseJsonVo getCardList(Integer cardStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getCardList(customerDetailVo.getCustomerId(), Integer.valueOf(cardStatus == null ? 1 : cardStatus)));
    }

    @RequestMapping(value={"getPreCardList"})
    public BaseJsonVo getPreCardList(Integer cardStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getMyCardList(customerDetailVo.getCustomerId(), Integer.valueOf(cardStatus == null ? 1 : cardStatus)));
    }

    @RequestMapping(value={"getBuyCardList"})
    public BaseJsonVo getBuyCardList(Integer cardType) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getBuyCardList(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformGroupId().intValue(), cardType == null ? 1 : cardType));
    }

    @RequestMapping(value={"getHistoryCardList"})
    public BaseJsonVo getHistoryCardList(Integer cardStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getHistoryCardList(customerDetailVo.getCustomerId(), cardStatus));
    }

    @RequestMapping(value={"getFirstDeliveryDate"})
    public BaseJsonVo getFirstDeliveryDate(PrepayCardEntity prepayCardEntity) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        prepayCardEntity.setBelongCustomerId(customerDetailVo.getCustomerId());
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardEntity.getPeriodType().intValue(), prepayCardEntity.getPeriod()));
    }

    @RequestMapping(value={"saveOrderPlanDetailed"})
    public BaseJsonVo saveOrderPlanDetailed(PrepayCardDo prepayCardDo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (prepayCardDo.getPeriodType() == 1) {
            Date firstDate = this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardDo);
            Long day = DateUtils.getDateDiff((Date)DateUtils.now(), (Date)firstDate);
            if (day > 180L) {
                return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)firstDate, (String)"yyyy-MM-dd") + ",\u79bb\u73b0\u5728\u8d85\u8fc7:" + day + "\u5929,\u8bf7\u91cd\u65b0\u9009\u62e9!"));
            }
            String stopDeliver = "";
            Date startDate = new Date();
            Date endDate = new Date();
            List getValidDictionaryStopDeliverList = this.dictionaryInterface.getValidDictionaryList(Integer.valueOf(1000), Integer.valueOf(202));
            if (CollectionUtils.isNotEmpty((Collection)getValidDictionaryStopDeliverList) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(stopDeliver = ((DictionaryEntity)getValidDictionaryStopDeliverList.get(0)).getDictionaryName()))) {
                String[] arr = stopDeliver.split("-");
                String startStr = arr[0].replace(".", "-");
                String endStr = arr[1].replace(".", "-");
                startDate = DateUtils.getDateFromString((String)startStr, (String)"yyyy-MM-dd");
                endDate = DateUtils.getDateFromString((String)endStr, (String)"yyyy-MM-dd");
            }
            if (firstDate.after(startDate) && firstDate.before(endDate)) {
                return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)firstDate, (String)"yyyy-MM-dd") + " \u671f\u95f4\u4e0d\u53d1\u8d27\u8bf7\u91cd\u65b0\u9009\u62e9!"));
            }
        }
        return this.prepayCardOrderPlanService.saveOrderPlan(prepayCardDo, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"deleteOrderPlan"})
    public BaseJsonVo deleteOrderPlan(Integer detailedId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"createPlanOrderTest"})
    public BaseJsonVo createPlanOrder_test(String cardId) {
        return this.planDetailInterface.createPlanOrder(cardId, 1);
    }

    @RequestMapping(value={"saveDeliveryRule"})
    public BaseJsonVo saveDeliveryRule(PrepayCardDo prepayCardDo) throws AuthorizeException {
        BaseJsonVo baseJsonVo;
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int platformId = this.customerLoginService.getPlatFormId();
        if (prepayCardDo.getPeriodType() == 1) {
            Date firstDate = this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardDo);
            Long day = DateUtils.getDateDiff((Date)DateUtils.now(), (Date)firstDate);
            if (day > 180L) {
                return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)firstDate, (String)"yyyy-MM-dd") + ",\u79bb\u73b0\u5728\u8d85\u8fc7:" + day + "\u5929,\u8bf7\u91cd\u65b0\u9009\u62e9!"));
            }
            String stopDeliver = "";
            Date startDate = new Date();
            Date endDate = new Date();
            List getValidDictionaryStopDeliverList = this.dictionaryInterface.getValidDictionaryList(Integer.valueOf(1000), Integer.valueOf(202));
            if (CollectionUtils.isNotEmpty((Collection)getValidDictionaryStopDeliverList) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(stopDeliver = ((DictionaryEntity)getValidDictionaryStopDeliverList.get(0)).getDictionaryName()))) {
                String[] arr = stopDeliver.split("-");
                String startStr = arr[0].replace(".", "-");
                String endStr = arr[1].replace(".", "-");
                startDate = DateUtils.getDateFromString((String)startStr, (String)"yyyy-MM-dd");
                endDate = DateUtils.getDateFromString((String)endStr, (String)"yyyy-MM-dd");
            }
            if (firstDate.after(startDate) && firstDate.before(endDate)) {
                return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)firstDate, (String)"yyyy-MM-dd") + " \u671f\u95f4\u4e0d\u53d1\u8d27\u8bf7\u91cd\u65b0\u9009\u62e9!"));
            }
        }
        if ((baseJsonVo = this.prepayCardOrderPlanService.saveDeliverRule(prepayCardDo, platformId)).isSuccess()) {
            this.planDetailInterface.createPlanOrder(prepayCardDo.getCardId(), platformId);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"suspendDeliveryPlan"})
    public BaseJsonVo suspendDeliveryPlan(String cardId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.prepayCardOrderPlanService.suspendDeliveryPlan(cardId);
    }

    @RequestMapping(value={"getCardPlanDetail"})
    public BaseJsonVo getCardPlanDetail(HttpServletRequest request, String cardId) throws AuthorizeException, Exception {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        int platformId = this.customerLoginService.getPlatFormId();
        return this.prepayCardOrderPlanService.getCardPlanDetail(customerDetailVo.getCustomerId(), cardId, Integer.valueOf(platformId), ip);
    }

    @RequestMapping(value={"test112"})
    public BaseJsonVo orderPaySuccessUpdateCardPlanStatus(Integer num, String cardId) {
        for (int i = 0; i < num; ++i) {
            this.planDetailInterface.createPlanOrder(cardId, 1);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"exchange"})
    public BaseJsonVo exchange(String card) throws AuthorizeException {
        if (StringUtils.isEmpty((String)card)) {
            return BaseJsonVo.error((String)"\u8bf7\u8f93\u5165\u5361\u5bc6");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.cardInterface.exchange(customerDetailVo.getCustomerId(), card);
    }

    @RequestMapping(value={"testCardMyList"})
    public BaseJsonVo testCardMyList(String customerId, Integer cardUseStatus) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getCardList(customerId, cardUseStatus));
    }

    @RequestMapping(value={"testDeliverDay"})
    public BaseJsonVo testDeliverDay(PrepayCardDo prepayCardDo) {
        if (prepayCardDo.getPeriodType() == 1) {
            Date firstDate = this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardDo);
            Long day = DateUtils.getDateDiff((Date)DateUtils.now(), (Date)firstDate);
            if (day > 60L) {
                return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)firstDate, (String)"yyyy-MM-dd") + ",\u79bb\u73b0\u5728\u8d85\u8fc7:" + day + "\u5929,\u8bf7\u91cd\u65b0\u9009\u62e9!"));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testBuyCardList"})
    public BaseJsonVo testBuyCardList(String customerId) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getBuyCardList(customerId, 1000));
    }

    @RequestMapping(value={"testHistoryCardList"})
    public BaseJsonVo testHistoryCardList(String customerId, Integer cardStatus) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getHistoryCardList(customerId, cardStatus));
    }

    @RequestMapping(value={"testSaveRule"})
    public BaseJsonVo testSaveRule(PrepayCardDo prepayCardDo) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.saveDeliverRule(prepayCardDo, 1));
    }

    @RequestMapping(value={"testPushMessage"})
    public BaseJsonVo testPushMessage(Integer num, String cardId) {
        this.cardInterface.pushFinshMessage();
        this.cardInterface.pushActivedMessage();
        this.cardInterface.pushProcessMessage();
        this.cardInterface.pushExpiredMessage();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getPrepayCardItem"})
    public BaseJsonVo getPrepayCardItem(String bindCode, Integer detailedId) throws AuthorizeException {
        log.info("bindCode:{},detailedId={}", (Object)bindCode, (Object)detailedId);
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        String customerId = customerDetailVo.getCustomerId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        BaseJsonVo jsonVo = this.prepayCardItemInterface.getPrepayCardItem(customerId, bindCode);
        map.put("item", jsonVo.isSuccess() ? jsonVo.getValue() : new ArrayList());
        PrepayCardBatchEntity entity = new PrepayCardBatchEntity();
        entity.setBindCode(bindCode);
        entity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.getSingle((Object)entity);
        if (entity != null) {
            map.put("limitMinCount", entity.getPerPrice().intValue());
            BaseJsonVo jsonVo1 = this.balanceAccountInvoke.getSpecialTotal(customerId, entity.getCardType());
            if (jsonVo1.isSuccess()) {
                BigDecimal unUsedPoint = (BigDecimal)jsonVo1.getValue();
                map.put("saleValue", unUsedPoint);
                List pointPlanList = this.prepayCardOrderPlanService.getPointPrepayCardDetailEntityList(customerId);
                if (CollectionUtils.isNotEmpty((Collection)pointPlanList)) {
                    Optional<PrepayCardDetailEntity> thisDetail;
                    if (detailedId != null && (thisDetail = pointPlanList.stream().filter(d -> Objects.equals(d.getDetailedId(), detailedId)).findFirst()).isPresent()) {
                        unUsedPoint = PriceUtils.add((BigDecimal)unUsedPoint, (BigDecimal)thisDetail.get().getPricePoint());
                    }
                    BigDecimal usedPoint = pointPlanList.stream().map(PrepayCardDetailEntity::getPricePoint).reduce(BigDecimal.ZERO, BigDecimal::add);
                    map.put("saleValue", PriceUtils.subtract((BigDecimal)unUsedPoint, (BigDecimal)usedPoint));
                }
            }
        }
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"manualCreateCardByPaySuccessOrder"})
    public BaseJsonVo manualCreateCardByPaySuccessOrder(String orderMainNo) {
        return this.cardInterface.orderPaySuccessCreateCard(orderMainNo);
    }
}

