/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.qrcode;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.qrcode.QrcodeSubEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubVO;
import cc.lechun.mall.idomain.qrcode.IQrcodeDomain;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeInterface;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qr"})
public class QrcodeController {
    @Autowired
    private IQrcodeDomain qrcodeDomain;
    @Autowired
    private QrcodeInterface qrcodeService;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    DictionaryInterface dictionaryService;

    @RequestMapping(value={"linkPage"})
    public void linkPage(HttpServletRequest request, HttpServletResponse response, Integer qrcodeId) throws IOException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        QrcodeSubEntity qrcodeSubEntity = this.qrcodeDomain.currentQrcodeSub(qrcodeId, customerDetailVo != null ? customerDetailVo.getCustomerId() : "");
        if (qrcodeSubEntity == null) {
            qrcodeSubEntity = new QrcodeSubEntity();
            String url = this.dictionaryService.getDictionary(1000, 59, "WECHAT_URL").getDictionaryName() + "&qrcodeId=" + qrcodeId;
            qrcodeSubEntity.setSubQrUrl(url);
        } else if (StringUtils.isEmpty((String)qrcodeSubEntity.getSubQrUrl())) {
            String url = this.dictionaryService.getDictionary(1000, 59, "WECHAT_URL").getDictionaryName() + "&qrcodeId=" + qrcodeId;
            qrcodeSubEntity.setSubQrUrl(url);
        } else {
            Boolean bl = this.qrcodeDomain.qrcodeScan(qrcodeSubEntity.getId(), customerDetailVo != null ? customerDetailVo.getCustomerId() : "");
        }
        response.sendRedirect(qrcodeSubEntity.getSubQrUrl());
    }

    @RequestMapping(value={"getQrcode"})
    public BaseJsonVo getQrcode(Integer qrcodeId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        QrcodeSubVO qrcodeSubVo = this.qrcodeDomain.nextQrcodeSub(qrcodeId, customerDetailVo != null ? customerDetailVo.getCustomerId() : "");
        return BaseJsonVo.success((Object)qrcodeSubVo);
    }

    @RequestMapping(value={"scan"})
    public BaseJsonVo scan(Integer qrcodeSubId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        Boolean scan = this.qrcodeDomain.qrcodeScan(qrcodeSubId, customerDetailVo.getCustomerId());
        return scan != false ? BaseJsonVo.success(null) : BaseJsonVo.error((String)"\u8bb0\u5f55\u626b\u7801\u6210\u529f");
    }
}

