/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.shoppingcart;

import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.weixin.MiniApiInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.api.shop.OrderAPI;
import weixin.popular.bean.shop.order.MiniShopOrderResult;

@RestController
@RequestMapping(value={"shoppingcart"})
public class MallShoppingcartController {
    private static final Logger log = LoggerFactory.getLogger(MallShoppingcartController.class);
    @Autowired
    MallShoppingcartInterface cartService;
    @Autowired
    CustomerLoginService customerLoginService;
    @Autowired
    CustomerAddressInterface addressService;
    @Autowired
    MallDataSyncInterface dataSyncInterface;
    @Autowired
    MallIndexItemInterface indexItemInterface;
    @Autowired
    MiniApiInterface miniApiInterface;
    @Autowired
    MallOrderSyncInfoInterface mallOrderSyncInfoInterface;
    @Autowired
    ReunionProductInterface reunionProductInterface;
    @Autowired
    WeiXinBaseInterface weiXinBaseInterface;

    @RequestMapping(value={"cartCountWithSaleId"})
    public BaseJsonVo cartCountWithSaleId(HttpServletRequest request, String saleId, @Nullable String shoppingType) throws Exception {
        CustomerDetailVo customer;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((customer = this.customerLoginService.getCustomer(false)) == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartCountWithSaleId(customer.getPlatformId(), customer.getCustomerId(), saleId, shoppingType);
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u6570\u91cf\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartCount"})
    public BaseJsonVo cartCount(HttpServletRequest request, String shoppingType) throws Exception {
        CustomerDetailVo customer;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((customer = this.customerLoginService.getCustomer(false)) == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartCount(customer.getPlatformId(), customer.getCustomerId(), shoppingType);
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u6570\u91cf\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartListCount"})
    public BaseJsonVo cartListCount(HttpServletRequest request, String shoppingType) throws Exception {
        CustomerDetailVo customer;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((customer = this.customerLoginService.getCustomer(false)) == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartListCount(customer.getPlatformId(), customer.getCustomerId(), shoppingType);
        if (cartSR.isSuccess()) {
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartList"})
    public BaseJsonVo cartList(HttpServletRequest request, String areaId, String address, String needLogin, Boolean isQuick, String shoppingType) throws Exception {
        try {
            CustomerDetailVo customer;
            if (StringUtils.isEmpty((String)shoppingType)) {
                shoppingType = "0";
            }
            if ((customer = this.customerLoginService.getCustomer(false)) == null && "0".equals(needLogin)) {
                BaseJsonVo cartSR = this.cartService.buildEmptyCart();
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            if (customer == null && !"0".equals(needLogin)) {
                throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
            }
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, isQuick, shoppingType);
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        catch (Exception e) {
            log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66\u62a5\u9519\u4e86", (Throwable)e);
            throw e;
        }
    }

    @RequestMapping(value={"testcartList"})
    public BaseJsonVo testcartList(HttpServletRequest request, String areaId, String address, String needLogin, Boolean isQuick, String shoppingType) throws Exception {
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress("10003402931799821447905", areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
        BaseJsonVo cartSR = this.cartService.buildCart(Integer.valueOf(4), "10003402931799821447905", addressVo, isQuick, shoppingType);
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"checkCart"})
    public BaseJsonVo checkCart(HttpServletRequest request, Integer checkType, String salesId, String areaId, String address, String shoppingType) throws Exception {
        CustomerDetailVo customer;
        BaseJsonVo result;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((result = this.cartService.checkCart((customer = this.customerLoginService.getCustomer(true)).getPlatformId(), customer.getCustomerId(), checkType, salesId, shoppingType)).isSuccess()) {
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false), shoppingType);
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"addCart"})
    public BaseJsonVo addCart(HttpServletRequest request, String salesId, String activeNo, Integer quantity, String areaId, String address, Boolean isQuick, String shoppingType) throws AuthorizeException, Exception {
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        if (quantity == 0) {
            return BaseJsonVo.success((Object)"");
        }
        Integer salesType = this.indexItemInterface.getProductType(salesId);
        if (salesType == null) {
            return BaseJsonVo.error((String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        BaseJsonVo addResult = this.cartService.addCart(customer.getPlatformId(), customer.getCustomerId(), salesType, salesId, activeNo, quantity, isQuick, shoppingType);
        if (addResult.isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, isQuick, shoppingType);
            if (cartSR.isSuccess()) {
                Map map = (Map)cartSR.getValue();
                BaseJsonVo cartListCountSR = this.cartService.buildCartListCount(customer.getPlatformId(), customer.getCustomerId(), shoppingType);
                if (cartListCountSR.isSuccess()) {
                    map.put("cartListCount", cartListCountSR.getValue());
                }
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)addResult.getError_msg());
    }

    @RequestMapping(value={"repurchase"})
    @ResponseBody
    public BaseJsonVo repurchase(String orderMainNo, String orderNo, Integer clearStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"removeCartProduct"})
    public BaseJsonVo removeCartProduct(HttpServletRequest request, String salesId, String areaId, String address, Boolean isQuick, String shoppingType) throws AuthorizeException, Exception {
        CustomerDetailVo customer;
        BaseJsonVo removeResult;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((removeResult = this.cartService.removeCartProduct((customer = this.customerLoginService.getCustomer(true)).getCustomerId(), salesId, shoppingType)).isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false), shoppingType);
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)removeResult.getError_msg());
    }

    @RequestMapping(value={"removeCartInvalid"})
    public BaseJsonVo removeCartInvalid(HttpServletRequest request, String areaId, String address, String shoppingType) throws AuthorizeException, Exception {
        CustomerDetailVo customer;
        BaseJsonVo removeResult;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((removeResult = this.cartService.removeCartInvalid((customer = this.customerLoginService.getCustomer(true)).getPlatformId(), customer.getCustomerId(), shoppingType)).isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false), shoppingType);
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)removeResult.getError_msg());
    }

    @RequestMapping(value={"addOnProducts"})
    public BaseJsonVo addOnProducts(Integer selfMadeType, String shoppingType) throws AuthorizeException {
        CustomerDetailVo customer;
        BaseJsonVo products;
        if (StringUtils.isEmpty((String)shoppingType)) {
            shoppingType = "0";
        }
        if ((products = this.cartService.findAddOnProducts((customer = this.customerLoginService.getCustomer(true)).getPlatformId(), customer.getCustomerId(), selfMadeType, shoppingType)).isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            return BaseJsonVo.success((Object)products.getValue());
        }
        return BaseJsonVo.error((String)products.getError_msg());
    }

    @RequestMapping(value={"findRecommends"})
    public BaseJsonVo findRecommends() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        List sales = this.cartService.findRecommends(customer.getPlatformGroupId(), "0");
        if (sales != null && sales.size() > 0) {
            return BaseJsonVo.success((Object)sales);
        }
        return BaseJsonVo.success((String)"\u65e0\u63a8\u8350\u5546\u54c1", null);
    }

    @RequestMapping(value={"test2"})
    public BaseJsonVo test2() {
        return this.cartService.buildShoppingcartProducts("10003355426914989387638", Boolean.valueOf(false), "1451443000458219520");
    }

    @RequestMapping(value={"test"})
    public BaseJsonVo test(Integer platFormId, String content, String orderMainNo, String orderNo, String type, String editHistoryId) {
        if ("1".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.DELETE);
        }
        if ("2".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.PAYCONFIRM);
        }
        if ("3".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.CANCEL);
        }
        if ("4".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.COMPLETION);
        }
        if ("5".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderModifyOrder(orderNo, Integer.valueOf(1));
        }
        if ("6".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrder(orderMainNo, orderNo);
        }
        if ("7".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderModifyProducts(orderNo, editHistoryId);
        }
        if ("8".equals(type)) {
            return this.mallOrderSyncInfoInterface.syncOrder(orderNo);
        }
        if ("9".equals(type)) {
            return this.reunionProductInterface.recoveryList(orderMainNo, orderNo);
        }
        if ("10".equals(type)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("out_order_id", orderMainNo);
            map.put("openid", orderNo);
            String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(platFormId).getAccessToken();
            MiniShopOrderResult order = OrderAPI.getOrder((String)accessToken, (String)JsonUtils.toJson(map, (boolean)false));
            log.info("\u83b7\u53d6\u8ba2\u5355\uff1a{}", (Object)order);
            return BaseJsonVo.success((Object)order);
        }
        return BaseJsonVo.success(null);
    }
}

