/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.trade;

import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.apiinvoke.bi.TrackInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.customer.MobileValidateTypeEnum;
import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.pay.PayOutputVo;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInCardVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInFreeVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MiniShopOrderVO;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/order"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    MallFreeInterface freeService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private CustomerAddressInterface addressInterface;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private CustomerMobileInterface customerMobileInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private TrackInvoke trackInvoke;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallProductInterface productService;

    @RequestMapping(value={"setOrderCache"})
    @ResponseBody
    public BaseJsonVo setOrderCache(Integer platFormId, Integer orderSource, String bindCode, Integer deliverType, Integer deliverCount, Integer deliverPeriod, String items, String defineField) throws AuthorizeException, UnsupportedEncodingException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(deliverCount.intValue());
        inVo.setDeliverPeriod(deliverPeriod.intValue());
        inVo.setDeliverType(deliverType.intValue());
        inVo.setOrderSource(orderSource == null ? OrderSourceEnum.CROWD.getValue() : orderSource.intValue());
        inVo.setBindCode(bindCode);
        inVo.setDefineField(defineField);
        items = URLDecoder.decode(items, "utf-8");
        log.info("platFormId={},orderSource={},deliverCount={},deliverType={},defineField:{},items={}", new Object[]{platFormId, orderSource, deliverCount, deliverType, defineField, items});
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List itemVoList = JsonUtils.getListByArray(MallOrderCacheInItemVo.class, (String)items);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        if (orderSource != null && cc.lechun.common.enums.trade.OrderSourceEnum.LONGPERIOD_BUY.getValue() == orderSource.intValue()) {
            BigDecimal amount = new BigDecimal(90);
            BigDecimal saleAmount = new BigDecimal(0);
            for (MallOrderCacheInItemVo c : itemVoList) {
                BaseJsonVo sr = this.productService.buildProductVO(c.getItemId(), Integer.valueOf(c.getQuantity()), Boolean.valueOf(true), Boolean.valueOf(true));
                if (!sr.isSuccess()) continue;
                saleAmount = saleAmount.add(((MallProductVO)sr.getValue()).getFactPrice().multiply(new BigDecimal(c.getQuantity())));
            }
            if (amount.compareTo(saleAmount) >= 0) {
                return BaseJsonVo.error((String)("\u64cd\u4f5c\u5931\u8d25,\u957f\u671f\u8ba2\u8d2d\u6ee1" + amount + "\u8d77\u9001,\u73b0\u5728" + saleAmount));
            }
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            baseJsonVo = this.tradeInterface.setOrderCache(platFormId.intValue(), customerDetailVo.getCustomerId(), inVo);
        }
        catch (Exception e) {
            e.getStackTrace();
            log.error("setOrderCache-error:", (Throwable)e);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"testSetOrderCache"})
    @ResponseBody
    public BaseJsonVo testSetOrderCache(Integer platFormId, Integer orderSource, String bindCode, Integer deliverType, Integer deliverCount, Integer deliverPeriod, String items, String defineField) throws AuthorizeException, UnsupportedEncodingException {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(deliverCount.intValue());
        inVo.setDeliverPeriod(deliverPeriod.intValue());
        inVo.setDeliverType(deliverType.intValue());
        inVo.setOrderSource(orderSource == null ? OrderSourceEnum.CROWD.getValue() : orderSource.intValue());
        inVo.setBindCode(bindCode);
        inVo.setDefineField(defineField);
        items = URLDecoder.decode(items, "utf-8");
        log.info("platFormId={},orderSource={},deliverCount={},deliverType={},defineField:{},items={}", new Object[]{platFormId, orderSource, deliverCount, deliverType, defineField, items});
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List itemVoList = JsonUtils.getListByArray(MallOrderCacheInItemVo.class, (String)items);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            baseJsonVo = this.tradeInterface.setOrderCache(platFormId.intValue(), "10003402931799821447905", inVo);
        }
        catch (Exception e) {
            e.getStackTrace();
            log.error("setOrderCache-error:", (Throwable)e);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"toPayPage"})
    @ResponseBody
    public BaseJsonVo toPayPage(int platFormId, String cacheId, String bindCode, int orderSource, String isQuick, String cardList, String speedUp, String exchangeItems, String ticketCustomerId, String deliverDate, String useBalance) throws AuthorizeException, UnsupportedEncodingException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (cc.lechun.common.enums.trade.OrderSourceEnum.RECHANGE_CARD.getValue() == orderSource) {
            BaseJsonVo jsonVo = this.tradeInterface.setOrderCacheByShoppingcat(customerDetailVo.getCustomerId(), Integer.valueOf(platFormId), Integer.valueOf(orderSource), bindCode, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "");
            if (jsonVo.isSuccess()) {
                cacheId = ((MallOrderCacheVo)jsonVo.getValue()).getCacheId();
            } else {
                return jsonVo;
            }
        }
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        if (StringUtils.isNotEmpty((String)ticketCustomerId)) {
            if ("-1".equals(ticketCustomerId)) {
                cacheVo.setChoseNoTicket(Boolean.valueOf(true));
            }
            String[] split = ticketCustomerId.split(",");
            ArrayList<Integer> selectCashList = new ArrayList<Integer>();
            for (String s : split) {
                selectCashList.add(Integer.valueOf(s));
            }
            cacheVo.setSelectCashList(selectCashList);
        }
        if (StringUtils.isNotEmpty((String)exchangeItems)) {
            if (!(exchangeItems = URLDecoder.decode(exchangeItems, "utf-8")).startsWith("[")) {
                exchangeItems = "[" + exchangeItems + "]";
            }
            log.info("exchangetItems={}", (Object)exchangeItems);
            List exchangeList = JsonUtils.getListByArray(MallOrderCacheInFreeVo.class, (String)exchangeItems);
            if (exchangeList != null && exchangeList.size() > 0) {
                cacheVo.setExchangeVoList(exchangeList);
            }
        } else {
            log.info("\u6ca1\u6709\u9009\u62e9\u52a0\u8d2d exchangetItems={}", (Object)exchangeItems);
        }
        if ("1".equals(isQuick)) {
            cacheVo.setIsQuick(1);
        }
        if (orderSource == cc.lechun.common.enums.trade.OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            cacheVo.setSpeedUp(0);
        } else if ("1".equals(speedUp)) {
            cacheVo.setSpeedUp(1);
        } else if ("0".equals(speedUp)) {
            cacheVo.setSpeedUp(0);
        }
        if (StringUtils.isNotEmpty((String)deliverDate)) {
            cacheVo.setDeliverDate(DateUtils.getDateFromString((String)deliverDate, (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)cardList)) {
            if (!(cardList = URLDecoder.decode(cardList, "utf-8")).startsWith("[")) {
                cardList = "[" + cardList + "]";
            }
            log.info("cardItems={}", (Object)cardList);
            List cardVoList = JsonUtils.getListByArray(MallOrderCacheInCardVo.class, (String)cardList);
            if (CollectionUtils.isNotEmpty((Collection)cardVoList)) {
                cacheVo.setCardList(cardVoList);
            }
        } else {
            log.info("\u7528\u6237:{}\u6ca1\u6709\u9009\u62e9\u5361 ", (Object)customerDetailVo.getCustomerId());
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.toPayPage(platFormId, customerDetailVo.getCustomerId(), cacheVo);
        if (baseJsonVo.isSuccess()) {
            if (StringUtils.isEmpty((String)customerDetailVo.getMobile())) {
                baseJsonVo.setUserInfoStatus(2);
            }
            MallMainOrderVo mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue();
            mallMainOrderVo.setUseBalance(useBalance);
            log.info("mallMainOrderVo={}", (Object)JSONObject.toJSONString((Object)mallMainOrderVo));
            if (mallMainOrderVo != null) {
                mallMainOrderVo.setOrderAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getOrderAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
                mallMainOrderVo.setTotalAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
                if (StringUtils.isEmpty((String)mallMainOrderVo.getOrderCacheVo().getCacheId())) {
                    mallMainOrderVo.getOrderCacheVo().setCacheId(cacheId);
                }
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"testCreateOrderFreeProduct"})
    @ResponseBody
    public BaseJsonVo testCreateOrderFreeProduct(String orderMainNo, String bindCode) throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtils.isNotEmpty((String)bindCode) && "1406490659019952128".equals(bindCode)) {
            return this.tradeInterface.addFreeProduct(orderMainNo);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"createOrderAndPay"})
    @ResponseBody
    public BaseJsonVo createOrderAndPay(int platFormId, String orderCacheJson, String isQuick, String exchangeItems, String cardList, String ncpBat, Integer chanId) throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo;
        String date;
        String message = "";
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
        if (this.memcachedService.isExceedCount("OrderController", "createOrderAndPay_" + customerDetailVo.getCustomerId(), 1, 2)) {
            return BaseJsonVo.error((String)"\u963f\u5076\uff01\u6b47\u6b47\u5427\uff0c\u4e0d\u8981\u7d2f\u5012\u5566~~~");
        }
        orderCacheJson = URLDecoder.decode(orderCacheJson, "utf-8");
        log.info("+++++createOrderAndPay.orderCacheJson+++orderCacheJson={}", (Object)orderCacheJson);
        MallOrderCacheVo orderCacheVo = (MallOrderCacheVo)JsonUtils.fromJson((String)orderCacheJson, MallOrderCacheVo.class);
        if (StringUtil.isNotEmpty((String)ncpBat)) {
            orderCacheVo.setNcpBat(ncpBat);
        }
        if (chanId != null) {
            orderCacheVo.setChanId(chanId);
        }
        if (StringUtils.isNotEmpty((String)exchangeItems)) {
            if (!(exchangeItems = URLDecoder.decode(exchangeItems, "utf-8")).startsWith("[")) {
                exchangeItems = "[" + exchangeItems + "]";
            }
            log.info("exchangetItems={}", (Object)exchangeItems);
            List exchangeList = JsonUtils.getListByArray(MallOrderCacheInFreeVo.class, (String)exchangeItems);
            if (exchangeList != null && exchangeList.size() > 0) {
                orderCacheVo.setExchangeVoList(exchangeList);
                if (customerEntity != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("payPrice", "{exchange:1}");
                    map.put("exchange", 1);
                    map.put("message", exchangeItems);
                    BaseJsonVo jsonVo = this.trackInvoke.trackDataNew(Integer.valueOf(platFormId), "pages/payment/index", "trade/createOrderAndPay", "\u652f\u4ed8\u9875", customerEntity.getSign(), Integer.valueOf(4), map);
                    log.info("\u6362\u8d2d track result:" + jsonVo.isSuccess() + jsonVo.getMessage());
                }
            }
        } else {
            log.info("\u7528\u6237:{}\u6ca1\u6709\u9009\u62e9\u6362\u8d2d", (Object)customerDetailVo.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)cardList)) {
            if (!(cardList = URLDecoder.decode(cardList, "utf-8")).startsWith("[")) {
                cardList = "[" + cardList + "]";
            }
            log.info("cardItems={}", (Object)cardList);
            List cardVoList = JsonUtils.getListByArray(MallOrderCacheInCardVo.class, (String)cardList);
            if (CollectionUtils.isNotEmpty((Collection)cardVoList)) {
                orderCacheVo.setCardList(cardVoList);
            }
        } else {
            log.info("\u7528\u6237:{}\u6ca1\u6709\u9009\u62e9\u5361 ", (Object)customerDetailVo.getCustomerId());
        }
        if (orderCacheVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606f");
        }
        if (Objects.equals(orderCacheVo.getOrderSource(), cc.lechun.common.enums.trade.OrderSourceEnum.RECHANGE_CARD.getValue())) {
            orderCacheVo.setMildCardPay(1);
            if (orderCacheVo.getDeliverDate() == null && orderCacheVo.getDeliveryType() != null && orderCacheVo.getDeliveryType() >= 1) {
                return BaseJsonVo.error((String)"\u5468\u671f\u9001\u6ca1\u6709\u5339\u914d\u5230\u65e5\u671f,\u8bf7\u9009\u62e9\u5355\u6b21\u914d\u9001\u8bd5\u8bd5");
            }
        }
        String string = date = orderCacheVo.getDeliverDate() == null ? "" : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)date)) {
            orderCacheVo.setDeliverDate(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        String string2 = date = orderCacheVo.getDeliverDate2() == null ? "" : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate2(), (String)"yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)date)) {
            orderCacheVo.setDeliverDate2(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        if ("1".equals(isQuick)) {
            orderCacheVo.setIsQuick(1);
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)"lechun_bindcode");
        if (cookie != null && cookie.getValue() != null) {
            orderCacheVo.setCookieBindCode(cookie.getValue());
        }
        if ((baseJsonVo = this.tradeInterface.createOrder(platFormId, customerDetailVo.getCustomerId(), orderCacheVo)).isSuccess()) {
            Map result = (Map)baseJsonVo.getValue();
            Object o = result.get("mainOrderNo");
            if (StringUtils.isNotEmpty((String)orderCacheVo.getBindCode()) && "1406490659019952128".equals(orderCacheVo.getBindCode())) {
                this.tradeInterface.addFreeProduct(o.toString());
            }
            PayOutputEntity payOutputEntity = this.payOrderInterface.topay(customerDetailVo.getCustomerId(), o.toString(), ip);
            PayOutputVo payOutputVo = new PayOutputVo();
            BeanUtils.copyProperties((Object)payOutputEntity, (Object)payOutputVo);
            payOutputVo.setPayAmount((BigDecimal)result.get("payAmount"));
            if (result.get("orderInfo") != null) {
                MiniShopOrderVO miniShopOrderVO = (MiniShopOrderVO)result.get("orderInfo");
                miniShopOrderVO.getOrder_detail().getPay_info().setPrepay_id(payOutputVo.getPrepayId());
                payOutputVo.setOrderInfo(ObjectConvert.beanToMap((Object)miniShopOrderVO));
            } else {
                payOutputVo.setOrderInfo(new HashMap());
            }
            return BaseJsonVo.success((Object)payOutputVo);
        }
        log.info("\u7528\u6237:{},\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", (Object)customerDetailVo.getCustomerId(), (Object)baseJsonVo.getMessage());
        if (customerEntity != null && baseJsonVo.getMessage().indexOf("\u5546\u54c1\u5df2\u552e\u7f44") >= 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("payPrice", "{soldOutPro:1}");
            map.put("soldOutPro", 1);
            BaseJsonVo jsonVo = this.trackInvoke.trackDataNew(Integer.valueOf(platFormId), "pages/payment/index", "trade/createOrderAndPay", "\u652f\u4ed8\u9875", customerEntity.getSign(), Integer.valueOf(4), map);
            log.info("\u5546\u54c1\u5df2\u552e\u7f44 track result:" + jsonVo.isSuccess() + jsonVo.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"spliteSourceOrder"})
    @ResponseBody
    public BaseJsonVo spliteSourceOrder() {
        return this.tradeInterface.spliteSourceOrder(DateUtils.now());
    }

    @RequestMapping(value={"spliteSourceOrderByOrder"})
    @ResponseBody
    public BaseJsonVo spliteSourceOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.tradeInterface.spliteSourceOrder(orderMainEntity);
    }

    @RequestMapping(value={"cancelCustomerOrder"})
    @ResponseBody
    public BaseJsonVo cancelCustomerOrder(String orderMainNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.cancelCustomerOrder(customerDetailVo.getCustomerId(), orderMainNo, 1);
        return baseJsonVo;
    }

    @RequestMapping(value={"deleteCustomerOrder"})
    @ResponseBody
    public BaseJsonVo deleteCustomerOrder(String orderMainNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.deleteCustomerOrder(customerDetailVo.getCustomerId(), orderMainNo);
        return baseJsonVo;
    }

    @RequestMapping(value={"getCustomerOrderList"})
    @ResponseBody
    public BaseJsonVo getCustomerOrderList(int statusClass, int pageSize, int pageCount) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        ArrayList orderList = this.tradeInterface.getOrderList(customerDetailVo.getCustomerId(), statusClass, pageSize, pageCount);
        if (orderList == null) {
            orderList = new ArrayList();
        }
        return BaseJsonVo.success((Object)orderList);
    }

    @RequestMapping(value={"getCustomerOrderDetail"})
    @ResponseBody
    public BaseJsonVo getCustomerOrderDetail(String orderMainNo, String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        OrderListVo orderListVo = this.tradeInterface.getOrderDetail(customerDetailVo.getCustomerId(), orderMainNo, orderNo);
        if (orderListVo == null) {
            return BaseJsonVo.error((String)"\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)orderListVo);
    }

    @RequestMapping(value={"repurchase"})
    @ResponseBody
    public BaseJsonVo repurchase(String orderMainNo, String orderNo, int clearStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int platformId = this.customerLoginService.getPlatFormId();
        return this.tradeInterface.repurchase(orderMainNo, orderNo, clearStatus, platformId, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"againTopay"})
    @ResponseBody
    public BaseJsonVo againTopay(String orderMainNo, int payTypeSubId) throws AuthorizeException {
        Optional<MallOrderPayEntity> orderPayEntity;
        List orderPayEntities;
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
        if (mallPayTypeEntity != null) {
            payTypeSubId = mallPayTypeEntity.getPaytypeId();
        }
        if ((orderPayEntities = this.orderPayInterface.getList(orderMainNo)) != null && orderPayEntities.size() > 0 && (orderPayEntity = orderPayEntities.stream().filter(c -> c.getCashType() == 1).findFirst()).isPresent()) {
            payTypeSubId = orderPayEntity.get().getPaySubtypeId();
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        PayOutputEntity payOutputEntity = this.payOrderInterface.againTopay(customerDetailVo.getCustomerId(), orderMainNo, payTypeSubId, ip);
        PayOutputVo payOutputVo = new PayOutputVo();
        BeanUtils.copyProperties((Object)payOutputEntity, (Object)payOutputVo);
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        payOutputVo.setPayAmount(orderMainEntity.getPayAmount());
        return BaseJsonVo.success((Object)payOutputVo);
    }

    @RequestMapping(value={"confirmGoods"})
    @ResponseBody
    public BaseJsonVo confirmGoods(String orderMainNo, String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.tradeInterface.confirmGoods(customerDetailVo.getCustomerId(), orderMainNo, orderNo == null ? "" : orderNo);
        return baseJsonVo;
    }

    @RequestMapping(value={"editOrderAddress"})
    @ResponseBody
    public BaseJsonVo editOrderAddress(String orderNo, String addressId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.orderInterface.editOrderAddress(customerDetailVo.getCustomerId(), orderNo, addressId);
        return baseJsonVo;
    }

    @RequestMapping(value={"editOrderDeliverDate"})
    @ResponseBody
    public BaseJsonVo editOrderDeliverDate(String orderNo, String deliverdate) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (StringUtils.isEmpty((String)orderNo) || StringUtils.isEmpty((String)deliverdate)) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        Date deliverDate = DateUtils.StrToDate((String)deliverdate, (String)"yyyy-MM-dd");
        if (deliverDate == null) {
            return BaseJsonVo.error((String)"\u914d\u9001\u65e5\u671f\u9519\u8bef");
        }
        BaseJsonVo baseJsonVo = this.orderInterface.editOrderDeliverDate(customerDetailVo.getCustomerId(), orderNo, deliverDate, null, Boolean.valueOf(false));
        return baseJsonVo;
    }

    @RequestMapping(value={"getorderdefaultdeliver"})
    @ResponseBody
    public BaseJsonVo getOrderDefaultDeliver(String orderno) throws AuthorizeException {
        return this.orderInterface.getOrderDefaultDeliverDate(orderno);
    }

    @RequestMapping(value={"getOrderEditProducts"})
    @ResponseBody
    public BaseJsonVo getOrderEditProducts(String orderno) throws AuthorizeException {
        return this.orderInterface.getOrderEditProducts(orderno);
    }

    @RequestMapping(value={"editOrderProducts"})
    @ResponseBody
    public BaseJsonVo editOrderProducts(String orderno, String products) throws AuthorizeException {
        ArrayList productList = new ArrayList();
        for (String pro : products.split(";")) {
            String[] proArray = pro.split(":");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proId", proArray[0]);
            map.put("count", proArray[1]);
            productList.add(map);
        }
        return this.orderInterface.editOrderProducts(orderno, productList, Boolean.valueOf(false));
    }

    @RequestMapping(value={"testCreateOrder"})
    @ResponseBody
    public BaseJsonVo Test() throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo;
        String date;
        String isQuick = "0";
        String cardList = "%5B%7B%22itemType%22%3A1%2C%22itemId%22%3A%221451443554110541824%22%2C%22batchId%22%3A129%2C%22quantity%22%3A1%7D%5D";
        Integer platFormId = 4;
        String orderCacheJson = "%7B%22cacheType%22%3A2%2C%22orderSource%22%3A0%2C%22cacheId%22%3A%22%22%2C%22bindCode%22%3A%22%22%2C%22ticketCustomerId%22%3A%22%22%2C%22addressId%22%3A%223392753488546108372%22%2C%22deliverDate%22%3A%222021-11-27%22%2C%22deliverDate2%22%3A%22%22%2C%22useAccountBalance%22%3A1%2C%22payPassword%22%3A%22e10adc3949ba59abbe56e057f20f883e%22%2C%22isOpenOrderPlan%22%3A-1%2C%22payType%22%3A12%2C%22miniformId%22%3A%22%22%2C%22giftType%22%3A0%2C%22isQuick%22%3A0%2C%22speedUp%22%3A%22%22%2C%22selectCashList%22%3A%5B%5D%7D";
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003355426914989387638");
        orderCacheJson = URLDecoder.decode(orderCacheJson, "utf-8");
        log.info("+++++createOrderAndPay.orderCacheJson+++orderCacheJson={}", (Object)orderCacheJson);
        MallOrderCacheVo orderCacheVo = (MallOrderCacheVo)JsonUtils.fromJson((String)orderCacheJson, MallOrderCacheVo.class);
        if (StringUtils.isNotEmpty((String)cardList)) {
            if (!(cardList = URLDecoder.decode(cardList, "utf-8")).startsWith("[")) {
                cardList = "[" + cardList + "]";
            }
            log.info("cardItems={}", (Object)cardList);
            List cardVoList = JsonUtils.getListByArray(MallOrderCacheInCardVo.class, (String)cardList);
            if (CollectionUtils.isNotEmpty((Collection)cardVoList) && cardVoList.size() > 0) {
                orderCacheVo.setCardList(cardVoList);
            }
        } else {
            log.info("\u7528\u6237:{}\u6ca1\u6709\u9009\u62e9\u5361 ", (Object)customerDetailVo.getCustomerId());
        }
        if (orderCacheVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606f");
        }
        if (Objects.equals(orderCacheVo.getOrderSource(), cc.lechun.common.enums.trade.OrderSourceEnum.RECHANGE_CARD.getValue())) {
            orderCacheVo.setMildCardPay(1);
        }
        String string = date = orderCacheVo.getDeliverDate() == null ? "" : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)date)) {
            orderCacheVo.setDeliverDate(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        String string2 = date = orderCacheVo.getDeliverDate2() == null ? "" : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate2(), (String)"yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)date)) {
            orderCacheVo.setDeliverDate2(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        orderCacheVo.setIsQuick(0);
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)"lechun_bindcode");
        if (cookie != null && cookie.getValue() != null) {
            orderCacheVo.setCookieBindCode(cookie.getValue());
        }
        if ((baseJsonVo = this.tradeInterface.createOrder(platFormId.intValue(), customerDetailVo.getCustomerId(), orderCacheVo)).isSuccess()) {
            Map result = (Map)baseJsonVo.getValue();
            Object o = result.get("mainOrderNo");
            if (StringUtils.isNotEmpty((String)orderCacheVo.getBindCode()) && "1406490659019952128".equals(orderCacheVo.getBindCode())) {
                this.tradeInterface.addFreeProduct(o.toString());
            }
            PayOutputEntity payOutputEntity = this.payOrderInterface.topay(customerDetailVo.getCustomerId(), o.toString(), ip);
            PayOutputVo payOutputVo = new PayOutputVo();
            BeanUtils.copyProperties((Object)payOutputEntity, (Object)payOutputVo);
            payOutputVo.setPayAmount((BigDecimal)result.get("payAmount"));
            if (result.get("orderInfo") != null) {
                MiniShopOrderVO miniShopOrderVO = (MiniShopOrderVO)result.get("orderInfo");
                miniShopOrderVO.getOrder_detail().getPay_info().setPrepay_id(payOutputVo.getPrepayId());
                payOutputVo.setOrderInfo(ObjectConvert.beanToMap((Object)miniShopOrderVO));
            } else {
                payOutputVo.setOrderInfo(new HashMap());
            }
            return BaseJsonVo.success((Object)payOutputVo);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"testtoPayPage"})
    @ResponseBody
    public BaseJsonVo testtoPayPage(int platFormId, String cacheId, String bindCode, int orderSource, String isQuick, String speedUp) throws AuthorizeException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        MallMainOrderVo mallMainOrderVo;
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        if ("1".equals(isQuick)) {
            cacheVo.setIsQuick(1);
        }
        if (orderSource == cc.lechun.common.enums.trade.OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            cacheVo.setSpeedUp(0);
        } else if ("1".equals(speedUp)) {
            cacheVo.setSpeedUp(1);
        } else if ("0".equals(speedUp)) {
            cacheVo.setSpeedUp(0);
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.toPayPage(platFormId, "10003355426914989387638", cacheVo);
        if (baseJsonVo.isSuccess() && (mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue()) != null) {
            BigDecimal orderAmount = mallMainOrderVo.getOrderAmount();
            mallMainOrderVo.setOrderAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getOrderAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.setTotalAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getFullcutAmount()));
            mallMainOrderVo.getMallOrderVos().forEach(mallOrderVo -> {
                if (mallOrderVo.getFrees() != null && mallOrderVo.getFrees().size() > 0 && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType() != null && ((MallFreeVO)mallOrderVo.getFrees().get(0)).getRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                    mallOrderVo.setFrees(new ArrayList());
                }
            });
            BaseJsonVo exchangeResult = this.freeService.buildExchangeProductList(mallMainOrderVo.getMallOrderVos(), Integer.valueOf(1000), orderAmount);
            if (exchangeResult.isSuccess()) {
                MallOrderVo mallOrderVo2 = (MallOrderVo)mallMainOrderVo.getMallOrderVos().get(0);
                if (mallOrderVo2.getEnableExchanges() == null) {
                    mallOrderVo2.setEnableExchanges(new ArrayList());
                }
                mallOrderVo2.setEnableExchanges((List)exchangeResult.getValue());
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/createOrderAndPayByActive"})
    @ResponseBody
    public BaseJsonVo createOrderAndPayByActive(int platFormId, String bindCode, Integer orderSource, String source, String consingeephone, String consigneename, String address, Integer addresstype, Integer areaid, String ncpBat, Integer chanId, String validateCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (StringUtil.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"bindCode\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)validateCode)) {
            return BaseJsonVo.error((String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        String addressId = "";
        AddressForm addressForm = new AddressForm();
        addressForm.setAddress(address);
        addressForm.setAddresstype(addresstype.intValue());
        addressForm.setAreaid(areaid.intValue());
        addressForm.setConsigneename(consigneename);
        addressForm.setConsingeephone(consingeephone);
        addressForm.setCustomerId(customerDetailVo.getCustomerId());
        addressForm.setPlatform(platFormId);
        BaseJsonVo baseJsonVo = this.addressInterface.saveCustomerAddress(addressForm);
        CustomerAddressEntity addressEntity = null;
        if (baseJsonVo.isSuccess()) {
            addressEntity = (CustomerAddressEntity)baseJsonVo.getValue();
            addressId = addressEntity.getAddrId();
        }
        if (!this.customerMobileInterface.validateCode(MobileValidateTypeEnum.addressMobile.name(), consingeephone, validateCode)) {
            return BaseJsonVo.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        BaseJsonVo jsonVo = this.activeInterface.validateActive(customerDetailVo.getCustomerId(), bindCode, consingeephone, consigneename, addressEntity.getProvinceName(), addressEntity.getCityName(), addressEntity.getAreaName(), address);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        baseJsonVo = this.promotionInterface.getPromotionByBindCode(bindCode);
        String items = "";
        if (baseJsonVo.isSuccess()) {
            MallIndexPromotionVo promotionVo = (MallIndexPromotionVo)baseJsonVo.getValue();
            if (promotionVo.getValid() != null && !promotionVo.getValid().booleanValue()) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
            }
            HashedMap item = new HashedMap();
            item.put("itemType", promotionVo.getItemType());
            item.put("itemId", promotionVo.getPromotionId());
            item.put("quantity", 1);
            items = JsonUtils.toJson((Object)item, (boolean)false);
            if (orderSource == null) {
                orderSource = promotionVo.getOrderSource();
            }
        } else {
            return baseJsonVo;
        }
        if (this.mallRedisLock.lock("createOrderAndPayByActive:" + bindCode + customerDetailVo.getCustomerId(), "1", 20L, TimeUnit.SECONDS)) {
            try {
                String defineField = "{\"source\":\"" + (StringUtils.isNotEmpty((String)source) ? source : "") + "\"}";
                baseJsonVo = this.setOrderCache(Integer.valueOf(platFormId), orderSource, bindCode, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), items, URLEncoder.encode(defineField, "utf-8"));
                log.info("\u6d3b\u52a8:{},\u8bbe\u7f6e\u7f13\u5b58:{}", (Object)bindCode, (Object)baseJsonVo.isSuccess());
                if (!baseJsonVo.isSuccess()) {
                    return baseJsonVo;
                }
                MallOrderCacheVo cacheVo = (MallOrderCacheVo)baseJsonVo.getValue();
                cacheVo.setCacheType(2);
                ActiveCashticketVo cashticketVo = this.activeCashticketInterface.getCashticketByBindCode(bindCode);
                if (cashticketVo == null) {
                    return BaseJsonVo.error((String)"\u6d3b\u52a8\u6ca1\u6709\u7ed1\u5b9a\u4f18\u60e0\u5238");
                }
                CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getEnableCashticketCustomerList(customerDetailVo.getCustomerId(), cashticketVo.getTicketBatchId());
                if (cashticketCustomerEntity == null) {
                    baseJsonVo = this.activeCashticketInterface.sendTicket4Base(customerDetailVo.getCustomerId(), bindCode, "", Integer.valueOf(platFormId), false);
                    if (!baseJsonVo.isSuccess()) {
                        return BaseJsonVo.error((String)"\u8ba2\u5355\u62b5\u6263\u5238\u9886\u53d6\u5931\u8d25");
                    }
                    log.info("\u79c1\u57df\u5988\u5988\u6d3b\u52a8\uff0c\u7528\u6237:{}\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f", (Object)customerDetailVo.getCustomerId());
                    cashticketCustomerEntity = this.cashticketCustomerInterface.getEnableCashticketCustomerList(customerDetailVo.getCustomerId(), cashticketVo.getTicketBatchId());
                    if (cashticketCustomerEntity == null) {
                        return BaseJsonVo.error((String)"\u8ba2\u5355\u62b5\u6263\u5238\u4e0d\u5b58\u5728");
                    }
                }
                cacheVo.setTicketCustomerId(cashticketCustomerEntity.getTicketCustomerId().intValue());
                ArrayList<Integer> selectList = new ArrayList<Integer>();
                selectList.add(cashticketCustomerEntity.getTicketCustomerId());
                cacheVo.setSelectCashList(selectList);
                baseJsonVo = this.createOrderAndPay(platFormId, JsonUtils.toJson((Object)cacheVo, (boolean)false), "0", "", "", ncpBat, chanId);
                log.info("\u6d3b\u52a8:{},\u521b\u5efa\u8ba2\u5355:{}", (Object)bindCode, (Object)baseJsonVo.isSuccess());
                return baseJsonVo;
            }
            catch (InvalidKeySpecException e) {
                log.error("\u79c1\u57df\u5988\u5988,InvalidKeySpecException:" + e.getMessage());
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                log.error("\u79c1\u57df\u5988\u5988,NoSuchAlgorithmException:" + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("\u79c1\u57df\u5988\u5988,Exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
        return BaseJsonVo.error((String)"\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
    }
}

