/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.vip;

import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerInfoDetailEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.entity.vip.MallVipQuestionnairePaperEntity;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerInfoDetailInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"vip"})
public class MallVipController {
    private static final Logger log = LoggerFactory.getLogger(MallVipController.class);
    @Autowired
    MallVipInterface vipService;
    @Autowired
    CustomerLoginService customerLoginService;
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    MallOrderInterface orderService;
    @Autowired
    private CustomerInfoDetailInterface customerInfoDetailInterface;
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;

    @RequestMapping(value={"customerVipReward"})
    public BaseJsonVo customerVipReward(String relationId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (StringUtils.isEmpty((String)relationId)) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        BaseJsonVo result = this.vipService.customerVipReward(customer.getCustomerId(), relationId, customer.getPlatformId());
        if (result.isSuccess()) {
            return BaseJsonVo.success((Object)result.getValue());
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"centerInfo"})
    public BaseJsonVo centerInfo() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (customer == null || customer.getCustomerId() == null) {
            return BaseJsonVo.error((String)"\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
        }
        Map vipCenterInfo = this.vipService.centerInfo(customer.getCustomerId());
        if (vipCenterInfo != null && vipCenterInfo.size() > 0) {
            return BaseJsonVo.success((Object)vipCenterInfo);
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
    }

    @RequestMapping(value={"pushVipTask"})
    public BaseJsonVo pushVipTask() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        Map vipTask = this.vipService.pushCustomerTask(customer.getCustomerId());
        if (vipTask != null && vipTask.size() > 0) {
            return BaseJsonVo.success((Object)vipTask);
        }
        return BaseJsonVo.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"finishTask"})
    public BaseJsonVo finishTask(String taskId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        BaseJsonVo result = this.vipService.finishTask(customer.getCustomerId(), taskId);
        if (result.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"vipTasks"})
    public BaseJsonVo vipTasks() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        Map vipTask = this.vipService.customerTasks(customer.getCustomerId());
        CustomerEntity ce = this.customerInterface.getCustomer(customer.getCustomerId());
        this.customerInterface.removeCache(ce);
        if (vipTask != null && vipTask.size() > 0) {
            return BaseJsonVo.success((Object)vipTask);
        }
        return BaseJsonVo.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"vipInfo"})
    public BaseJsonVo vipInfo() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        MallVipEntity vipInfo = this.vipService.getUserVipInfo(customer.getCustomerId());
        Map vipInfoMap = BeanUtils.beanToMap((Object)vipInfo);
        vipInfoMap.put("vipOrderCount", this.orderService.getUserOrderCount(customer.getCustomerId()));
        vipInfoMap.put("maxLevelOrderShort", this.vipService.getMaxLevelOrderShort(customer.getCustomerId()));
        return BaseJsonVo.success((Object)vipInfoMap);
    }

    @RequestMapping(value={"questionnaire"})
    public BaseJsonVo questionnaire(String questionNaire) throws AuthorizeException, IOException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        Map jsons = (Map)JsonUtils.fromJson((String)URLDecoder.decode(questionNaire, "UTF-8"), Map.class);
        ArrayList<MallVipQuestionnairePaperEntity> papers = new ArrayList<MallVipQuestionnairePaperEntity>();
        for (String key : jsons.keySet()) {
            MallVipQuestionnairePaperEntity entity = new MallVipQuestionnairePaperEntity();
            entity.setCustomerId(customer.getCustomerId());
            if (jsons.get(key) == null) continue;
            entity.setQuesId(key);
            entity.setQuesText("");
            String other = ((HashMap)jsons.get(key)).get("other").toString();
            entity.setAnswerText(other);
            papers.add(entity);
            ArrayList lists = (ArrayList)((HashMap)jsons.get(key)).get("lists");
            for (String answer : lists) {
                entity.setAnswerId(answer);
                entity.setAnswerText("");
                papers.add(entity);
            }
        }
        BaseJsonVo result = this.vipService.saveVipQuestionnaire(papers);
        if (result.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"isVipDay"})
    public BaseJsonVo isVipDay() throws AuthorizeException {
        Boolean isVipDayNow = this.vipService.isVipDayNow();
        return BaseJsonVo.success((Object)isVipDayNow);
    }

    @RequestMapping(value={"birthdayPresent"})
    public BaseJsonVo birthdayPresent() throws AuthorizeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (customerDetailVo == null) {
            map.put("status", 0);
            map.put("msg", "\u672a\u767b\u5f55\u65e0\u6cd5\u9886\u53d6");
            map.put("data", null);
            return BaseJsonVo.success(map);
        }
        MallVipRightsEntity right = this.vipService.checkCustomerRight(customerDetailVo.getCustomerId(), "3212790901529932726");
        if (right == null || StringUtils.isEmpty((String)right.getId())) {
            map.put("status", 0);
            map.put("msg", "\u6ca1\u6709\u8be5\u6743\u76ca");
            map.put("data", null);
            return BaseJsonVo.success(map);
        }
        CustomerInfoDetailEntity customerInfoDetailEntity = this.customerInfoDetailInterface.getCustomerInfoDetail(customerDetailVo.getCustomerId());
        if (customerInfoDetailEntity == null || StringUtils.isEmpty((String)customerInfoDetailEntity.getCustomerBirthday())) {
            map.put("status", 1);
            map.put("msg", "\u6ca1\u6709\u751f\u65e5\u4fe1\u606f");
            map.put("data", null);
            return BaseJsonVo.success(map);
        }
        Boolean isBirthMonth = false;
        Calendar birth = Calendar.getInstance();
        birth.setTime(DateUtils.StrToDate((String)customerInfoDetailEntity.getCustomerBirthday(), (String)"yyyy-MM-dd"));
        int birthMonth = birth.get(2);
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        int nowMonth = now.get(2);
        if (birthMonth == nowMonth) {
            isBirthMonth = true;
        }
        Integer hasAndUsedTicket = 0;
        String bindCode = "";
        String promotionId = "";
        DictionaryEntity dic = this.dictionaryService.getDictionary(customerDetailVo.getPlatformGroupId().intValue(), 53, "1");
        if (dic == null || !StringUtils.isNotEmpty((String)dic.getDictionaryName())) {
            map.put("status", 0);
            map.put("msg", "\u672a\u914d\u7f6e\u6b64\u4f18\u60e0\u5238");
            map.put("data", "");
            return BaseJsonVo.success(map);
        }
        bindCode = dic.getDictionaryName();
        DictionaryEntity dicPromotion = this.dictionaryService.getDictionary(customerDetailVo.getPlatformGroupId().intValue(), 53, "2");
        if (dicPromotion == null || !StringUtils.isNotEmpty((String)dicPromotion.getDictionaryName())) {
            map.put("status", 0);
            map.put("msg", "\u672a\u914d\u7f6e\u6b64\u6d3b\u52a8\u7684\u4fc3\u9500");
            map.put("data", "");
            return BaseJsonVo.success(map);
        }
        promotionId = dicPromotion.getDictionaryName();
        List ticketList = this.activeCashticketInterface.getBindCodeActiveCashticketList(bindCode);
        if (ticketList == null || ticketList.size() <= 0) {
            map.put("status", 0);
            map.put("msg", "\u672a\u914d\u7f6e\u6b64\u4f18\u60e0\u5238");
            map.put("data", bindCode);
            return BaseJsonVo.success(map);
        }
        hasAndUsedTicket = this.cashticketCustomerInterface.getCustomerHasAndUsedTicket(customerDetailVo.getCustomerId(), ((ActiveCashticketEntity)ticketList.get(0)).getTicketBatchId());
        if (hasAndUsedTicket == 1) {
            map.put("status", 4);
            map.put("msg", "\u5df2\u9886\u53d6\u672a\u4f7f\u7528");
            map.put("data", promotionId);
            return BaseJsonVo.success(map);
        }
        if (!isBirthMonth.booleanValue()) {
            map.put("status", 2);
            map.put("msg", "\u672a\u5230\u751f\u65e5\u6708");
            map.put("data", "");
            return BaseJsonVo.success(map);
        }
        if (hasAndUsedTicket == 2) {
            map.put("status", 5);
            map.put("msg", "\u5df2\u5151\u6362");
            map.put("data", "");
            return BaseJsonVo.success(map);
        }
        if (hasAndUsedTicket == 0) {
            map.put("status", 3);
            map.put("msg", "\u5f85\u9886\u53d6");
            map.put("data", bindCode);
            return BaseJsonVo.success(map);
        }
        map.put("status", 0);
        map.put("msg", "\u672a\u77e5\u9519\u8bef");
        map.put("data", "");
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"rebuildVipLevel"})
    public BaseJsonVo rebuildVipLevel() throws AuthorizeException {
        this.vipService.rebuildVipLevelBatch();
        return BaseJsonVo.success(null);
    }
}

