/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.oms.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum ShipTypeEnum {
    SALES("0", "\u9500\u552e\u51fa\u5e93"),
    REISSUE("1", "\u8865\u53d1"),
    CUSTOMERSITUATION("2", "\u5ba2\u60c5"),
    TRYEATING("3", "\u8bd5\u5403"),
    SCRAPPED("4", "\u62a5\u5e9f"),
    SAMPLE("5", "\u6837\u54c1"),
    TEST("6", "\u6d4b\u8bd5"),
    RESEARCHDEVELOPMENT("7", "\u7814\u53d1");

    private String state;
    private String stateDesc;

    private ShipTypeEnum(String state, String stateDesc) {
        this.state = state;
        this.stateDesc = stateDesc;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateDesc() {
        return this.stateDesc;
    }

    public void setStateDesc(String stateDesc) {
        this.stateDesc = stateDesc;
    }

    public static ShipTypeEnum getCoordinateStateEnumByState(String state) {
        ShipTypeEnum platformSysEnum = null;
        if (StringUtils.isBlank((CharSequence)state)) {
            return platformSysEnum;
        }
        for (ShipTypeEnum stateEnum : ShipTypeEnum.values()) {
            if (!state.equals(stateEnum.state)) continue;
            platformSysEnum = stateEnum;
            break;
        }
        return platformSysEnum;
    }

    public static String getCoordinateStateDescByState(String state) {
        String stateDesc = null;
        if (StringUtils.isBlank((CharSequence)state)) {
            return stateDesc;
        }
        for (ShipTypeEnum stateEnum : ShipTypeEnum.values()) {
            if (!state.equals(stateEnum.state)) continue;
            stateDesc = stateEnum.stateDesc;
            break;
        }
        return stateDesc;
    }

    public static List<Map<String, Object>> getMap2List() {
        ArrayList list = Lists.newArrayList();
        for (ShipTypeEnum ele : ShipTypeEnum.values()) {
            HashMap map = Maps.newHashMap();
            map.put("value", ele.getState());
            map.put("label", ele.getStateDesc());
            list.add(map);
        }
        return list;
    }
}

