/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.util.date;

import cc.lechun.framework.common.utils.date.DateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class MyDateUtil
extends DateUtils {
    public static List<Date> buildDateByRange(Date start, Date end) {
        ArrayList<Date> list = new ArrayList<Date>();
        long dates = DateUtils.getDateDiff((Date)start, (Date)end);
        int i = 0;
        while ((long)i <= dates) {
            list.add(DateUtils.getAddDateByDay((Date)start, (int)i));
            ++i;
        }
        return list;
    }

    public static int getDateInt(Date date) {
        return Integer.valueOf(DateUtils.formatDate((Date)date, (String)"yyyyMMdd"));
    }

    public static String getDateStr(Date date) {
        return DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
    }

    public static List<String> buildDateByDays(Date start, int days) {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i <= days; ++i) {
            list.add(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)start, (int)i), (String)"yyyy-MM-dd"));
        }
        return list;
    }

    public static Date getDate(Integer weekDay) {
        return MyDateUtil.getDate(weekDay, new Date());
    }

    public static Date getDate(Integer weekDay, Date date) {
        Calendar nowTime = Calendar.getInstance();
        nowTime.setTime(date);
        nowTime.setFirstDayOfWeek(2);
        nowTime.set(7, weekDay + 1);
        GregorianCalendar oldTime = new GregorianCalendar();
        oldTime.setTime(nowTime.getTime());
        ((Calendar)oldTime).add(5, 0);
        return oldTime.getTime();
    }

    public static List<Date> getDates(Integer weekDay, long weekdays) {
        LinkedList<Date> list = new LinkedList<Date>();
        Date one = MyDateUtil.getDate(weekDay);
        while (weekdays > 0L) {
            list.add(one);
            one = DateUtils.getAddDateByDay((Date)one, (int)7);
            --weekdays;
        }
        return list;
    }

    public static List<Integer> getDateInts(Integer weekDay, long weekdays) {
        List<Date> list = MyDateUtil.getDates(weekDay, weekdays);
        return list.stream().map(v -> MyDateUtil.getDateInt(v)).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(1), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)MyDateUtil.getDate(1), (int)7), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(2), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(3), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(4), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(5), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(6), (String)"yyyy-MM-dd"));
        System.out.println(DateUtils.formatDate((Date)MyDateUtil.getDate(7), (String)"yyyy-MM-dd"));
    }
}

