/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.entity.print;

import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.sys.entity.bo.FormatConfBO;
import cc.lechun.sys.entity.print.BillPrintFormat;
import cc.lechun.sys.entity.print.PrePrinter;
import cc.lechun.sys.entity.print.util.ThreeSections;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class Printer
extends PrePrinter {
    private BillPrintFormat billPrintFormat;

    public Printer(Collection<FormatConfBO> gridconfs, BillPrintFormat billPrintFormat) {
        super(gridconfs);
        this.billPrintFormat = billPrintFormat;
    }

    public Message createPDF(OutputStream outputStream) {
        Message message = new Message(true, "");
        try {
            Document document = this.getDocument(outputStream);
            this.addTitle(document);
            this.addHead(document);
            this.addBody(document);
            this.addRemark(document);
            this.addFoot(document);
            this.print(document);
        }
        catch (Exception e) {
            e.printStackTrace();
            message.setSuccess(false);
            message.setMsg("PDF\u751f\u6210\u5931\u8d25.Error - " + e.getMessage());
        }
        return message;
    }

    public Iterable getData() {
        return this.billPrintFormat.getIterable();
    }

    @Override
    public Table getHeadCell() throws IOException {
        return this.getTableHead(this.billPrintFormat.getQuery());
    }

    @Override
    public LinkedList<ThreeSections.Entry> getHead() {
        return this.billPrintFormat.getHeads();
    }

    @Override
    public ThreeSections.Entry getTitle() {
        return this.billPrintFormat.getTitle();
    }

    @Override
    public LinkedList<ThreeSections.Entry> getFoot() {
        return this.billPrintFormat.getFoots();
    }

    @Override
    public LinkedList<ThreeSections.Entry> getRemark() {
        return this.billPrintFormat.getRemarks();
    }

    @Override
    public PdfFont getFont() throws IOException {
        String url = this.billPrintFormat.getFontPath();
        System.out.println("\u5b57\u4f53URL\uff1a" + url);
        if (StringUtils.isBlank((CharSequence)url)) {
            return PdfFontFactory.createFont();
        }
        String encoding = this.billPrintFormat.getFontEncoding();
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = "Identity-H";
        }
        return PdfFontFactory.createFont((String)url, (String)encoding);
    }

    @Override
    public float[] colWidths_head() {
        return this.billPrintFormat.getColWidths_head();
    }

    @Override
    public float[] colWidths_foot() {
        return this.billPrintFormat.getColWidths_foot();
    }

    @Override
    public float[] colWidths_remark() {
        return this.billPrintFormat.getColWidths_remark();
    }

    @Override
    public int colWidths_data() {
        return this.billPrintFormat.getColWidths_data();
    }
}

