/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class PemUtil {
    public static X509Certificate loadCertificate(ByteArrayInputStream inputStream) throws IOException {
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            cert = (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (CertificateExpiredException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66\u6587\u4ef6", e);
        }
        finally {
            inputStream.close();
        }
        return cert;
    }
}

