/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaCountResult;
import weixin.popular.bean.media.MediaGetResult;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.media.MiniCardMedia;
import weixin.popular.bean.media.UploadimgResult;
import weixin.popular.client.BytesOrJsonResponseHandler;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.StreamUtils;

public class MediaAPI
extends BaseAPI {
    public static BaseResult setMiniCard(String access_token, MiniCardMedia miniCardMedia) {
        String data = JsonUtil.toJSONString(miniCardMedia);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/guide/setguidecardmaterial").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(data, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static Media mediaUpload(String access_token, MediaType mediaType, File media) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        FileBody bin = new FileBody(media);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    public static Media mediaUpload(String access_token, MediaType mediaType, InputStream inputStream) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        byte[] data = null;
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp." + mediaType.fileSuffix()).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Media mediaUpload(String access_token, MediaType mediaType, URI uri) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), "temp." + mediaType.fileSuffix()).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
            httpPost.setEntity(reqEntity);
            Media media = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
            return media;
        }
        catch (UnsupportedCharsetException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MediaGetResult mediaGet(String access_token, String media_id, boolean use_http) {
        String http_s = use_http ? "https://api.weixin.qq.com".replace("https", "http") : "https://api.weixin.qq.com";
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri(http_s + "/cgi-bin/media/get").addParameter("access_token", API.accessToken(access_token)).addParameter("media_id", media_id).build();
        return LocalHttpClient.execute(httpUriRequest, BytesOrJsonResponseHandler.createResponseHandler(MediaGetResult.class));
    }

    public static MediaGetResult mediaGet(String access_token, String media_id) {
        return MediaAPI.mediaGet(access_token, media_id, false);
    }

    public static MediaGetResult mediaGetJssdk(String access_token, String media_id) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/media/get/jssdk").addParameter("access_token", API.accessToken(access_token)).addParameter("media_id", media_id).build();
        return LocalHttpClient.execute(httpUriRequest, BytesOrJsonResponseHandler.createResponseHandler(MediaGetResult.class));
    }

    public static UploadimgResult mediaUploadimg(String access_token, File media) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        FileBody bin = new FileBody(media);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).addTextBody("access_token", API.accessToken(access_token)).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
    }

    public static UploadimgResult mediaUploadimg(String access_token, InputStream inputStream) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        byte[] data = null;
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp.jpg").addTextBody("access_token", API.accessToken(access_token)).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadimgResult mediaUploadimg(String access_token, URI uri) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), UUID.randomUUID().toString() + ".jpg").addTextBody("access_token", API.accessToken(access_token)).build();
            httpPost.setEntity(reqEntity);
            UploadimgResult uploadimgResult = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
            return uploadimgResult;
        }
        catch (UnsupportedCharsetException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MediaCountResult getMediaCount(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/material/get_materialcount").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, MediaCountResult.class);
    }

    public static MediaCountResult getMediaCount(String access_token, String type, int offset, int count) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/material/batchget_material").addParameter("access_token", API.accessToken(access_token)).addParameter("type", type).addParameter("offset", String.valueOf(offset)).addParameter("count", String.valueOf(count)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, MediaCountResult.class);
    }
}

