/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.HttpUrl;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.util.MapUtil;
import weixin.popular.util.StringUtils;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);
    String schema = "WECHATPAY2-SHA256-RSA2048";

    public static String generateSign(Map<String, String> map, String paternerKey) {
        return SignatureUtil.generateSign(map, null, paternerKey);
    }

    public static String generateSign(Map<String, String> map, String sign_type, String paternerKey) {
        Map<String, String> tmap = MapUtil.order(map);
        if (tmap.containsKey("sign")) {
            tmap.remove("sign");
        }
        String str = MapUtil.mapJoin(tmap, false, false);
        if (sign_type == null) {
            sign_type = tmap.get("sign_type");
        }
        if ("HMAC-SHA256".equalsIgnoreCase(sign_type)) {
            try {
                Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
                SecretKeySpec secret_key = new SecretKeySpec(paternerKey.getBytes("UTF-8"), "HmacSHA256");
                sha256_HMAC.init(secret_key);
                return Hex.encodeHexString((byte[])sha256_HMAC.doFinal((str + "&key=" + paternerKey).getBytes("UTF-8"))).toUpperCase();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        return DigestUtils.md5Hex((String)(str + "&key=" + paternerKey)).toUpperCase();
    }

    public static String generateEventMessageSignature(String token, String timestamp, String nonce) {
        Object[] array = new String[]{token, timestamp, nonce};
        Arrays.sort(array);
        String s = StringUtils.arrayToDelimitedString(array, "");
        return DigestUtils.shaHex((String)s);
    }

    public static boolean validateSign(Map<String, String> map, String key) {
        return SignatureUtil.validateSign(map, null, key);
    }

    public static boolean validateSign(Map<String, String> map, String sign_type, String key) {
        if (map.get("sign") == null) {
            return false;
        }
        return map.get("sign").equals(SignatureUtil.generateSign(map, sign_type, key));
    }

    public static String getToken(String method, HttpUrl url, String body, String mchId, String certSerialNo) throws Exception {
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        long timestamp = System.currentTimeMillis() / 1000L;
        String message = SignatureUtil.buildMessage(method, url, timestamp, nonceStr, body);
        String signature = SignatureUtil.sign(message.getBytes("utf-8"));
        return "mchid=\"" + mchId + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + certSerialNo + "\",signature=\"" + signature + "\"";
    }

    public static String sign(byte[] message) throws Exception {
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initSign(SignatureUtil.getPrivateKey(""));
        sign.update(message);
        return Base64.getEncoder().encodeToString(sign.sign());
    }

    public static PrivateKey getPrivateKey(String filename) throws IOException {
        String content = new String(Files.readAllBytes(Paths.get(filename, new String[0])), "utf-8");
        try {
            String privateKey = content.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
    }

    public static String buildMessage(String method, HttpUrl url, long timestamp, String nonceStr, String body) {
        String canonicalUrl = url.encodedPath();
        if (url.encodedQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + url.encodedQuery();
        }
        return method + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonceStr + "\n" + body + "\n";
    }
}

