/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat();
    public static final long MILLIS_DAY = 86400000L;
    public static final String S1 = "yyyy-MM-dd HH:mm:ss";
    public static final String S2 = "yyyy-MM-dd+HH:mm:ss";
    public static final String S3 = "yyyy-MM-dd";
    private static final String S4 = "yyyy-MM";
    public static final String S5 = "HH:mm";
    public static final String S6 = "E";
    public static final String S7 = "yyyy/MM/dd/HHmmss";
    private static final String S8 = "yyyy-M";

    public static String format(String pattern, long mills) {
        FORMAT.applyPattern(pattern);
        return FORMAT.format(mills);
    }

    public static String format(String pattern, String mills) {
        long m = Long.parseLong(mills);
        return DateUtils.format(pattern, m);
    }

    public static String formatS1(String mills) {
        return DateUtils.format(S1, mills);
    }

    public static String formatS1(long mills) {
        return DateUtils.format(S1, mills);
    }

    public static String formatS3(long mills) {
        return DateUtils.format(S3, mills);
    }

    public static String formatS4(long mills) {
        return DateUtils.format(S4, mills);
    }

    public static String formatS5(long mills) {
        return DateUtils.format(S5, mills);
    }

    public static String formatS7(long mills) {
        return DateUtils.format(S7, mills);
    }

    public static String formatS8(long mills) {
        return DateUtils.format(S8, mills);
    }

    public static Date getDate(String pattern, String date) {
        try {
            FORMAT.applyPattern(pattern);
            return FORMAT.parse(date);
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public static long getMills(String pattern, String date) {
        try {
            FORMAT.applyPattern(pattern);
            return FORMAT.parse(date).getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long getMillsByS1(String date) {
        return DateUtils.getMills(S1, date);
    }

    public static long getMillsByS3(String date) {
        return DateUtils.getMills(S3, date);
    }

    public static long getMillsByS5(String date) {
        return DateUtils.getMills(S5, date);
    }

    public static String getDateOfDayStartByS3(String date) {
        date = date + " 00:00:00";
        return date;
    }

    public static String getDateOfDayEndByS3(String date) {
        date = date + " 23:59:59";
        return date;
    }

    public static int daysBetween(String sDate, String eDate) {
        long startMillis = DateUtils.getMillsByS1(sDate);
        long endMillis = DateUtils.getMillsByS1(eDate);
        return (int)((endMillis - startMillis) / 86400000L) + 1;
    }

    public static boolean inDateByS3(String sDate, String eDate) {
        return DateUtils.inDateByS3(sDate, eDate, DateUtils.getDateByS3());
    }

    public static boolean inDateByS3(String sDate, String eDate, String cDate) {
        long startMillis = DateUtils.getMillsByS3(sDate);
        long endMillis = DateUtils.getMillsByS3(eDate);
        long currentMillis = DateUtils.getMillsByS1(cDate);
        return currentMillis >= startMillis && currentMillis <= endMillis;
    }

    public static String getDateByS3() {
        return DateUtils.formatS3(System.currentTimeMillis());
    }

    public static String getDateByS5() {
        return DateUtils.formatS5(System.currentTimeMillis());
    }

    public static boolean inTimeByS5(String sTime, String eTime) {
        return DateUtils.inDateByS3(sTime, eTime, DateUtils.getDateByS5());
    }

    public static boolean inTimeByS5(String sTime, String eTime, String cTime) {
        long startMillis = DateUtils.getMillsByS5(sTime);
        long endMillis = DateUtils.getMillsByS5(eTime);
        long currentMillis = DateUtils.getMillsByS5(cTime);
        return currentMillis >= startMillis && currentMillis <= endMillis;
    }

    public static int getDayOfWeek() {
        return DateUtils.getDayOfWeek(System.currentTimeMillis());
    }

    public static int getDayOfWeek(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar.get(7) - 1;
    }

    public static Calendar getDayOfStart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar getDayOfEnd(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static Calendar getMonthOfStart(Calendar calendar) {
        calendar.set(5, 1);
        return DateUtils.getDayOfStart(calendar);
    }

    public static Calendar getMonthOfEnd(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtils.getDayOfEnd(calendar);
    }
}

