/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Random;

public class FileUtils {
    private static final Random RANDOM = new Random();
    private static final String EMPLOYEE_AVATAR = "nextc/test/avatar";
    private static final String EMPLOYEE_THUMB_AVATAR = "nextc/employee/thumb_avatar";
    private static final String EMPLOYEE_QR_CODE = "nextc/employee/qr_code";
    private static final String CONTACT_CONTACT_WAY_QR_CODE = "ContactWayClient/QrCode";
    private static final String CONTACT_AVATAR = "contact/avatar/";
    private static final String FILE_PNG = ".png";

    public static String getFileName(String module, String suffix) {
        return module + FileUtils.getRandomString() + suffix;
    }

    public static String getFileNameOfEmpAvatar() {
        return EMPLOYEE_AVATAR + FileUtils.getRandomString() + FILE_PNG;
    }

    public static String getFileNameOfEmpThumbAvatar() {
        return EMPLOYEE_THUMB_AVATAR + FileUtils.getRandomString() + FILE_PNG;
    }

    public static String getFileNameOfEmpQrCode() {
        return EMPLOYEE_QR_CODE + FileUtils.getRandomString() + FILE_PNG;
    }

    public static String getFileNameOfContactWayQrCode() {
        return CONTACT_CONTACT_WAY_QR_CODE + FileUtils.getRandomString() + FILE_PNG;
    }

    public static String getContactAvatarPath() {
        return CONTACT_AVATAR + FileUtils.getRandomString() + FILE_PNG;
    }

    public static boolean saveFileByInput(File file, InputStream inputStream) {
        try {
            int offset;
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((offset = inputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, offset);
            }
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getRandomString() {
        return FileUtils.getRandomString(6);
    }

    public static String getRandomString(int length) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.currentTimeMillis() * 10L);
        for (int i = 0; i < length; ++i) {
            builder.append(RANDOM.nextInt(10));
        }
        return builder.toString();
    }
}

