/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.enjoy;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.enjoy.EnjoyTemplate;
import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;

public class EnjoyEngine
implements TemplateEngine {
    private Engine engine;
    private TemplateConfig.ResourceMode resourceMode;

    public EnjoyEngine() {
        this(new TemplateConfig());
    }

    public EnjoyEngine(TemplateConfig config) {
        this(EnjoyEngine.createEngine(config));
        this.resourceMode = config.getResourceMode();
    }

    public EnjoyEngine(Engine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (ObjectUtil.equal((Object)TemplateConfig.ResourceMode.STRING, (Object)this.resourceMode)) {
            return EnjoyTemplate.wrap(this.engine.getTemplateByString(resource));
        }
        return EnjoyTemplate.wrap(this.engine.getTemplate(resource));
    }

    private static Engine createEngine(TemplateConfig config) {
        Assert.notNull(config, "Template config is null !", new Object[0]);
        Engine engine = Engine.create((String)("Hutool-Enjoy-Engine-" + config.toString()));
        engine.setEncoding(config.getCharsetStr());
        switch (config.getResourceMode()) {
            case STRING: {
                break;
            }
            case CLASSPATH: {
                engine.setToClassPathSourceFactory();
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case FILE: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case WEB_ROOT: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(FileUtil.getAbsolutePath(FileUtil.getWebRoot()));
                break;
            }
        }
        return engine;
    }
}

