/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.wrapper.field.enums;

import cn.stylefeng.roses.kernel.rule.base.ReadableEnum;
import cn.stylefeng.roses.kernel.rule.enums.FormatTypeEnum;
import cn.stylefeng.roses.kernel.wrapper.field.util.CommonFormatUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumFieldFormatSerializer
extends JsonSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(EnumFieldFormatSerializer.class);
    private final FormatTypeEnum formatTypeEnum;
    private final Class<? extends ReadableEnum<?>> processEnum;

    public EnumFieldFormatSerializer(FormatTypeEnum formatTypeEnum, Class<? extends ReadableEnum<?>> processEnum) {
        this.formatTypeEnum = formatTypeEnum;
        this.processEnum = processEnum;
    }

    public void serialize(Object originValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object formattedValue = originValue;
        if (originValue instanceof ReadableEnum) {
            formattedValue = ((ReadableEnum)originValue).getName();
        } else if (this.processEnum.isEnum()) {
            ReadableEnum<?>[] enumConstants;
            for (ReadableEnum<?> enumConstant : enumConstants = this.processEnum.getEnumConstants()) {
                if (!enumConstant.getKey().equals(originValue)) continue;
                formattedValue = enumConstant.getName();
            }
        }
        CommonFormatUtil.writeField(this.formatTypeEnum, originValue, formattedValue, jsonGenerator);
    }
}

