/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ReadException
implements JsonpSerializable {
    private final ErrorCause exception;
    private final long fromSeqNo;
    private final int retries;
    public static final JsonpDeserializer<ReadException> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReadException::setupReadExceptionDeserializer);

    private ReadException(Builder builder) {
        this.exception = ApiTypeHelper.requireNonNull(builder.exception, this, "exception");
        this.fromSeqNo = ApiTypeHelper.requireNonNull(builder.fromSeqNo, this, "fromSeqNo");
        this.retries = ApiTypeHelper.requireNonNull(builder.retries, this, "retries");
    }

    public static ReadException of(Function<Builder, ObjectBuilder<ReadException>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ErrorCause exception() {
        return this.exception;
    }

    public final long fromSeqNo() {
        return this.fromSeqNo;
    }

    public final int retries() {
        return this.retries;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("exception");
        this.exception.serialize(generator, mapper);
        generator.writeKey("from_seq_no");
        generator.write(this.fromSeqNo);
        generator.writeKey("retries");
        generator.write(this.retries);
    }

    protected static void setupReadExceptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::exception, ErrorCause._DESERIALIZER, "exception");
        op.add(Builder::fromSeqNo, JsonpDeserializer.longDeserializer(), "from_seq_no");
        op.add(Builder::retries, JsonpDeserializer.integerDeserializer(), "retries");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ReadException> {
        private ErrorCause exception;
        private Long fromSeqNo;
        private Integer retries;

        public final Builder exception(ErrorCause value) {
            this.exception = value;
            return this;
        }

        public final Builder exception(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.exception(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder fromSeqNo(long value) {
            this.fromSeqNo = value;
            return this;
        }

        public final Builder retries(int value) {
            this.retries = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReadException build() {
            this._checkSingleUse();
            return new ReadException(this);
        }
    }
}

