/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.IndicesOptions;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DatafeedConfig
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final ChunkingConfig chunkingConfig;
    @Nullable
    private final String datafeedId;
    @Nullable
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    @Nullable
    private final String frequency;
    private final List<String> indexes;
    private final List<String> indices;
    @Nullable
    private final IndicesOptions indicesOptions;
    @Nullable
    private final String jobId;
    @Nullable
    private final Integer maxEmptySearches;
    private final Query query;
    @Nullable
    private final String queryDelay;
    private final Map<String, RuntimeField> runtimeMappings;
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Integer scrollSize;
    public static final JsonpDeserializer<DatafeedConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedConfig::setupDatafeedConfigDeserializer);

    private DatafeedConfig(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.chunkingConfig = builder.chunkingConfig;
        this.datafeedId = builder.datafeedId;
        this.delayedDataCheckConfig = builder.delayedDataCheckConfig;
        this.frequency = builder.frequency;
        this.indexes = ApiTypeHelper.unmodifiable(builder.indexes);
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.indicesOptions = builder.indicesOptions;
        this.jobId = builder.jobId;
        this.maxEmptySearches = builder.maxEmptySearches;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.queryDelay = builder.queryDelay;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = builder.scrollSize;
    }

    public static DatafeedConfig of(Function<Builder, ObjectBuilder<DatafeedConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    @Nullable
    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    @Nullable
    public final String frequency() {
        return this.frequency;
    }

    public final List<String> indexes() {
        return this.indexes;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Integer maxEmptySearches() {
        return this.maxEmptySearches;
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final String queryDelay() {
        return this.queryDelay;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public final Integer scrollSize() {
        return this.scrollSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.chunkingConfig != null) {
            generator.writeKey("chunking_config");
            this.chunkingConfig.serialize(generator, mapper);
        }
        if (this.datafeedId != null) {
            generator.writeKey("datafeed_id");
            generator.write(this.datafeedId);
        }
        if (this.delayedDataCheckConfig != null) {
            generator.writeKey("delayed_data_check_config");
            this.delayedDataCheckConfig.serialize(generator, mapper);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            generator.write(this.frequency);
        }
        if (ApiTypeHelper.isDefined(this.indexes)) {
            generator.writeKey("indexes");
            generator.writeStartArray();
            for (String string : this.indexes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        if (this.jobId != null) {
            generator.writeKey("job_id");
            generator.write(this.jobId);
        }
        if (this.maxEmptySearches != null) {
            generator.writeKey("max_empty_searches");
            generator.write(this.maxEmptySearches.intValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.queryDelay != null) {
            generator.writeKey("query_delay");
            generator.write(this.queryDelay);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scrollSize != null) {
            generator.writeKey("scroll_size");
            generator.write(this.scrollSize.intValue());
        }
    }

    protected static void setupDatafeedConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config");
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id");
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config");
        op.add(Builder::frequency, JsonpDeserializer.stringDeserializer(), "frequency");
        op.add(Builder::indexes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indexes");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::queryDelay, JsonpDeserializer.stringDeserializer(), "query_delay");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatafeedConfig> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private ChunkingConfig chunkingConfig;
        @Nullable
        private String datafeedId;
        @Nullable
        private DelayedDataCheckConfig delayedDataCheckConfig;
        @Nullable
        private String frequency;
        @Nullable
        private List<String> indexes;
        private List<String> indices;
        @Nullable
        private IndicesOptions indicesOptions;
        @Nullable
        private String jobId;
        @Nullable
        private Integer maxEmptySearches;
        private Query query;
        @Nullable
        private String queryDelay;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Integer scrollSize;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder chunkingConfig(@Nullable ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public final Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public final Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(@Nullable DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public final Builder frequency(@Nullable String value) {
            this.frequency = value;
            return this;
        }

        public final Builder indexes(List<String> list) {
            this.indexes = Builder._listAddAll(this.indexes, list);
            return this;
        }

        public final Builder indexes(String value, String ... values) {
            this.indexes = Builder._listAdd(this.indexes, value, values);
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public final Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxEmptySearches(@Nullable Integer value) {
            this.maxEmptySearches = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder queryDelay(@Nullable String value) {
            this.queryDelay = value;
            return this;
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder scrollSize(@Nullable Integer value) {
            this.scrollSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatafeedConfig build() {
            this._checkSingleUse();
            return new DatafeedConfig(this);
        }
    }
}

