/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.integration;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.RegistryFactory;
import com.alibaba.dubbo.registry.RegistryService;
import com.alibaba.dubbo.registry.integration.RegistryDirectory;
import com.alibaba.dubbo.registry.support.ProviderConsumerRegTable;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Protocol;
import com.alibaba.dubbo.rpc.ProxyFactory;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.Cluster;
import com.alibaba.dubbo.rpc.cluster.Configurator;
import com.alibaba.dubbo.rpc.protocol.InvokerWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RegistryProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(RegistryProtocol.class);
    private static RegistryProtocol INSTANCE;
    private final Map<URL, NotifyListener> overrideListeners = new ConcurrentHashMap<URL, NotifyListener>();
    private final Map<String, ExporterChangeableWrapper<?>> bounds = new ConcurrentHashMap();
    private Cluster cluster;
    private Protocol protocol;
    private RegistryFactory registryFactory;
    private ProxyFactory proxyFactory;

    public RegistryProtocol() {
        INSTANCE = this;
    }

    public static RegistryProtocol getRegistryProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension("registry");
        }
        return INSTANCE;
    }

    private static String[] getFilteredKeys(URL url) {
        Map<String, String> params = url.getParameters();
        if (params != null && !params.isEmpty()) {
            ArrayList<String> filteredKeys = new ArrayList<String>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry == null || entry.getKey() == null || !entry.getKey().startsWith(".")) continue;
                filteredKeys.add(entry.getKey());
            }
            return filteredKeys.toArray(new String[filteredKeys.size()]);
        }
        return new String[0];
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistryFactory(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public int getDefaultPort() {
        return 9090;
    }

    public Map<URL, NotifyListener> getOverrideListeners() {
        return this.overrideListeners;
    }

    public void register(URL registryUrl, URL registedProviderUrl) {
        Registry registry = this.registryFactory.getRegistry(registryUrl);
        registry.register(registedProviderUrl);
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> originInvoker) throws RpcException {
        ExporterChangeableWrapper<T> exporter = this.doLocalExport(originInvoker);
        URL registryUrl = this.getRegistryUrl(originInvoker);
        Registry registry = this.getRegistry(originInvoker);
        URL registedProviderUrl = this.getRegistedProviderUrl(originInvoker);
        boolean register = registedProviderUrl.getParameter("register", true);
        ProviderConsumerRegTable.registerProvider(originInvoker, registryUrl, registedProviderUrl);
        if (register) {
            this.register(registryUrl, registedProviderUrl);
            ProviderConsumerRegTable.getProviderWrapper(originInvoker).setReg(true);
        }
        URL overrideSubscribeUrl = this.getSubscribedOverrideUrl(registedProviderUrl);
        OverrideListener overrideSubscribeListener = new OverrideListener(overrideSubscribeUrl, originInvoker);
        this.overrideListeners.put(overrideSubscribeUrl, overrideSubscribeListener);
        registry.subscribe(overrideSubscribeUrl, overrideSubscribeListener);
        return new DestroyableExporter<T>(exporter, originInvoker, overrideSubscribeUrl, registedProviderUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ExporterChangeableWrapper<T> doLocalExport(Invoker<T> originInvoker) {
        String key = this.getCacheKey(originInvoker);
        ExporterChangeableWrapper<Object> exporter = this.bounds.get(key);
        if (exporter == null) {
            Map<String, ExporterChangeableWrapper<?>> map = this.bounds;
            synchronized (map) {
                exporter = this.bounds.get(key);
                if (exporter == null) {
                    InvokerDelegete<T> invokerDelegete = new InvokerDelegete<T>(originInvoker, this.getProviderUrl(originInvoker));
                    exporter = new ExporterChangeableWrapper<T>(this.protocol.export(invokerDelegete), originInvoker);
                    this.bounds.put(key, exporter);
                }
            }
        }
        return exporter;
    }

    private <T> void doChangeLocalExport(Invoker<T> originInvoker, URL newInvokerUrl) {
        String key = this.getCacheKey(originInvoker);
        ExporterChangeableWrapper<?> exporter = this.bounds.get(key);
        if (exporter == null) {
            logger.warn(new IllegalStateException("error state, exporter should not be null"));
        } else {
            InvokerDelegete<T> invokerDelegete = new InvokerDelegete<T>(originInvoker, newInvokerUrl);
            exporter.setExporter(this.protocol.export(invokerDelegete));
        }
    }

    private Registry getRegistry(Invoker<?> originInvoker) {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        return this.registryFactory.getRegistry(registryUrl);
    }

    private URL getRegistryUrl(Invoker<?> originInvoker) {
        URL registryUrl = originInvoker.getUrl();
        if ("registry".equals(registryUrl.getProtocol())) {
            String protocol = registryUrl.getParameter("registry", "dubbo");
            registryUrl = registryUrl.setProtocol(protocol).removeParameter("registry");
        }
        return registryUrl;
    }

    private URL getRegistedProviderUrl(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        URL registedProviderUrl = providerUrl.removeParameters(RegistryProtocol.getFilteredKeys(providerUrl)).removeParameter("monitor").removeParameter("bind.ip").removeParameter("bind.port").removeParameter("qos.enable").removeParameter("qos.port").removeParameter("qos.accept.foreign.ip");
        return registedProviderUrl;
    }

    private URL getSubscribedOverrideUrl(URL registedProviderUrl) {
        return registedProviderUrl.setProtocol("provider").addParameters("category", "configurators", "check", String.valueOf(false));
    }

    private URL getProviderUrl(Invoker<?> origininvoker) {
        String export = origininvoker.getUrl().getParameterAndDecoded("export");
        if (export == null || export.length() == 0) {
            throw new IllegalArgumentException("The registry export url is null! registry: " + origininvoker.getUrl());
        }
        URL providerUrl = URL.valueOf(export);
        return providerUrl;
    }

    private String getCacheKey(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        String key = providerUrl.removeParameters("dynamic", "enabled").toFullString();
        return key;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        url = url.setProtocol(url.getParameter("registry", "dubbo")).removeParameter("registry");
        Registry registry = this.registryFactory.getRegistry(url);
        if (RegistryService.class.equals(type)) {
            return this.proxyFactory.getInvoker(registry, type, url);
        }
        Map<String, String> qs = StringUtils.parseQueryString(url.getParameterAndDecoded("refer"));
        String group = qs.get("group");
        if (group != null && group.length() > 0 && (Constants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doRefer(this.getMergeableCluster(), registry, type, url);
        }
        return this.doRefer(this.cluster, registry, type, url);
    }

    private Cluster getMergeableCluster() {
        return ExtensionLoader.getExtensionLoader(Cluster.class).getExtension("mergeable");
    }

    private <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url) {
        RegistryDirectory<T> directory = new RegistryDirectory<T>(type, url);
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        HashMap<String, String> parameters = new HashMap<String, String>(directory.getUrl().getParameters());
        URL subscribeUrl = new URL("consumer", (String)parameters.remove("register.ip"), 0, type.getName(), parameters);
        if (!"*".equals(url.getServiceInterface()) && url.getParameter("register", true)) {
            registry.register(subscribeUrl.addParameters("category", "consumers", "check", String.valueOf(false)));
        }
        directory.subscribe(subscribeUrl.addParameter("category", "providers,configurators,routers"));
        Invoker<T> invoker = cluster.join(directory);
        ProviderConsumerRegTable.registerConsumer(invoker, url, subscribeUrl, directory);
        return invoker;
    }

    @Override
    public void destroy() {
        ArrayList exporters = new ArrayList(this.bounds.values());
        for (Exporter exporter : exporters) {
            exporter.unexport();
        }
        this.bounds.clear();
    }

    private static class DestroyableExporter<T>
    implements Exporter<T> {
        public static final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("Exporter-Unexport", true));
        private Exporter<T> exporter;
        private Invoker<T> originInvoker;
        private URL subscribeUrl;
        private URL registerUrl;

        public DestroyableExporter(Exporter<T> exporter, Invoker<T> originInvoker, URL subscribeUrl, URL registerUrl) {
            this.exporter = exporter;
            this.originInvoker = originInvoker;
            this.subscribeUrl = subscribeUrl;
            this.registerUrl = registerUrl;
        }

        @Override
        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        @Override
        public void unexport() {
            Registry registry = INSTANCE.getRegistry(this.originInvoker);
            try {
                registry.unregister(this.registerUrl);
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
            try {
                NotifyListener listener = (NotifyListener)INSTANCE.overrideListeners.remove(this.subscribeUrl);
                registry.unsubscribe(this.subscribeUrl, listener);
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        int timeout = ConfigUtils.getServerShutdownTimeout();
                        if (timeout > 0) {
                            logger.info("Waiting " + timeout + "ms for registry to notify all consumers before unexport. Usually, this is called when you use dubbo API");
                            Thread.sleep(timeout);
                        }
                        DestroyableExporter.this.exporter.unexport();
                    }
                    catch (Throwable t) {
                        logger.warn(t.getMessage(), t);
                    }
                }
            });
        }
    }

    private class ExporterChangeableWrapper<T>
    implements Exporter<T> {
        private final Invoker<T> originInvoker;
        private Exporter<T> exporter;

        public ExporterChangeableWrapper(Exporter<T> exporter, Invoker<T> originInvoker) {
            this.exporter = exporter;
            this.originInvoker = originInvoker;
        }

        public Invoker<T> getOriginInvoker() {
            return this.originInvoker;
        }

        @Override
        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void setExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        @Override
        public void unexport() {
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            RegistryProtocol.this.bounds.remove(key);
            this.exporter.unexport();
        }
    }

    private class OverrideListener
    implements NotifyListener {
        private final URL subscribeUrl;
        private final Invoker originInvoker;

        public OverrideListener(URL subscribeUrl, Invoker originalInvoker) {
            this.subscribeUrl = subscribeUrl;
            this.originInvoker = originalInvoker;
        }

        @Override
        public synchronized void notify(List<URL> urls) {
            URL newUrl;
            logger.debug("original override urls: " + urls);
            List<URL> matchedUrls = this.getMatchedUrls(urls, this.subscribeUrl);
            logger.debug("subscribe url: " + this.subscribeUrl + ", override urls: " + matchedUrls);
            if (matchedUrls.isEmpty()) {
                return;
            }
            List<Configurator> configurators = RegistryDirectory.toConfigurators(matchedUrls);
            Invoker invoker = this.originInvoker instanceof InvokerDelegete ? ((InvokerDelegete)this.originInvoker).getInvoker() : this.originInvoker;
            URL originUrl = RegistryProtocol.this.getProviderUrl(invoker);
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)RegistryProtocol.this.bounds.get(key);
            if (exporter == null) {
                logger.warn(new IllegalStateException("error state, exporter should not be null"));
                return;
            }
            URL currentUrl = exporter.getInvoker().getUrl();
            if (!currentUrl.equals(newUrl = this.getConfigedInvokerUrl(configurators, originUrl))) {
                RegistryProtocol.this.doChangeLocalExport(this.originInvoker, newUrl);
                logger.info("exported provider url changed, origin url: " + originUrl + ", old export url: " + currentUrl + ", new export url: " + newUrl);
            }
        }

        private List<URL> getMatchedUrls(List<URL> configuratorUrls, URL currentSubscribe) {
            ArrayList<URL> result = new ArrayList<URL>();
            Iterator<URL> i$ = configuratorUrls.iterator();
            while (i$.hasNext()) {
                URL url;
                URL overrideUrl = url = i$.next();
                if (url.getParameter("category") == null && "override".equals(url.getProtocol())) {
                    overrideUrl = url.addParameter("category", "configurators");
                }
                if (!UrlUtils.isMatch(currentSubscribe, overrideUrl)) continue;
                result.add(url);
            }
            return result;
        }

        private URL getConfigedInvokerUrl(List<Configurator> configurators, URL url) {
            for (Configurator configurator : configurators) {
                url = configurator.configure(url);
            }
            return url;
        }
    }

    public static class InvokerDelegete<T>
    extends InvokerWrapper<T> {
        private final Invoker<T> invoker;

        public InvokerDelegete(Invoker<T> invoker, URL url) {
            super(invoker, url);
            this.invoker = invoker;
        }

        public Invoker<T> getInvoker() {
            if (this.invoker instanceof InvokerDelegete) {
                return ((InvokerDelegete)this.invoker).getInvoker();
            }
            return this.invoker;
        }
    }
}

