/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CommitMessage;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.RollbackMessage;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.TerminationResult;
import com.atomikos.icatch.imp.thread.InterruptedExceptionHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class HeurHazardStateHandler
extends CoordinatorStateHandler {
    private Vector hazards_;

    HeurHazardStateHandler(CoordinatorImp coordinator) {
        super(coordinator);
        this.hazards_ = new Vector();
    }

    HeurHazardStateHandler(CoordinatorStateHandler previous, Vector hazards) {
        super(previous);
        this.hazards_ = (Vector)hazards.clone();
    }

    HeurHazardStateHandler(CoordinatorStateHandler previous, Hashtable hazards) {
        super(previous);
        this.hazards_ = new Vector();
        this.hazards_.addAll(hazards.keySet());
    }

    protected void recover(CoordinatorImp coordinator) {
        super.recover(coordinator);
        Enumeration enumm = this.getCoordinator().getParticipants().elements();
        while (enumm.hasMoreElements()) {
            Participant p = (Participant)enumm.nextElement();
            if (this.getReadOnlyTable().containsKey(p)) continue;
            this.replayCompletion(p);
        }
    }

    protected Object getState() {
        return TxState.HEUR_HAZARD;
    }

    protected void onTimeout() {
        boolean committed = this.getCommitted();
        this.addAllForReplay(this.hazards_);
        Stack replayStack = this.getReplayStack();
        boolean replay = false;
        if (!replayStack.empty()) {
            replay = true;
            int count = replayStack.size();
            TerminationResult result = new TerminationResult(count);
            while (!replayStack.empty()) {
                Participant part = (Participant)replayStack.pop();
                if (committed) {
                    CommitMessage cm = new CommitMessage(part, result, false);
                    this.getPropagator().submitPropagationMessage(cm);
                    continue;
                }
                RollbackMessage rm = new RollbackMessage(part, result, true);
                this.getPropagator().submitPropagationMessage(rm);
            }
            try {
                result.waitForReplies();
                Stack replies = result.getReplies();
                Enumeration enumm = replies.elements();
                while (enumm.hasMoreElements()) {
                    Reply reply = (Reply)enumm.nextElement();
                    if (reply.hasFailed()) continue;
                    this.hazards_.remove(reply.getParticipant());
                }
            }
            catch (InterruptedException inter) {
                InterruptedExceptionHelper.handleInterruptedException(inter);
            }
        }
        if (this.hazards_.isEmpty()) {
            TerminatedStateHandler termStateHandler = new TerminatedStateHandler(this);
            this.getCoordinator().setStateHandler(termStateHandler);
        } else if (replay) {
            this.getCoordinator().setStateHandler(this);
        }
    }

    protected void setGlobalSiblingCount(int count) {
    }

    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        throw new HeurHazardException(this.getHeuristicMessages());
    }

    protected HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        throw new HeurHazardException(this.getHeuristicMessages());
    }

    protected HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        throw new HeurHazardException(this.getHeuristicMessages());
    }
}

