/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallActionType;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemAction;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesComputerCallMoveAction
extends ResponsesComputerCallItemAction {
    private ResponsesComputerCallActionType type = ResponsesComputerCallActionType.MOVE;
    private final int x;
    private final int y;

    public ResponsesComputerCallMoveAction(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public ResponsesComputerCallActionType getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallMoveAction fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallMoveAction)jsonReader.readObject(reader -> {
            int x = 0;
            int y = 0;
            ResponsesComputerCallActionType type = ResponsesComputerCallActionType.MOVE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesComputerCallActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallMoveAction deserializedResponsesComputerCallMoveAction = new ResponsesComputerCallMoveAction(x, y);
            deserializedResponsesComputerCallMoveAction.type = type;
            return deserializedResponsesComputerCallMoveAction;
        });
    }
}

