/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.common.pagination;

import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;

public class TokenBasedPaginator<T>
implements Iterator<T> {
    private final PageFetcher<T> pageFetcher;
    private static final Logger logger = CozeLoggerFactory.getLogger();
    private final int pageSize;
    private Iterator<T> currentIterator;
    private PageResponse<T> currentPage;
    private String pageToken;

    public TokenBasedPaginator(PageFetcher<T> pageFetcher, int pageSize) {
        this.pageFetcher = pageFetcher;
        this.pageSize = pageSize;
    }

    private void fetchNextPage() {
        try {
            PageRequest request = PageRequest.builder().pageToken(this.pageToken).pageSize(this.pageSize).build();
            this.currentPage = this.pageFetcher.fetch(request);
            logger.info("Fetched page: " + this.pageToken + " success, got" + this.currentPage.getData().size() + " items");
            this.currentIterator = this.currentPage.getData().iterator();
            this.pageToken = this.currentPage.getPageToken();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch page", e);
        }
    }

    public void setCurrentPage(PageResponse<T> currentPage) {
        this.currentPage = currentPage;
        this.pageToken = currentPage.getPageToken();
        this.currentIterator = currentPage.getData().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            this.fetchNextPage();
            return this.currentIterator.hasNext();
        }
        if (this.currentIterator.hasNext()) {
            return true;
        }
        if (this.currentPage.isHasMore() && this.pageToken != null) {
            this.fetchNextPage();
            return this.currentIterator.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }
}

