/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.StringIdItem;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;

public final class StringIdsSection
extends UniformItemSection {
    private final TreeMap<CstUtf8, StringIdItem> strings = new TreeMap();

    public StringIdsSection(DexFile file) {
        super("string_ids", file, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.strings.values();
    }

    @Override
    public IndexedItem get(Constant cst) {
        IndexedItem result;
        if (cst == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        if (cst instanceof CstString) {
            cst = ((CstString)cst).getString();
        }
        if ((result = (IndexedItem)this.strings.get((CstUtf8)cst)) == null) {
            throw new IllegalArgumentException("not found");
        }
        return result;
    }

    public void writeHeaderPart(AnnotatedOutput out) {
        int offset;
        this.throwIfNotPrepared();
        int sz = this.strings.size();
        int n = offset = sz == 0 ? 0 : this.getFileOffset();
        if (out.annotates()) {
            out.annotate(4, "string_ids_size: " + Hex.u4(sz));
            out.annotate(4, "string_ids_off:  " + Hex.u4(offset));
        }
        out.writeInt(sz);
        out.writeInt(offset);
    }

    public StringIdItem intern(String string) {
        CstUtf8 utf8 = new CstUtf8(string);
        return this.intern(new StringIdItem(utf8));
    }

    public StringIdItem intern(CstString string) {
        CstUtf8 utf8 = string.getString();
        return this.intern(new StringIdItem(utf8));
    }

    public StringIdItem intern(CstUtf8 string) {
        return this.intern(new StringIdItem(string));
    }

    public StringIdItem intern(StringIdItem string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.throwIfPrepared();
        CstUtf8 value = string.getValue();
        StringIdItem already = this.strings.get(value);
        if (already != null) {
            return already;
        }
        this.strings.put(value, string);
        return string;
    }

    public void intern(CstNat nat) {
        this.intern(nat.getName());
        this.intern(nat.getDescriptor());
    }

    public int indexOf(CstUtf8 string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.throwIfNotPrepared();
        StringIdItem s = this.strings.get(string);
        if (s == null) {
            throw new IllegalArgumentException("not found");
        }
        return s.getIndex();
    }

    public int indexOf(CstString string) {
        return this.indexOf(string.getString());
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        for (StringIdItem s : this.strings.values()) {
            s.setIndex(idx);
            ++idx;
        }
    }
}

