/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler;

import com.dragome.commons.compiler.BytecodeToJavascriptCompiler;
import com.dragome.commons.compiler.BytecodeToJavascriptCompilerConfiguration;
import com.dragome.commons.compiler.BytecodeTransformer;
import com.dragome.commons.compiler.annotations.CompilerType;
import com.dragome.compiler.Project;
import com.dragome.compiler.generators.AbstractVisitor;
import com.dragome.compiler.generators.DragomeJavaScriptGenerator;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.utils.FileManager;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.utils.Utils;
import com.dragome.compiler.writer.Assembly;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DragomeJsCompiler
implements BytecodeToJavascriptCompiler {
    public static DragomeJsCompiler compiler;
    public static int errorCount;
    private File basedir;
    private File cacheFile;
    List<Assembly> assemblies = new ArrayList<Assembly>();
    private List<File> classpath = new ArrayList<File>();
    public FileManager fileManager;
    public boolean optimize = true;
    public boolean failOnError = false;
    private boolean compression = true;
    private String singleEntryPoint;
    private String targetPlatform;
    public int reductionLevel = 5;
    private int junkSizeInKiloBytes = Integer.MAX_VALUE;
    private boolean generateLineNumbers = false;
    public int compileCount = 0;
    public AbstractVisitor generator;
    private Log logger;
    private FileFilter classpathFilter;
    public BytecodeTransformer bytecodeTransformer;
    public CompilerType compilerType;
    public BytecodeToJavascriptCompilerConfiguration compilerConfiguration;
    private boolean initialized = false;

    public static void main(String[] argv) throws Exception {
        if (argv == null || argv.length != 4) {
            StringBuffer sb = new StringBuffer();
            sb.append("Usage: java ");
            sb.append(DragomeJsCompiler.class.getName());
            sb.append(" <basedir> <classpathElements> <entryPointClassName> <targetLocation>");
            System.out.print(sb.toString());
            return;
        }
        File basedir = new File(argv[0]);
        String classpathElements = argv[1];
        String entryPointClassName = argv[2];
        Assembly assembly = new Assembly();
        assembly.setEntryPointClassName(entryPointClassName);
        assembly.setTargetLocation(new File(argv[3]));
        DragomeJsCompiler compiler = new DragomeJsCompiler(CompilerType.Standard);
        compiler.setBasedir(basedir);
        compiler.addClasspathElements(classpathElements);
        compiler.addAssembly(assembly);
        compiler.setGenerateLineNumbers(false);
        compiler.setCompression(false);
        compiler.compile();
    }

    public DragomeJsCompiler(BytecodeToJavascriptCompilerConfiguration compilerConfiguration) {
        this.configure(compilerConfiguration);
    }

    public void configure(BytecodeToJavascriptCompilerConfiguration compilerConfiguration) {
        if (!this.initialized) {
            compiler = this;
            this.compilerConfiguration = compilerConfiguration;
            this.initFromCompilerType(compilerConfiguration.getCompilerType());
            Project.singleton = null;
            String classpathElements = compilerConfiguration.getClassPath();
            compiler.addClasspathElements(classpathElements);
            compiler.addClasspathFilter(compilerConfiguration.getClasspathFilter());
            if (compilerConfiguration.getBytecodeTransformer() != null) {
                compiler.setBytecodeTransformer(compilerConfiguration.getBytecodeTransformer());
            }
            Assembly assembly = new Assembly();
            assembly.setEntryPointClassName(compilerConfiguration.getMainClassName());
            assembly.setTargetLocation(new File(compilerConfiguration.getTargetDir()));
            compiler.addAssembly(assembly);
            compiler.setGenerateLineNumbers(false);
            compiler.setCompression(false);
            this.initialized = true;
        }
    }

    public DragomeJsCompiler(CompilerType compilerType) {
        this.initFromCompilerType(compilerType);
    }

    private void initFromCompilerType(CompilerType compilerType) {
        this.compilerType = compilerType;
        this.setBasedir(new File(System.getProperty("user.dir")));
        this.setTargetPlatform("web");
    }

    public DragomeJsCompiler() {
    }

    public void compile() {
        this.configure(this.compilerConfiguration);
        try {
            if (this.logger == null) {
                this.setLogger(new Log());
            }
            for (Assembly assembly : this.assemblies) {
                this.execute(assembly);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMavenExecution() {
        return System.getProperty("localRepository") != null;
    }

    public void execute(Assembly assembly) throws Exception {
        long startTime = System.currentTimeMillis();
        compiler = this;
        this.logger.debug("Entry point is " + assembly.getEntryPointClassName() + "#main(java.lang.String[])void");
        if (this.classpath == null) {
            throw new RuntimeException("Field classPath must be set");
        }
        if (assembly.getEntryPointClassName() == null) {
            throw new RuntimeException("Field assembly.entryPointClassName must be set");
        }
        if (this.cacheFile == null) {
            String property = "target";
            if (!new File(property).exists()) {
                property = System.getProperty("cache-dir");
            }
            File file = new File(property + "/dragome.cache");
            this.setCacheFile(file);
        }
        if (assembly.getTargetLocation() == null) {
            throw new RuntimeException("Field assembly.targetLocation must be set");
        }
        this.logger.debug("Creating assembly " + assembly.getTargetLocation());
        this.logger.infoSameLine("Compiling classes: ");
        this.fileManager = new FileManager(this.classpath, this.classpathFilter, this.compilerConfiguration.getExtraClasspath());
        Project project = Project.createSingleton(this.getCacheFile());
        assembly.setProject(project);
        assembly.setClasspathFilter(this.classpathFilter);
        this.generator = new DragomeJavaScriptGenerator(project);
        errorCount = 0;
        Collection<String> allFilesInClasspath = this.fileManager.getAllFilesInClasspath();
        for (String file : allFilesInClasspath) {
            assembly.resolveNoTainting(file.replace(File.separator, "."));
        }
        assembly.addEntryPoint(assembly.getEntryPointClassName() + "#onCreate()void");
        for (String memberSignature : assembly.entryPoints) {
            assembly.taint(memberSignature);
        }
        if (compiler.getSingleEntryPoint() != null) {
            assembly.processSingle(project.getSignature(this.getSingleEntryPoint()));
        } else {
            assembly.processTainted();
        }
        try {
            int methodCount = assembly.createAssembly();
            if (this.getCacheFile() != null) {
                Project.write();
            }
            Collection<ClassUnit> classes = assembly.getProject().getClasses();
            for (ClassUnit classUnit : classes) {
                try {
                    classUnit.getClassFile().close();
                }
                catch (Exception e) {}
            }
        }
        catch (IOException e) {
            throw new Exception("Error while creating assembly", e);
        }
        this.logger.infoSameLine("\n\n");
        this.logger.infoSameLine("Compiled classes: " + this.compileCount);
        this.logger.infoSameLine("\n");
        this.logger.infoSameLine("Total time: " + (System.currentTimeMillis() - startTime) + " ms");
        this.logger.infoSameLine("\n");
        if (errorCount > 0) {
            this.logger.error("There " + this.timesName("was|were", errorCount, "error|errors") + ".");
        }
    }

    private String timesName(String verb, int count, String noun) {
        String[] verbs = verb.split("\\|");
        String[] nouns = noun.split("\\|");
        int index = count == 1 ? 0 : 1;
        return verbs[index] + " " + nouns[index] + ": " + count;
    }

    public void setCompression(boolean isCompression) {
        this.compression = isCompression;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setSingleEntryPoint(String signature) {
        this.singleEntryPoint = signature;
    }

    public String getSingleEntryPoint() {
        return this.singleEntryPoint;
    }

    public void setTargetPlatform(String targetPlatform) {
        if (!"web".equals(targetPlatform = targetPlatform.toLowerCase()) && !"javascript".equals(targetPlatform)) {
            throw new IllegalArgumentException("Target platform must be web or javascript");
        }
        this.targetPlatform = targetPlatform;
    }

    public String getTargetPlatform() {
        return this.targetPlatform;
    }

    public List<File> getClasspath() {
        return this.classpath;
    }

    public void addClasspathElements(List<File> classpathElements) {
        this.classpath.addAll(classpathElements);
    }

    public void addClasspathElement(File classpathElement) {
        this.classpath.add(classpathElement);
    }

    public void addClasspathElements(String classPathElements) {
        String[] array;
        for (String path : array = classPathElements.split("(;|,)")) {
            if ((path = path.trim()).length() <= 0) continue;
            this.addClasspathElement(Utils.resolve(this.basedir, path));
        }
    }

    public void setClasspathElements(List<String> classpathElements) {
        for (String part : classpathElements) {
            this.addClasspathElements(part);
        }
    }

    public void setFailOnError(boolean flag) {
        this.failOnError = flag;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public void setCacheFile(File theCacheFile) {
        this.cacheFile = theCacheFile;
    }

    public List<Assembly> getAssemblies() {
        return this.assemblies;
    }

    public void setAssemlies(List<Assembly> assemblies) {
        this.assemblies = assemblies;
    }

    public void setGenerateLineNumbers(boolean theGenerateLineNumbers) {
        this.generateLineNumbers = theGenerateLineNumbers;
    }

    public boolean isGenerateLineNumbers() {
        return this.generateLineNumbers;
    }

    public void setJunkSizeInKiloBytes(int junkSizeInKiloBytes) {
        if (junkSizeInKiloBytes < 1) {
            throw new RuntimeException("Junk size must be greater than zero.");
        }
        this.junkSizeInKiloBytes = junkSizeInKiloBytes;
    }

    public int getJunkSizeInKiloBytes() {
        return this.junkSizeInKiloBytes;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
        Log.logger = logger;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void addAssembly(Assembly assembly) {
        this.assemblies.add(assembly);
    }

    public void addClasspathFilter(FileFilter classpathFilter) {
        this.classpathFilter = classpathFilter;
    }

    public void setBytecodeTransformer(BytecodeTransformer bytecodeTransformer) {
        this.bytecodeTransformer = bytecodeTransformer;
    }

    public void setCompilerConfiguration(BytecodeToJavascriptCompilerConfiguration compilerConfiguration) {
        this.compilerConfiguration = compilerConfiguration;
    }

    static {
        errorCount = 0;
    }
}

