/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.IfStatement;
import com.dragome.compiler.generators.AbstractVisitor;

public class ASTNode {
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int SAME = 2;
    public static final int CONTAINS = 3;
    public static final int ISCONTAINED = 4;
    int beginIndex = Integer.MAX_VALUE;
    int endIndex = Integer.MIN_VALUE;
    private ASTNode parent = null;
    private ASTNode previousSibling = null;
    private ASTNode nextSibling = null;
    private int stackDelta = 0;

    public ASTNode() {
    }

    public ASTNode(int theBeginIndex, int theEndIndex) {
        this.setRange(theBeginIndex, theEndIndex);
    }

    public int getStackDelta() {
        return this.stackDelta;
    }

    public void setStackDelta(int theStackDelta) {
        this.stackDelta = theStackDelta;
    }

    public void widen(ASTNode node) {
        this.leftWiden(node.beginIndex);
        this.rightWiden(node.endIndex);
    }

    public void leftWiden(int targetBeginIndex) {
        if (targetBeginIndex < this.beginIndex) {
            this.beginIndex = targetBeginIndex;
        }
    }

    public void rightWiden(int targetEndIndex) {
        if (targetEndIndex > this.endIndex) {
            this.endIndex = targetEndIndex;
        }
    }

    public void setRange(int theBeginIndex, int theEndIndex) {
        this.setBeginIndex(theBeginIndex);
        this.setEndIndex(theEndIndex);
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int theBeginIndex) {
        this.beginIndex = theBeginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int theEndIndex) {
        this.endIndex = theEndIndex;
    }

    public boolean isRightSiblingOf(ASTNode leftSibling) {
        for (ASTNode node = this; node != null; node = node.getPreviousSibling()) {
            if (node != leftSibling) continue;
            return true;
        }
        return false;
    }

    public ASTNode rightMostSibling() {
        ASTNode node = this;
        while (node.getNextSibling() != null) {
            node = node.getNextSibling();
        }
        return node;
    }

    public boolean isAncestorOf(ASTNode node) {
        do {
            if ((node = node.getParentNode()) != this) continue;
            return true;
        } while (node != null);
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this.getBeginIndex() != Integer.MAX_VALUE) {
            sb.append("[");
            sb.append(this.getBeginIndex());
            sb.append(", ");
            sb.append(this.getEndIndex());
            sb.append("]");
        }
        return sb.toString();
    }

    public ASTNode getParentNode() {
        return this.parent;
    }

    public Block getParentBlock() {
        return (Block)this.parent;
    }

    public Block getLogicalParentBlock() {
        if (this.parent != null && this.parent.parent instanceof IfStatement) {
            return (Block)this.parent.parent;
        }
        return (Block)this.parent;
    }

    public void setParentNode(ASTNode theParent) {
        this.parent = theParent;
    }

    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public ASTNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(ASTNode theNextSibling) {
        this.nextSibling = theNextSibling;
    }

    public ASTNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(ASTNode thePreviousSibling) {
        this.previousSibling = thePreviousSibling;
    }
}

