/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.Project;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.generators.AbstractVisitor;
import org.apache.bcel.generic.ObjectType;

public abstract class FieldAccess
extends Expression {
    private String name;
    private ObjectType type;

    public void initialize(MethodDeclaration methodDecl) {
        Project.getSingleton().addReference(methodDecl, this);
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isSame(Object obj) {
        if (!(obj instanceof FieldAccess)) {
            return false;
        }
        FieldAccess other = (FieldAccess)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.getExpression() instanceof VariableBinding && other.getExpression() instanceof VariableBinding) {
            VariableBinding vba = (VariableBinding)this.getExpression();
            VariableBinding vbb = (VariableBinding)other.getExpression();
            return vba.getVariableDeclaration() == vbb.getVariableDeclaration();
        }
        return false;
    }

    public Expression getExpression() {
        return (Expression)this.getFirstChild();
    }

    public void setExpression(Expression expression) {
        this.widen(expression);
        this.removeChildren();
        this.appendChild(expression);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.name;
    }

    public ObjectType getType() {
        return this.type;
    }

    public void setType(ObjectType theType) {
        if (this.type != null) {
            throw new RuntimeException("Type is already set");
        }
        this.type = theType;
    }
}

