/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.utils.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class MethodBinding {
    private static Map<String, MethodBinding> methodBindingsByKey = new LinkedHashMap<String, MethodBinding>();
    private ObjectType declaringClass;
    private String name;
    private Type[] parameterTypes;
    private Type returnType;
    private String signature;

    public static MethodBinding lookup(int index, ConstantPool constantPool) {
        ConstantCP methodRef = (ConstantCP)constantPool.getConstant(index);
        ConstantNameAndType nameAndType = (ConstantNameAndType)constantPool.getConstant(methodRef.getNameAndTypeIndex(), (byte)12);
        String name = nameAndType.getName(constantPool);
        String signature = nameAndType.getSignature(constantPool);
        return MethodBinding.lookup(methodRef.getClass(constantPool), name, signature);
    }

    public static MethodBinding lookup(String className, String name, String signature) {
        String key = className + "#" + name + signature;
        MethodBinding binding = methodBindingsByKey.get(key);
        if (binding != null) {
            return binding;
        }
        binding = new MethodBinding();
        binding.declaringClass = new ObjectType(className);
        binding.name = name;
        binding.parameterTypes = Type.getArgumentTypes((String)signature);
        binding.returnType = Type.getReturnType((String)signature);
        binding.signature = signature;
        methodBindingsByKey.put(key, binding);
        return binding;
    }

    private MethodBinding() {
    }

    public ObjectType getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return this.getDeclaringClass().getClassName() + "#" + this.getRelativeSignature();
    }

    public String getRelativeSignature() {
        String signature = this.getName() + "(";
        String sep = "";
        for (int i = 0; i < this.getParameterTypes().length; ++i) {
            Type type = this.getParameterTypes()[i];
            signature = signature + sep + Utils.getSignature(type);
            sep = ",";
        }
        signature = signature + ")";
        signature = signature + Utils.getSignature(this.returnType);
        return signature;
    }
}

