/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.Project;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.ASTNodeStack;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.ThisExpression;
import com.dragome.compiler.generators.AbstractVisitor;
import java.util.List;
import org.apache.bcel.generic.Type;

public class MethodInvocation
extends Expression {
    private Expression expression;
    public MethodDeclaration methodDecl;
    public boolean isSpecial = false;
    private MethodBinding methodBinding;

    public MethodInvocation() {
    }

    public MethodInvocation(MethodDeclaration theMethodDecl) {
        this.methodDecl = theMethodDecl;
    }

    public MethodInvocation(MethodDeclaration theMethodDecl, MethodBinding theMethodBinding) {
        this.methodDecl = theMethodDecl;
        this.setMethodBinding(theMethodBinding);
    }

    @Override
    public Type getTypeBinding() {
        if (this.methodBinding == null) {
            return super.getTypeBinding();
        }
        return this.methodBinding.getReturnType();
    }

    public boolean isSuper(String currentClassName) {
        if (!this.isSpecial) {
            return false;
        }
        if (this.methodBinding.isConstructor() && !(this.getExpression() instanceof ThisExpression)) {
            return false;
        }
        String name = this.methodBinding.getDeclaringClass().getClassName();
        return !currentClassName.equals(name);
    }

    public List getArguments() {
        ASTNodeStack stack = new ASTNodeStack();
        ASTNode node = this.getFirstChild();
        if (this.expression != null) {
            node = node.getNextSibling();
        }
        while (node != null) {
            stack.add(node);
            node = node.getNextSibling();
        }
        return stack;
    }

    public void addArgument(Expression argument) {
        this.widen(argument);
        this.appendChild(argument);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression targetExpression) {
        if (this.expression != null) {
            throw new RuntimeException("Expression is already set");
        }
        this.expression = targetExpression;
        this.widen(this.expression);
        this.insertBefore(this.expression, this.getFirstChild());
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    public void setMethodBinding(MethodBinding theMethodBinding) {
        this.methodBinding = theMethodBinding;
        Project.getSingleton().addReference(this.methodDecl, this);
    }
}

