/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.generators.AbstractVisitor;
import org.apache.bcel.generic.Type;

public class NumberLiteral
extends Expression {
    public static Number ZERO = new Integer(0);
    public static Number ONE = new Integer(1);
    public static Number MINUS_ONE = new Integer(-1);
    private Number value;

    public static boolean isZero(Expression expr) {
        if (expr == null || !(expr instanceof NumberLiteral)) {
            return false;
        }
        return ((NumberLiteral)expr).getValue().equals(ZERO);
    }

    public static boolean isOne(Expression expr) {
        if (expr == null || !(expr instanceof NumberLiteral)) {
            return false;
        }
        return ((NumberLiteral)expr).getValue().equals(ONE);
    }

    public static boolean isMinusOne(Expression expr) {
        if (expr == null || !(expr instanceof NumberLiteral)) {
            return false;
        }
        return ((NumberLiteral)expr).getValue().equals(MINUS_ONE);
    }

    private NumberLiteral(Number theValue) {
        this.value = theValue;
        if (theValue instanceof Integer) {
            this.type = Type.INT;
        } else if (theValue instanceof Byte) {
            this.type = Type.BYTE;
        } else if (theValue instanceof Float) {
            this.type = Type.FLOAT;
        } else if (theValue instanceof Double) {
            this.type = Type.DOUBLE;
        } else if (theValue instanceof Long) {
            this.type = Type.LONG;
        } else if (theValue instanceof Short) {
            this.type = Type.SHORT;
        } else {
            throw new RuntimeException("Type not supported: " + theValue.getClass());
        }
    }

    public static NumberLiteral create(int i) {
        Number value = i == 0 ? (Number)ZERO : (Number)(i == 1 ? (Number)ONE : (Number)new Integer(i));
        return new NumberLiteral(value);
    }

    public static NumberLiteral create(Number value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (i == 0) {
                value = ZERO;
            } else if (i == 1) {
                value = ONE;
            }
        }
        return new NumberLiteral(value);
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number theValue) {
        this.value = theValue;
    }

    @Override
    public String toString() {
        return super.toString() + " value " + this.value;
    }
}

