/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.Project;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.generators.AbstractVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.bcel.generic.ObjectType;

public class TypeDeclaration
extends ASTNode {
    private ObjectType type;
    private ObjectType superType;
    private ArrayList<MethodDeclaration> methods = new ArrayList();
    private List<VariableDeclaration> fields = new ArrayList<VariableDeclaration>();
    private int accessFlags;
    private Map<String, String> annotations;

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public TypeDeclaration(ObjectType theType, int theAccessFlags, Map<String, String> annotations) {
        this.type = theType;
        this.accessFlags = theAccessFlags;
        this.annotations = annotations;
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public MethodDeclaration[] getMethods() {
        MethodDeclaration[] a = new MethodDeclaration[this.methods.size()];
        return this.methods.toArray(a);
    }

    public int getAccess() {
        return this.accessFlags;
    }

    public void addMethod(MethodDeclaration method) {
        method.setParentNode(this);
        this.methods.add(method);
    }

    public ObjectType getType() {
        return this.type;
    }

    public String getPackageName() {
        String name = this.type.getClassName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    public String getClassName() {
        return this.type.getClassName();
    }

    public String getUnQualifiedName() {
        String name = this.type.getClassName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public List<VariableDeclaration> getFields() {
        return this.fields;
    }

    public void addField(VariableDeclaration field) {
        this.fields.add(field);
        Project.getSingleton().getOrCreateFieldUnit(this.type, field.getName());
    }

    public ObjectType getSuperType() {
        return this.superType;
    }

    public void setSuperType(ObjectType newSuperType) {
        this.superType = newSuperType;
    }

    @Override
    public String toString() {
        return this.type.getClassName();
    }
}

