/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Assignable;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.generators.AbstractVisitor;
import org.apache.bcel.generic.Type;

public class VariableBinding
extends Expression
implements Assignable {
    private boolean field;
    private VariableDeclaration decl;
    private boolean isTemporary = false;

    public static boolean isBoolean(Expression expr) {
        if (expr == null || !(expr instanceof VariableBinding)) {
            return false;
        }
        return ((VariableBinding)expr).getVariableDeclaration().getType() == Type.BOOLEAN;
    }

    public VariableBinding(VariableDeclaration theDecl) {
        this.decl = theDecl;
        this.decl.vbs.add(this);
        this.setTypeBinding(theDecl.getType());
    }

    @Override
    public Object clone() {
        VariableBinding other = (VariableBinding)super.clone();
        this.decl.vbs.add(other);
        return other;
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isSame(Object other) {
        if (other == null || !(other instanceof VariableBinding)) {
            return false;
        }
        return this.decl == ((VariableBinding)other).decl;
    }

    public String getName() {
        return this.decl.getName();
    }

    public boolean isField() {
        return this.field;
    }

    public void setField(boolean theField) {
        this.field = theField;
    }

    public VariableDeclaration getVariableDeclaration() {
        return this.decl;
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + this.decl.getName();
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }
}

