/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.generators;

import com.dragome.commons.compiler.annotations.DragomeCompilerSettings;
import com.dragome.commons.compiler.annotations.MethodAlias;
import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.ArrayAccess;
import com.dragome.compiler.ast.ArrayCreation;
import com.dragome.compiler.ast.ArrayInitializer;
import com.dragome.compiler.ast.Assignment;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanLiteral;
import com.dragome.compiler.ast.BreakStatement;
import com.dragome.compiler.ast.CastExpression;
import com.dragome.compiler.ast.CatchClause;
import com.dragome.compiler.ast.ClassInstanceCreation;
import com.dragome.compiler.ast.ClassLiteral;
import com.dragome.compiler.ast.ConditionalExpression;
import com.dragome.compiler.ast.ContinueStatement;
import com.dragome.compiler.ast.DoStatement;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.FieldAccess;
import com.dragome.compiler.ast.FieldRead;
import com.dragome.compiler.ast.IfStatement;
import com.dragome.compiler.ast.InfixExpression;
import com.dragome.compiler.ast.InstanceofExpression;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.MethodInvocation;
import com.dragome.compiler.ast.Name;
import com.dragome.compiler.ast.NullLiteral;
import com.dragome.compiler.ast.NumberLiteral;
import com.dragome.compiler.ast.PostfixExpression;
import com.dragome.compiler.ast.PrefixExpression;
import com.dragome.compiler.ast.PrimitiveCast;
import com.dragome.compiler.ast.ReturnStatement;
import com.dragome.compiler.ast.StringLiteral;
import com.dragome.compiler.ast.SwitchCase;
import com.dragome.compiler.ast.SwitchStatement;
import com.dragome.compiler.ast.SynchronizedBlock;
import com.dragome.compiler.ast.ThisExpression;
import com.dragome.compiler.ast.ThrowStatement;
import com.dragome.compiler.ast.TryStatement;
import com.dragome.compiler.ast.TypeDeclaration;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.ast.WhileStatement;
import com.dragome.compiler.generators.Generator;
import com.dragome.compiler.parser.Pass1;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.units.FieldUnit;
import com.dragome.compiler.units.ProcedureUnit;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DragomeJavaScriptGenerator
extends Generator {
    public static final String DRAGOME_PACKAGE = "dragome";
    private static int parametersSignaturesCounter;
    public static Map<String, Integer> parametersSignatures;
    private ASTNode currentNode;
    private MethodDeclaration currentMethodDeclaration;
    private Project project;
    private ByteArrayOutputStream baStream = new ByteArrayOutputStream();

    public DragomeJavaScriptGenerator(Project theProject) {
        this.project = theProject;
        this.setOutputStream(new PrintStream(this.baStream));
    }

    private String reset() {
        this.flush();
        String s = this.baStream.toString();
        this.baStream.reset();
        return s;
    }

    private void consume(Object object) {
        object = object == null ? object : object;
    }

    @Override
    public void visit(TypeDeclaration theTypeDecl) {
        Map<String, String> annotations = theTypeDecl.getAnnotations();
        ClassUnit classUnit = this.project.getClassUnit((ReferenceType)theTypeDecl.getType());
        this.lastChar = '\u0000';
        this.currentNode = null;
        this.depth = 0;
        this.typeDecl = theTypeDecl;
        boolean isInterface = Modifier.isInterface(this.typeDecl.getAccess());
        String type = isInterface ? "Interface" : "Class";
        this.print("qx." + type + ".define(\"");
        this.print(DragomeJavaScriptGenerator.normalizeExpression(theTypeDecl.getClassName()));
        this.println("\", ");
        this.println("{");
        ++this.depth;
        if (classUnit.getSuperUnit() != null) {
            String superUnitName = DragomeJavaScriptGenerator.normalizeExpression(classUnit.getSuperUnit().getName());
            this.print("extend: " + superUnitName);
            this.println(",");
        } else {
            if (!classUnit.getName().equals("java.lang.Object")) {
                this.print("extend: java_lang_Object");
            } else {
                this.print("extend: qx.core.Object");
            }
            this.println(",");
        }
        if (!classUnit.getName().equals("java.lang.Object")) {
            this.println("construct: function(){},");
        }
        classUnit.setData(this.reset());
        List<VariableDeclaration> fields = theTypeDecl.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableDeclaration decl = fields.get(i);
            if (decl.getLocation() != VariableDeclaration.NON_LOCAL) continue;
            decl.visit(this);
        }
        --this.depth;
        ++this.depth;
        MethodDeclaration[] methods = theTypeDecl.getMethods();
        ArrayList<String> processedMethods = new ArrayList<String>();
        for (int i = 0; i < methods.length; ++i) {
            MethodDeclaration method;
            this.currentMethodDeclaration = method = methods[i];
            try {
                String normalizeExpression = DragomeJavaScriptGenerator.normalizeExpression(Project.getSingleton().getSignature(method.getMethodBinding().toString()).relative());
                if (!processedMethods.contains(normalizeExpression)) {
                    processedMethods.add(normalizeExpression);
                    method.visit(this);
                    continue;
                }
                System.out.println("duplicado!");
                continue;
            }
            catch (RuntimeException ex) {
                throw Utils.generateException(ex, method, this.currentNode);
            }
        }
        processedMethods.clear();
        --this.depth;
        this.reset();
        ++this.depth;
        --this.depth;
        classUnit.setData(classUnit.getData() + this.reset());
    }

    @Override
    public void visit(MethodDeclaration method) {
        String closingString;
        String annotationKey = DragomeCompilerSettings.class.getName() + "#" + "value";
        String compiler = DragomeJsCompiler.compiler.compilerType.name();
        String methodCompilerType = method.getAnnotationsValues().get(annotationKey);
        String classCompilerType = this.typeDecl.getAnnotations().get(annotationKey);
        if (methodCompilerType != null) {
            compiler = methodCompilerType;
        } else if (classCompilerType != null) {
            compiler = classCompilerType;
        }
        if ("Strict".equalsIgnoreCase(compiler)) {
            ClassUnit classUnit = this.project.getClassUnit(method.getMethodBinding().getDeclaringClass().getClassName());
            classUnit.addNotReversibleMethod(Pass1.extractMethodNameSignature(method.getMethodBinding()));
        }
        MethodBinding methodBinding = method.getMethodBinding();
        ProcedureUnit unit = this.project.getProcedureUnit(methodBinding);
        if (method.getBody() == null && Modifier.isNative(method.getAccess())) {
            if (Modifier.isNative(method.getAccess()) || Modifier.isAbstract(method.getAccess()) || Modifier.isInterface(this.typeDecl.getAccess())) {
                return;
            }
            throw new RuntimeException("Method " + method + " with access " + method.getAccess() + " may not have empty body");
        }
        Signature signature = Project.getSingleton().getSignature(methodBinding.toString()).relative();
        String signatureReplaced = DragomeJavaScriptGenerator.normalizeExpression(signature);
        if (this.typeDecl.getClassName().equals("java.lang.String") && method.isInstanceConstructor()) {
            Block body = method.getBody();
            body.removeChild(body.getFirstChild());
            MethodInvocation consume = (MethodInvocation)body.getLastChild();
            body.removeChild(consume);
            ReturnStatement r = new ReturnStatement(0, 0);
            r.setExpression((Expression)consume.getArguments().get(0));
            body.appendChild(r);
            this.print("_dragomeJs.StringInit" + signatureReplaced + " = function(");
            closingString = "};\n";
        } else {
            if (Modifier.isStatic(method.getAccess())) {
                String className = DragomeJavaScriptGenerator.normalizeExpression(method.getMethodBinding().getDeclaringClass().getClassName());
                this.print("#static-member#");
            }
            this.print(signatureReplaced);
            this.print(": ");
            String alias = method.getAnnotationsValues().get(MethodAlias.class.getName() + "#" + "alias");
            if (alias != null) {
                this.print(alias + "= ");
            }
            this.print("function (");
            closingString = "}";
        }
        Iterator<VariableDeclaration> iterator = method.getParameters().iterator();
        while (iterator.hasNext()) {
            VariableDeclaration decl = iterator.next();
            if (this.hasToEscapeVariable(decl.getName())) {
                this.print("_");
            }
            decl.visit(this);
            this.print(iterator.hasNext() ? ", " : "");
        }
        this.println(")");
        this.println("{");
        this.depth = 1;
        Collection<VariableDeclaration> localVariables = method.getLocalVariables();
        if (localVariables.size() > 0) {
            this.print("var ");
        }
        int i = 0;
        for (VariableDeclaration decl : localVariables) {
            decl.visit(this);
            if (++i >= localVariables.size()) continue;
            this.print(",");
        }
        if (localVariables.size() > 0) {
            this.println(";");
        }
        this.depth = 0;
        if (method.getBody() != null) {
            this.visit_(method.getBody());
        }
        if (method.isInstanceConstructor()) {
            this.print("return this;\n");
        }
        this.print(closingString);
        String local_alias = method.getAnnotationsValues().get(MethodAlias.class.getName() + "#" + "local_alias");
        if (local_alias != null) {
            this.print(", \n");
            this.print(local_alias + ": function() {return this." + signatureReplaced + "(arguments)}");
        }
        unit.setData(this.reset());
        Log.getLogger().debug("Generating JavaScript for " + unit);
    }

    public static String normalizeExpression(Object object) {
        if (object instanceof Signature) {
            Signature signature = (Signature)object;
            String string = signature.toString();
            string = string.replaceAll("\\[\\]", "_ARRAYTYPE");
            String result = string.replaceAll("\\(\\)", "\\$");
            result = result.replaceAll("\\)", "\\$").replaceAll("\\(", "___").replaceAll("\\.", "_").replaceAll(",", "__").replaceAll("<", "").replaceAll(">", "").replaceAll("\\[", "_").replaceAll("\\]", "_").replaceAll(";", "\\$");
            if (signature.isMethod() || signature.isConstructor()) {
                result = "$" + result;
                if (signature.isConstructor()) {
                    result = result.replaceAll("___$", "");
                    result = result.replace("$init", "$init_");
                    return "$" + result;
                }
                if ((result = result.replaceAll("___$", "")).contains("clinit")) {
                    result = "$" + result + "_";
                }
                if ("$$clinit$void_".equals(result)) {
                    result = "$$clinit_";
                }
                return result;
            }
            return result;
        }
        String string = object.toString();
        string = string.replaceAll("\\[\\]", "_ARRAYTYPE");
        return string.replaceAll("\\(", "_").replaceAll("\\)", "_").replaceAll("\\.", "_").replaceAll(",", "__").replaceAll("<", "_").replaceAll(">", "_").replaceAll("\\[", "_").replaceAll("\\]", "_").replaceAll(";", "\\$");
    }

    public static String modifyMethodName(String string) {
        if (string.contains("(")) {
            int indexOf = string.indexOf("(");
            String parametersPart = string.substring(indexOf);
            Integer counter = parametersSignatures.get(parametersPart);
            if (counter == null) {
                counter = ++parametersSignaturesCounter;
                parametersSignatures.put(parametersPart, counter);
            }
            string = string.substring(0, indexOf) + "_" + counter;
        }
        return string;
    }

    @Override
    public void visit(DoStatement doStmt) {
        this.println("do {");
        this.visit_(doStmt.getBlock());
        this.indent("} while (");
        doStmt.getExpression().visit(this);
        this.print(")");
    }

    @Override
    public void visit(WhileStatement whileStmt) {
        this.print("while (");
        whileStmt.getExpression().visit(this);
        this.println(") {");
        this.visit_(whileStmt.getBlock());
        this.indent("}");
    }

    @Override
    public void visit(IfStatement ifStmt) {
        this.print("if (");
        ifStmt.getExpression().visit(this);
        this.println(") {");
        this.visit_(ifStmt.getIfBlock());
        this.indent("}");
        if (ifStmt.getElseBlock() != null) {
            this.println(" else {");
            this.visit_(ifStmt.getElseBlock());
            this.indent("}");
        }
    }

    @Override
    public void visit(TryStatement tryStmt) {
        Block finallyBlock;
        this.println("try {");
        this.visit_(tryStmt.getTryBlock());
        this.indent("} ");
        Block clauses = tryStmt.getCatchStatements();
        CatchClause clause = (CatchClause)clauses.getFirstChild();
        String ex = null;
        if (clause != null) {
            ex = clause.getException().getName();
        }
        if (clauses.getChildCount() > 0) {
            this.println("catch(" + ex + ") {");
            ++this.depth;
            this.indent();
            while (clause != null) {
                if (clause.getException().getType() != null) {
                    this.print("if (dragomeJs.isInstanceof(" + ex + ", " + DragomeJavaScriptGenerator.normalizeExpression(Utils.getSignature(clause.getException().getType())) + ")) ");
                } else {
                    this.print("if (true)");
                }
                clause.visit(this);
                clause = (CatchClause)clause.getNextSibling();
                if (clause == null) break;
                this.print(" else ");
            }
            this.print(" else throw dragomeJs.nullSaveException(" + ex + "); ");
            this.println("");
            --this.depth;
            this.indent("}");
        }
        if ((finallyBlock = tryStmt.getFinallyBlock()) != null) {
            this.println(" finally {");
            this.visit_(finallyBlock);
            this.indent("}");
        }
    }

    @Override
    public void visit(CatchClause clause) {
        this.visit((Block)clause);
    }

    public void visit_(Block block) {
        ++this.depth;
        for (ASTNode node = block.getFirstChild(); node != null; node = node.getNextSibling()) {
            int lineNumber;
            this.currentNode = node;
            if (DragomeJsCompiler.compiler.isGenerateLineNumbers() && (lineNumber = this.currentMethodDeclaration.getLineNumberCursor().getAndMarkLineNumber(node)) != -1) {
                this.print("//ln=" + lineNumber + ";\n");
            }
            this.indent();
            if (node instanceof Block && ((Block)node).isLabeled()) {
                this.print(((Block)node).getLabel() + ": ");
            }
            node.visit(this);
            if (this.lastChar == '}') {
                this.println("");
                continue;
            }
            this.println(";");
        }
        --this.depth;
    }

    @Override
    public void visit(Block block) {
        this.println("{");
        this.visit_(block);
        this.indent("}");
    }

    @Override
    public void visit(SynchronizedBlock block) {
        this.println("{ // Synchronized.");
        this.visit_(block);
        this.indent("}");
    }

    @Override
    public void visit(PrefixExpression binOp) {
        this.print(binOp.getOperator().toString() + "(");
        binOp.getOperand().visit(this);
        this.print(")");
    }

    @Override
    public void visit(PostfixExpression binOp) {
        binOp.getOperand().visit(this);
        this.print(binOp.getOperator().toString());
    }

    private void bracket(ASTNode node, InfixExpression.Operator op) {
        if (node instanceof InfixExpression && ((InfixExpression)node).getOperator() == op || node instanceof NumberLiteral || node instanceof NullLiteral || node instanceof FieldAccess || node instanceof VariableBinding) {
            node.visit(this);
        } else {
            this.print("(");
            node.visit(this);
            this.print(")");
        }
    }

    @Override
    public void visit(InfixExpression binOp) {
        InfixExpression.Operator op = binOp.getOperator();
        Expression left = binOp.getLeftOperand();
        Expression right = binOp.getRightOperand();
        boolean isTruncate = false;
        Type type = binOp.getTypeBinding();
        if (op == InfixExpression.Operator.DIVIDE && (type.equals((Object)Type.LONG) || type.equals((Object)Type.INT))) {
            isTruncate = true;
            this.print("dragomeJs.trunc(");
        }
        this.bracket(left, op);
        this.print(" " + op + " ");
        this.bracket(right, op);
        if (isTruncate) {
            this.print(")");
        }
    }

    @Override
    public void visit(ConditionalExpression ce) {
        ce.getConditionExpression().visit(this);
        this.print("?");
        ce.getThenExpression().visit(this);
        this.print(":");
        ce.getElseExpression().visit(this);
    }

    @Override
    public void visit(InstanceofExpression node) {
        this.print("dragomeJs.isInstanceof (");
        node.getLeftOperand().visit(this);
        this.print(", ");
        Signature signature = Project.getSingleton().getArraySignature(node.getRightOperand());
        this.print(DragomeJavaScriptGenerator.normalizeExpression(signature.toString()));
        this.print(")");
    }

    @Override
    public void visit(SwitchStatement switchStmt) {
        this.print("switch (");
        switchStmt.getExpression().visit(this);
        this.println(") {");
        for (ASTNode node = switchStmt.getFirstChild(); node != null; node = node.getNextSibling()) {
            SwitchCase sc = (SwitchCase)node;
            sc.visit(this);
        }
        this.indentln("}");
    }

    @Override
    public void visit(SwitchCase switchCase) {
        Iterator<NumberLiteral> iter = switchCase.getExpressions().iterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                NumberLiteral expression = iter.next();
                this.indent("case ");
                expression.visit(this);
                this.println(":");
            }
        } else {
            this.indentln("default:");
        }
        this.visit_(switchCase);
    }

    @Override
    public void visit(ASTNode stmt) {
        this.print(stmt.toString());
    }

    @Override
    public void visit(ReturnStatement r) {
        this.print("return");
        if (r.getExpression() != null) {
            this.print(" ");
            r.getExpression().visit(this);
        }
    }

    @Override
    public void visit(Assignment a) {
        ClassInstanceCreation cic;
        Expression rhs = a.getRightHandSide();
        if (rhs instanceof ClassInstanceCreation && (cic = (ClassInstanceCreation)rhs).getTypeBinding().toString().equals("java.lang.String")) {
            return;
        }
        a.getLeftHandSide().visit(this);
        this.print(" " + a.getOperator() + " ");
        if (VariableBinding.isBoolean(a.getLeftHandSide())) {
            if (NumberLiteral.isZero(rhs)) {
                this.print("false");
            }
            if (NumberLiteral.isOne(rhs)) {
                this.print("true");
            } else {
                rhs.visit(this);
            }
        } else {
            rhs.visit(this);
        }
    }

    @Override
    public void visit(NumberLiteral literal) {
        this.print("" + literal.getValue());
    }

    @Override
    public void visit(StringLiteral literal) {
        this.print(Utils.escape(literal.getValue()));
    }

    @Override
    public void visit(ClassLiteral literal) {
        MethodBinding binding = MethodBinding.lookup("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        MethodInvocation mi = new MethodInvocation(this.currentMethodDeclaration, binding);
        mi.addArgument(new StringLiteral(literal.getSignature().toString()));
        this.visit(mi);
    }

    @Override
    public void visit(NullLiteral literal) {
        this.consume(literal);
        this.print("null");
    }

    private void generateList(List arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            this.print(i == 0 ? "" : ", ");
            ((ASTNode)arguments.get(i)).visit(this);
        }
    }

    private boolean isW3C(MethodInvocation invocation) {
        boolean isGetter;
        MethodBinding methodBinding = invocation.getMethodBinding();
        String name = methodBinding.getName();
        int argCount = invocation.getArguments().size();
        boolean isSetter = name.startsWith("set") && argCount == 1;
        boolean bl = isGetter = name.startsWith("get") && argCount == 0;
        if (!isSetter && !isGetter) {
            return false;
        }
        if (methodBinding.equals("org.w3c.dom5.NamedNodeMap") && (name.equals("setNamedItemNS") || name.equals("setNamedItem"))) {
            return false;
        }
        if (methodBinding.equals("org.w3c.dom5.Element") && (name.equals("setAttributeNode") || name.equals("setAttributeNodeNS"))) {
            return false;
        }
        if (name.equals("getContentDocument")) {
            return false;
        }
        return !name.equals("getButton");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateScriptCode(MethodInvocation invocation) {
        String firstArg;
        MethodBinding methodBinding = invocation.getMethodBinding();
        String name = methodBinding.getName();
        List args = invocation.getArguments();
        boolean isVariable = false;
        if (!(args.get(0) instanceof StringLiteral)) {
            if (!(args.get(0) instanceof VariableBinding)) throw new RuntimeException("First argument to " + methodBinding + " must be a string literal");
            VariableBinding variableBinding = (VariableBinding)args.get(0);
            firstArg = variableBinding.getName();
            isVariable = true;
        } else {
            firstArg = ((StringLiteral)args.get(0)).getValue();
        }
        if (name.equals("put")) {
            if (isVariable) {
                this.print("eval(\"var \"+");
                this.print(firstArg + "+\"=");
                ((ASTNode)args.get(1)).visit(this);
                this.print("\")");
                return;
            } else {
                if (firstArg.indexOf(46) == -1) {
                    this.print("var ");
                }
                this.print(firstArg + "=");
                ((ASTNode)args.get(1)).visit(this);
            }
            return;
        } else {
            if (!name.startsWith("eval")) throw new IllegalArgumentException("Cannot handle method " + name);
            if (isVariable) {
                this.print("eval(" + firstArg + ")");
                return;
            } else {
                this.print(firstArg);
            }
        }
    }

    private void generateArguments(MethodInvocation invocation) {
        Signature signature = DragomeJavaScriptGenerator.getSignatureOfInvocation(invocation);
        this.print(DragomeJavaScriptGenerator.normalizeExpression(signature));
        this.print("(");
        this.generateList(invocation.getArguments());
        this.print(")");
    }

    private static Signature getSignatureOfInvocation(MethodInvocation invocation) {
        MethodBinding methodBinding = invocation.getMethodBinding();
        Signature signature = Project.getSingleton().getSignature(methodBinding.getDeclaringClass().getClassName());
        signature = Project.getSingleton().getSignature(methodBinding.getRelativeSignature());
        return signature;
    }

    @Override
    public void visit(MethodInvocation invocation) {
        MethodBinding methodBinding = invocation.getMethodBinding();
        String name = methodBinding.getName();
        String className = methodBinding.getDeclaringClass().getClassName();
        if (className.equals("com.dragome.commons.javascript.ScriptHelper")) {
            this.generateScriptCode(invocation);
            return;
        }
        if (className.equals("javax.script.ScriptEngine") && (name.equals("put") || name.equals("eval"))) {
            this.generateScriptCode(invocation);
            return;
        }
        Expression expression = invocation.getExpression();
        if (className.equals("java.lang.String") && methodBinding.isConstructor()) {
            if (expression instanceof VariableBinding) {
                ((ASTNode)expression).visit(this);
                this.print(" = ");
            } else assert (expression instanceof ClassInstanceCreation);
            Signature signature = Project.getSingleton().getSignature(methodBinding.toString()).relative();
            String signatureReplaced = DragomeJavaScriptGenerator.normalizeExpression(signature);
            this.print("dragomeJs.StringInit" + signatureReplaced + "(");
            this.generateList(invocation.getArguments());
            this.print(")");
            return;
        }
        if (invocation.isSuper(this.typeDecl.getClassName())) {
            String string = "arguments.callee.self.superclass.prototype.{methodName}.call(this";
            if (methodBinding.getDeclaringClass().referencesInterface()) {
                String invokeClassName = DragomeJavaScriptGenerator.normalizeExpression(methodBinding.getDeclaringClass());
                string = invokeClassName + ".$$members.{methodName}.call(this";
            }
            if (Modifier.isStatic(invocation.methodDecl.getAccess())) {
                string = "this.superclass.prototype.{methodName}.call(arguments[0]";
            }
            Signature signature = DragomeJavaScriptGenerator.getSignatureOfInvocation(invocation);
            String methodName = DragomeJavaScriptGenerator.normalizeExpression(signature);
            string = string.replace("{methodName}", methodName);
            if (invocation.getArguments().isEmpty()) {
                this.print(string);
                this.print(")");
            } else {
                this.print(string);
                this.print(", ");
                this.generateList(invocation.getArguments());
                this.print(")");
            }
        } else if (invocation.isSpecial) {
            if (methodBinding.isConstructor() && expression instanceof ThisExpression && !"java.lang.String".equals(className)) {
                String normalizeExpression = DragomeJavaScriptGenerator.normalizeExpression(className);
                this.print(normalizeExpression);
                this.print(".prototype.");
                Signature signature = DragomeJavaScriptGenerator.getSignatureOfInvocation(invocation);
                this.print(DragomeJavaScriptGenerator.normalizeExpression(signature));
                this.print(".call(this");
                if (!invocation.getArguments().isEmpty()) {
                    this.print(",");
                }
                this.generateList(invocation.getArguments());
                this.print(")");
            } else {
                ((ASTNode)expression).visit(this);
                this.print(".");
                this.generateArguments(invocation);
            }
        } else if (expression == null) {
            boolean isStatic = true;
            Signature signature = Project.getSingleton().getSignature(methodBinding.getDeclaringClass().getClassName());
            this.print(DragomeJavaScriptGenerator.normalizeExpression(signature));
            this.print(".");
            this.generateArguments(invocation);
        } else {
            ((ASTNode)expression).visit(this);
            this.print(".");
            this.generateArguments(invocation);
        }
    }

    @Override
    public void visit(ClassInstanceCreation cic) {
        this.print("new ");
        Signature className = Project.getSingleton().getSignature(((ObjectType)cic.getTypeBinding()).getClassName());
        this.print(DragomeJavaScriptGenerator.normalizeExpression(className));
        this.print("(");
        if (cic.getMethodBinding() != null) {
            this.print(", ");
            this.generateArguments(cic);
        }
        this.print(")");
    }

    @Override
    public void visit(ArrayInitializer ai) {
        this.print("[");
        for (int i = 0; i < ai.getExpressions().size(); ++i) {
            this.print(i == 0 ? "" : ", ");
            ((ASTNode)ai.getExpressions().get(i)).visit(this);
        }
        this.print("]");
    }

    @Override
    public void visit(ArrayCreation ac) {
        if (ac.getDimensions().size() <= 0) {
            throw new RuntimeException("Expected array dimension > 0, but was" + ac.getDimensions().size());
        }
        if (ac.getInitializer() != null) {
            ac.getInitializer().visit(this);
        } else {
            this.print("dragomeJs.newArray('");
            Signature signature = Project.getSingleton().getArraySignature(ac.getTypeBinding());
            this.print(signature.toString());
            this.print("', [");
            for (int i = 0; i < ac.getDimensions().size(); ++i) {
                this.print(i == 0 ? "" : ", ");
                ac.getDimensions().get(i).visit(this);
            }
            this.print("])");
        }
    }

    @Override
    public void visit(ArrayAccess aa) {
        aa.getArray().visit(this);
        this.print("[");
        aa.getIndex().visit(this);
        this.print("]");
    }

    private String normalizeAccess(FieldAccess fr) {
        String prefix = "$$$";
        if (fr.getFirstChild() instanceof FieldRead) {
            FieldRead fieldRead = (FieldRead)fr.getFirstChild();
        }
        if ("length".equals(fr.getName())) {
            if (!fr.getTypeBinding().equals((Object)Type.UNKNOWN)) {
                System.out.println("sdgsdg");
            }
            prefix = "";
        }
        String name = prefix + fr.getName();
        if (!fr.getName().matches("\\w*")) {
            return "[\"" + name + "\"]";
        }
        return "." + name;
    }

    @Override
    public void visit(VariableDeclaration decl) {
        String name = this.escapeVariable(decl.getName());
        if (decl.getLocation() == VariableDeclaration.LOCAL_PARAMETER) {
            this.print(name);
            return;
        }
        if (decl.getLocation() == VariableDeclaration.NON_LOCAL) {
            FieldUnit fieldUnit = this.project.getOrCreateFieldUnit(this.typeDecl.getType(), name);
            if (Modifier.isStatic(decl.getModifiers())) {
                this.print("#static-member#");
            }
            this.print("$$$");
            this.print(name);
            this.initializeField(decl, ":");
            fieldUnit.setData(this.reset());
            return;
        }
        if (decl.getLocation() != VariableDeclaration.LOCAL) {
            throw new RuntimeException("Declaration must be local");
        }
        this.print(name);
        this.initializeField(decl, "=");
    }

    private void initializeField(VariableDeclaration decl, String assignmentOperator) {
        if (!decl.isInitialized()) {
            return;
        }
        this.print(" " + assignmentOperator + " ");
        switch (decl.getType().getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.print("0");
                break;
            }
            case 4: {
                this.print("false");
                break;
            }
            default: {
                this.print("null");
            }
        }
    }

    @Override
    public void visit(VariableBinding reference) {
        if (reference.getVariableDeclaration().getLocation() == VariableDeclaration.LOCAL_PARAMETER && this.hasToEscapeVariable(reference.getName())) {
            this.print("_");
        }
        this.print(this.escapeVariable(reference.getName()));
    }

    private boolean hasToEscapeVariable(String name) {
        return "function".equals(name) || "default".equals(name);
    }

    private String escapeVariable(String name) {
        if ("var".equals(name)) {
            return "_var";
        }
        if ("enum".equals(name)) {
            return "_enum";
        }
        if ("this".equals(name)) {
            return "_this";
        }
        return name;
    }

    @Override
    public void visit(ThisExpression reference) {
        this.consume(reference);
        this.print("this");
    }

    @Override
    public void visit(FieldAccess fr) {
        Expression expression = fr.getExpression();
        if (expression == null) {
            String normalizeExpression = DragomeJavaScriptGenerator.normalizeExpression(Project.getSingleton().getSignature(fr.getType().getClassName()));
            boolean sameType = this.currentMethodDeclaration.getMethodBinding().getDeclaringClass().equals((Object)fr.getType());
            String clinitExpression = DragomeJavaScriptGenerator.normalizeExpression(new Signature("<clinit>()void", 0));
            this.print("" + normalizeExpression + "." + clinitExpression + "()");
        } else if (expression instanceof ThisExpression) {
            ((ASTNode)expression).visit(this);
        } else {
            ((ASTNode)expression).visit(this);
        }
        this.print(this.normalizeAccess(fr));
    }

    @Override
    public void visit(BreakStatement stmt) {
        this.print("break");
        if (stmt.getLabel() != null) {
            this.print(" " + stmt.getLabel());
        }
    }

    @Override
    public void visit(ContinueStatement stmt) {
        this.print("continue");
        if (stmt.getLabel() != null) {
            this.print(" " + stmt.getLabel());
        }
    }

    @Override
    public void visit(CastExpression cast) {
        if (cast.getTypeBinding() != Type.VOID && DragomeJsCompiler.compiler.compilerConfiguration.isCheckingCast()) {
            this.print("dragomeJs.checkCast(");
            cast.getExpression().visit(this);
            String string = cast.getTypeBinding().toString();
            String normalizeExpression = DragomeJavaScriptGenerator.normalizeExpression(string);
            if (string.startsWith("[L")) {
                normalizeExpression = "'" + string + "'";
            }
            this.print("," + normalizeExpression + ")");
        } else {
            cast.getExpression().visit(this);
        }
    }

    @Override
    public void visit(BooleanLiteral be) {
        this.print(Boolean.toString(be.getValue()));
    }

    @Override
    public void visit(ThrowStatement node) {
        this.print("throw dragomeJs.nullSaveException(");
        node.getExpression().visit(this);
        this.print(")");
    }

    @Override
    public void visit(Name node) {
        this.print(node.getIdentifier());
    }

    @Override
    public void visit(PrimitiveCast node) {
        Type type = node.getTypeBinding();
        if (type.equals((Object)Type.LONG)) {
            this.print("dragomeJs.trunc(");
            node.getExpression().visit(this);
            this.print(")");
        } else if (type.equals((Object)Type.INT)) {
            this.print("dragomeJs.narrow(");
            node.getExpression().visit(this);
            this.print(", 0xffffffff)");
        } else if (type.equals((Object)Type.SHORT)) {
            this.print("dragomeJs.narrow(");
            node.getExpression().visit(this);
            this.print(", 0xffff)");
        } else if (type.equals((Object)Type.BYTE)) {
            this.print("dragomeJs.narrow(");
            node.getExpression().visit(this);
            this.print(", 0xff)");
        } else {
            node.getExpression().visit(this);
        }
    }

    static {
        parametersSignatures = new LinkedHashMap<String, Integer>();
    }
}

