/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.generators;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JavaScriptCompressor {
    private static final int DEFAULT_CODE = 0;
    private static final int LINECOMMENT = 1;
    private static final int MULTILINECOMMENT = 2;
    private static final int STRING = 3;

    public String compress(InputStream input) throws FileNotFoundException, IOException {
        int i;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuilder builder = new StringBuilder();
        int state = 0;
        char lastC = '\u0000';
        while ((i = reader.read()) != -1) {
            char c = (char)i;
            if (state == 1) {
                if (c == '\n') {
                    state = 0;
                    builder.append(c);
                }
            } else if (state == 2) {
                if (c == '/' && lastC == '*') {
                    state = 0;
                }
            } else if (state == 3) {
                if (c == '\"') {
                    state = 0;
                }
                builder.append(c);
            } else if (c == '/' && lastC == c) {
                state = 1;
                builder.deleteCharAt(builder.length() - 1);
            } else if (c == '*' && lastC == '/') {
                state = 2;
                builder.deleteCharAt(builder.length() - 1);
            } else if (c == '\"') {
                state = 3;
                builder.append(c);
            } else {
                int length = builder.length();
                if (length <= 0 || !Character.isWhitespace(c) || !Character.isWhitespace(builder.charAt(length - 1))) {
                    builder.append(c);
                }
            }
            lastC = c;
        }
        reader.close();
        builder.trimToSize();
        return builder.toString();
    }
}

