/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.ASTNodeStack;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanExpression;
import com.dragome.compiler.ast.InfixExpression;
import com.dragome.compiler.ast.TryStatement;
import com.dragome.compiler.graph.ConditionalEdge;
import com.dragome.compiler.graph.DominatorTree;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.Graph;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.TryHeaderNode;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ControlFlowGraph
extends Graph {
    private Map<Integer, Node> nodesByPc = new LinkedHashMap<Integer, Node>();
    private Node sourceNode;
    private List tryStatements;
    public static int problemCounter = 0;

    public ControlFlowGraph(List theTryStatements) {
        this.tryStatements = theTryStatements;
    }

    private TryStatement selectTryStatement(Node node) {
        int pc = node.getInitialPc();
        for (int i = 0; i < this.tryStatements.size(); ++i) {
            TryStatement tryStmt = (TryStatement)this.tryStatements.get(i);
            Block block = tryStmt.getTryBlock();
            if (pc < block.getBeginIndex() || pc > block.getEndIndex()) continue;
            return tryStmt;
        }
        return null;
    }

    public Node createNode(int pc) {
        return this.createNode(pc, Node.class);
    }

    public Node getOrCreateNode(int pc) {
        Node node = this.getNode(pc);
        if (node == null) {
            node = this.createNode(pc, Node.class);
        }
        return node;
    }

    public Node createNode(int pc, Class nodeClass) {
        if (pc < 0) {
            throw new RuntimeException("Program counter may not be negative");
        }
        Node node = super.createNode(nodeClass);
        node.setInitialPc(pc);
        if (this.nodesByPc.put(node.getInitialPc(), node) != null) {
            throw new RuntimeException("Node already exists: " + node);
        }
        if (pc == 0) {
            this.sourceNode = node;
        }
        return node;
    }

    public Node getNodeAt(int pc) {
        int minPcDelta = Integer.MAX_VALUE;
        Node node = null;
        for (Node n : this.getNodes()) {
            if (n.getInitialPc() > pc || pc - n.getInitialPc() >= minPcDelta) continue;
            minPcDelta = pc - n.getInitialPc();
            node = n;
            if (minPcDelta != 0) continue;
            return node;
        }
        if (node == null) {
            throw new RuntimeException("No node at pc " + pc);
        }
        return node;
    }

    public Node split(Node node, int pc) {
        if (node.block.getBeginIndex() >= pc) {
            throw new RuntimeException("Block must contain program counter");
        }
        Node nodeB = this.createNode(pc);
        for (Edge edge : new ArrayList<Edge>(node.getOutEdges())) {
            edge.reroot(nodeB);
        }
        this.addEdge(node, nodeB);
        for (ASTNode astNode = node.block.getFirstChild(); astNode != null; astNode = astNode.getNextSibling()) {
            if (astNode.getBeginIndex() < pc) continue;
            node.setCurrentPc(astNode.getBeginIndex() - 1);
            nodeB.block.appendChildren(astNode, node.block.getLastChild());
            break;
        }
        nodeB.stack = node.stack;
        node.stack = new ASTNodeStack();
        return nodeB;
    }

    public Node[] getOrSplitNodeAt(Node currentNode, int pc) {
        Node targetNode = this.getNodeAt(pc);
        if (targetNode.getInitialPc() != pc) {
            Node nodeB = this.split(targetNode, pc);
            if (targetNode == currentNode) {
                currentNode = nodeB;
            }
            targetNode = nodeB;
        }
        return new Node[]{currentNode, targetNode};
    }

    private void processTrys() {
        for (int i = 0; i < this.tryStatements.size(); ++i) {
            TryStatement stmt = (TryStatement)this.tryStatements.get(i);
            TryHeaderNode header = stmt.header;
            Node tryNode = header.getTryBody();
            if (tryNode == this.sourceNode) {
                this.sourceNode = header;
            }
            for (Edge edge : new ArrayList<Edge>(tryNode.getInEdges())) {
                int pc = edge.source.getInitialPc();
                if (pc >= stmt.getBeginIndex() && pc <= stmt.getEndIndex() || edge.source == header) continue;
                edge.redirect(header);
            }
        }
    }

    private void processTrys2() {
        for (Node node : this.nodesByPc.values()) {
            TryStatement sourceTry = this.selectTryStatement(node);
            if (sourceTry == null) continue;
            for (Edge edge : node.getOutEdges()) {
                TryStatement targetTry;
                if (edge.target.getInEdges().size() != 1 || (targetTry = this.selectTryStatement(edge.target)) != null && targetTry == sourceTry) continue;
                edge.reroot(sourceTry.header);
            }
        }
    }

    private void processTrys1() {
        for (int i = 0; i < this.tryStatements.size(); ++i) {
            TryStatement stmt = (TryStatement)this.tryStatements.get(i);
            TryHeaderNode header = stmt.header;
            Node finallyNode = header.getFinallyNode();
            if (finallyNode == null) continue;
            for (Node node : finallyNode.jsrCallers) {
                if (node.getInitialPc() <= finallyNode.getInitialPc()) continue;
                this.removeInEdges(node);
                this.addEdge(header, node);
                node.setDomParent(header);
            }
        }
    }

    public Node getSource() {
        return this.sourceNode;
    }

    public Node getNode(int pc) {
        return this.nodesByPc.get(pc);
    }

    private void markGlobalTargets(Node predecessor) {
        for (Edge edge : predecessor.getOutEdges()) {
            Node target = edge.target;
            if (target.getDomParent() == predecessor || !predecessor.isBranch()) continue;
            Node node = this.createNode(Node.class);
            edge.redirect(node);
            node.setDomParent(predecessor);
            Edge edge2 = this.addEdge(node, target);
        }
    }

    void visitToMark(Node node) {
        for (Node child : new ArrayList<Node>(node.getDomChildren())) {
            this.visitToMark(child);
        }
        this.markGlobalTargets(node);
    }

    void visit(Node node) {
        Transformation t;
        for (Node child : new ArrayList<Node>(node.getDomChildren())) {
            this.visit(child);
        }
        while ((t = Transformation.select(this, node)) != null) {
            node = t.apply();
            this.dump("After transformation");
        }
        if (node.getDomChildren().size() > 0) {
            throw new RuntimeException("Could not reduce graph at " + node);
        }
    }

    @Override
    public void replaceNode(Node node, Node newNode) {
        super.replaceNode(node, newNode);
        if (newNode != null) {
            this.nodesByPc.put(node.getInitialPc(), newNode);
        } else {
            this.nodesByPc.remove(node.getInitialPc());
        }
        if (node == this.sourceNode) {
            if (newNode == null) {
                throw new RuntimeException("Cannot remove source node " + this.sourceNode);
            }
            this.sourceNode = newNode;
        }
    }

    public Block reduce() {
        this.processTrys();
        this.processTrys2();
        this.dump("Before Shortcuts");
        this.processShortcuts();
        DominatorTree builder = new DominatorTree(this);
        builder.build();
        this.processTrys1();
        this.visitToMark(this.getSource());
        this.dump("Begin reduce");
        this.visit(this.getSource());
        if (this.size() != 1) {
            // empty if block
        }
        Block block = new Block();
        this.rollOut(this.getSource(), block);
        return block;
    }

    boolean performAndOrShortcut(Node a, Node b) {
        ConditionalEdge bToC;
        ConditionalEdge aToC;
        if (b.getInEdges().size() != 1) {
            return false;
        }
        if (b.block.getChildCount() > 0) {
            return false;
        }
        boolean isOR = true;
        while (true) {
            aToC = a.getConditionalEdge(isOR);
            bToC = b.getConditionalEdge(isOR);
            if (bToC.target == aToC.target) break;
            if (!isOR) {
                return false;
            }
            isOR = false;
        }
        if (aToC.target.getInEdges().size() != 2) {
            return false;
        }
        ConditionalEdge bToD = b.getConditionalEdge(!isOR);
        ConditionalEdge aToB = a.getConditionalEdge(!isOR);
        aToB.redirect(bToD.target);
        this.removeEdge(bToC);
        this.removeEdge(bToD);
        this.removeNode(b);
        InfixExpression infix = new InfixExpression(isOR ? InfixExpression.Operator.CONDITIONAL_OR : InfixExpression.Operator.CONDITIONAL_AND);
        infix.setOperands(aToC.getBooleanExpression().getExpression(), bToC.getBooleanExpression().getExpression());
        BooleanExpression be = new BooleanExpression(infix);
        aToC.setBooleanExpression(be);
        aToB.setBooleanExpression(be);
        this.logger.debug("Created shortcut and removed " + b);
        return true;
    }

    public void processShortcuts() {
        LinkedHashSet<Node> branches = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            if (!node.isBranch()) continue;
            branches.add(node);
        }
        block1: while (true) {
            block2: for (Node branch : branches) {
                for (Node node : branch.succs()) {
                    if (!node.isBranch() || !this.performAndOrShortcut(branch, node)) continue;
                    branches.remove(node);
                    continue block1;
                    continue block2;
                }
            }
            break;
        }
    }
}

