/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.graph.ControlFlowGraph;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.utils.Log;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;

public class DominatorTree {
    private ControlFlowGraph graph;

    public DominatorTree(ControlFlowGraph theGraph) {
        this.graph = theGraph;
    }

    private void visit(Node node, Collection<Node> visited) {
        node.setPreOrderIndex(visited.size());
        visited.add(node);
        for (Node succ : node.succs()) {
            if (visited.contains(succ)) continue;
            this.visit(succ, visited);
        }
    }

    public void build() {
        int i;
        boolean changed;
        ArrayList<Node> preOrder = new ArrayList<Node>();
        this.visit(this.graph.getSource(), preOrder);
        for (Node node : new ArrayList<Node>(this.graph.getNodes())) {
            if (!preOrder.contains(node)) {
                Log.getLogger().warn("Unreachable code detected and removed");
                this.graph.removeInEdges(node);
                this.graph.removeOutEdges(node);
                this.graph.removeNode(node);
                continue;
            }
            if (node.getPreOrderIndex() != -1) continue;
            throw new RuntimeException("Pre-order not set for " + node);
        }
        int size = this.graph.size();
        LinkedHashMap snkPreds = new LinkedHashMap();
        int rootIndex = this.graph.getSource().getPreOrderIndex();
        if (rootIndex < 0 || rootIndex >= size) {
            throw new RuntimeException("Root index out of range");
        }
        BitSet[] domMatrix = new BitSet[size];
        for (int i2 = 0; i2 < size; ++i2) {
            BitSet domVector = new BitSet(size);
            if (i2 == rootIndex) {
                domVector.set(rootIndex);
            } else {
                domVector.set(0, size);
            }
            domMatrix[i2] = domVector;
        }
        do {
            changed = false;
            for (Node node : preOrder) {
                int j;
                i = node.getPreOrderIndex();
                if (i < 0 || i >= size) {
                    throw new RuntimeException("Unreachable node " + node);
                }
                if (i == rootIndex) continue;
                BitSet oldSet = domMatrix[i];
                BitSet domVector = new BitSet(size);
                domVector.or(oldSet);
                Collection<Node> preds = node.preds();
                for (Node pred : preds) {
                    j = pred.getPreOrderIndex();
                    if (j == -1) {
                        throw new RuntimeException("Unreachable node " + pred);
                    }
                    domVector.and(domMatrix[j]);
                }
                preds = (Collection)snkPreds.get(node);
                if (preds != null) {
                    for (Node pred : preds) {
                        j = pred.getPreOrderIndex();
                        domVector.and(domMatrix[j]);
                    }
                }
                domVector.set(i);
                if (domVector.equals(oldSet)) continue;
                changed = true;
                domMatrix[i] = domVector;
            }
        } while (changed);
        for (Node node : this.graph.getNodes()) {
            node.setDomParent(null);
            node.getDomChildren().clear();
        }
        for (Node node : this.graph.getNodes()) {
            i = node.getPreOrderIndex();
            if (i < 0 || i >= size) {
                throw new RuntimeException("Unreachable node " + node);
            }
            if (i == rootIndex) continue;
            BitSet domVector = domMatrix[i];
            BitSet idom = new BitSet(size);
            idom.or(domVector);
            idom.clear(i);
            for (int j = 0; j < size; ++j) {
                if (i == j || !domVector.get(j)) continue;
                BitSet b = new BitSet(size);
                b.or(domMatrix[j]);
                b.flip(0, size);
                b.set(j);
                idom.and(b);
            }
            Node parent = null;
            for (int j = 0; j < size; ++j) {
                if (!idom.get(j)) continue;
                Node p = preOrder.get(j);
                if (parent != null) {
                    throw new RuntimeException(node + " has more than one immediate dominator: " + parent + " and " + p);
                }
                parent = p;
            }
            if (parent == null) {
                throw new RuntimeException(node + " has 0 immediate dominators");
            }
            node.setDomParent(parent);
        }
    }
}

