/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanExpression;
import com.dragome.compiler.ast.BreakStatement;
import com.dragome.compiler.ast.IfStatement;
import com.dragome.compiler.graph.ConditionalEdge;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.SwitchEdge;
import com.dragome.compiler.utils.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class Graph {
    private Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    int nodeIdSequence = 0;
    Log logger = Log.getLogger();

    public Node getNodeById(String id) {
        return this.nodes.get(id);
    }

    public Node createNode(Class nodeClass) {
        return this.createNode(nodeClass, Integer.toString(this.nodeIdSequence++, 26));
    }

    public Node createNode(Class nodeClass, String id) {
        Node node;
        try {
            Constructor constructor = nodeClass.getConstructor(Graph.class);
            node = (Node)constructor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        node.id = id;
        this.nodes.put(id, node);
        return node;
    }

    public boolean isContained(Set nodesA, Node[] nodesB) {
        LinkedHashSet<Node> foo = new LinkedHashSet<Node>(Arrays.asList(nodesB));
        return foo.containsAll(nodesA);
    }

    public void replaceAsTarget(Node oldTarget, Node newTarget) {
        for (Edge edge : new ArrayList<Edge>(oldTarget.getInEdges())) {
            edge.redirect(newTarget);
        }
    }

    public Edge removeEdge(Node source, Node target) {
        Edge edge = this.getEdge(source, target);
        return this.removeEdge(edge);
    }

    public Edge removeEdge(Edge edge) {
        edge.source.getOutEdges().remove(edge);
        edge.target.getInEdges().remove(edge);
        return edge;
    }

    public String getEdgeId(Node source, Node target) {
        return source.getId() + "->" + target.getId();
    }

    public void addIfElseEdge(Node source, Node ifTarget, Node elseTarget, BooleanExpression be) {
        ConditionalEdge ifEdge = (ConditionalEdge)this.addEdge(source, ifTarget, ConditionalEdge.class);
        ifEdge.setBooleanExpression(be);
        ConditionalEdge elseEdge = (ConditionalEdge)this.addEdge(source, elseTarget, ConditionalEdge.class);
        elseEdge.setBooleanExpression(be);
        elseEdge.setNegate(true);
    }

    public Edge addEdge(Node source, Node target) {
        return this.addEdge(source, target, Edge.class);
    }

    public Edge addEdge(Node source, Node target, Class clazz) {
        Edge edge = this.getEdge(source, target);
        if (edge != null) {
            throw new RuntimeException("Edge already exists");
        }
        if (clazz.equals(Edge.class)) {
            edge = new Edge(this, source, target);
        } else if (clazz.equals(SwitchEdge.class)) {
            edge = new SwitchEdge(this, source, target);
        } else if (clazz.equals(ConditionalEdge.class)) {
            edge = new ConditionalEdge(this, source, target);
        } else {
            throw new RuntimeException("Illegal edge class " + clazz);
        }
        source.addEdge(edge);
        if (source != target) {
            target.addEdge(edge);
        }
        return edge;
    }

    public Edge getEdge(Node source, Node target) {
        for (Edge edge : source.getOutEdges()) {
            if (edge.target != target) continue;
            return edge;
        }
        return null;
    }

    public void removeNode(Node node) {
        this.replaceNode(node, null);
    }

    public Set<Edge> removeOutEdges(Node node) {
        LinkedHashSet<Edge> outEdges = new LinkedHashSet<Edge>(node.outEdges);
        for (Edge edge : outEdges) {
            this.removeEdge(edge);
        }
        return outEdges;
    }

    public Set removeInEdges(Node node) {
        LinkedHashSet<Edge> inEdges = new LinkedHashSet<Edge>(node.inEdges);
        for (Edge edge : inEdges) {
            this.removeEdge(edge);
        }
        return inEdges;
    }

    public Set removeSelfEdges(Node node) {
        LinkedHashSet<Edge> selfEdges = new LinkedHashSet<Edge>();
        for (Edge edge : new LinkedHashSet<Edge>(node.outEdges)) {
            if (edge.target != node) continue;
            this.removeEdge(edge);
            selfEdges.add(edge);
        }
        return selfEdges;
    }

    public void rerootGlobalOutEdges(Node node, Node newSource) {
        Edge[] edges = node.getOutEdgesArray();
        for (int i = 0; i < edges.length; ++i) {
            Edge edge = edges[i];
            if (!edge.isGlobal()) continue;
            edge.reroot(newSource);
        }
    }

    public void rerootOutEdges(Node node, Node newSource, boolean localToGlobal) {
        Edge[] edges = node.getOutEdgesArray();
        for (int i = 0; i < edges.length; ++i) {
            Edge edge = edges[i];
            edge.reroot(newSource);
            if (!localToGlobal || edge.isGlobal()) continue;
            edge.setOrgSource(node);
        }
    }

    public void replaceNode(Node oldNode, Node newNode) {
        this.nodes.remove(oldNode.getId());
        if (newNode != null) {
            this.replaceAsTarget(oldNode, newNode);
            this.rerootOutEdges(oldNode, newNode, true);
            newNode.setDomParent(oldNode.getDomParent());
            for (Node child : new ArrayList<Node>(oldNode.getDomChildren())) {
                child.setDomParent(newNode);
            }
        }
        if (oldNode.inEdges.size() > 0 || oldNode.outEdges.size() > 0) {
            throw new RuntimeException("Cannot replace node with edges");
        }
        oldNode.setDomParent(null);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public int size() {
        return this.getNodes().size();
    }

    public Block reduceDumb() {
        Block block = new Block();
        for (Node node : this.getNodes()) {
            block.appendChild(node.block);
            if (node.isBranch()) {
                IfStatement ifStmt = new IfStatement();
                ConditionalEdge cEdge = node.getConditionalEdge(true);
                ifStmt.setExpression(cEdge.getBooleanExpression().getExpression());
                ifStmt.setIfBlock(new Block());
                Block targetBlock = cEdge.target.block;
                ifStmt.getIfBlock().appendChild(new BreakStatement(targetBlock));
                ifStmt.setElseBlock(new Block());
                targetBlock = node.getConditionalEdge((boolean)false).target.block;
                ifStmt.getElseBlock().appendChild(new BreakStatement(targetBlock));
                block.appendChild(ifStmt);
                continue;
            }
            for (Edge e : node.getOutEdges()) {
                BreakStatement bStmt = new BreakStatement(e.target.block);
                node.block.appendChild(bStmt);
            }
        }
        return block;
    }

    boolean isTarget(Node n, Set edgeSet) {
        for (Edge e : edgeSet) {
            if (n != e.target) continue;
            return true;
        }
        return false;
    }

    public void rollOut(Node node, Block targetBlock) {
        if (node.trans != null) {
            node.trans.rollOut(targetBlock);
        } else {
            targetBlock.appendChildren(node.block);
        }
    }

    public void dump(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg + " ...\n");
        for (Node node : this.getNodes()) {
            sb.append(node.describe() + "\n");
        }
        sb.append("... " + msg);
        this.logger.debug(sb.toString());
    }
}

