/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.ast.ASTNodeStack;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.IfStatement;
import com.dragome.compiler.graph.ConditionalEdge;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.Graph;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class Node {
    public static int NON_HEADER = 0;
    public static int REDUCIBLE = 1;
    public static int IRREDUCIBLE = 2;
    String id;
    Set<Edge> inEdges = new LinkedHashSet<Edge>();
    Set<Edge> outEdges = new LinkedHashSet<Edge>();
    Graph graph;
    private int currentPc = -1;
    private int initialPc = -1;
    public ASTNodeStack stack = new ASTNodeStack();
    public Block block = new Block();
    public boolean closed = false;
    protected int preOrderIndex = -1;
    private Node domParent;
    private Set<Node> domChildren = new LinkedHashSet<Node>();
    IfStatement ifStmt;
    public Expression switchExpression;
    public Transformation trans;
    public Collection<Node> jsrCallers = new LinkedHashSet<Node>();
    public boolean isSwitchHeader = false;

    public Node(Graph theGraph, int pc) {
        this(theGraph);
        this.setInitialPc(pc);
    }

    public Node(Graph theGraph) {
        this.graph = theGraph;
    }

    public int getComplexity() {
        Node node = this;
        int complexity = 0;
        while (node.trans != null) {
            ++complexity;
            node = node.trans.header;
        }
        return complexity;
    }

    public int getCurrentPc() {
        return this.currentPc;
    }

    public void setCurrentPc(int pc) {
        this.currentPc = pc;
    }

    public void close() {
        this.closed = true;
    }

    public void addEdge(Edge e) {
        if (e.source == this && !this.outEdges.add(e)) {
            throw new RuntimeException("\n" + this + "\nalready bound to " + e);
        }
        if (e.target == this && !this.inEdges.add(e)) {
            throw new RuntimeException("" + this + " already bound to " + e);
        }
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.replaceFirst(".*\\.", "");
        s = s + " " + this.id + "[" + this.initialPc + ", " + this.currentPc + "]";
        if (this.domParent != null) {
            s = s + " dominated by " + this.domParent.id;
        }
        if (this.isLoopHeader()) {
            s = s + " LH";
        }
        return s;
    }

    public String describe() {
        String s = this.toString();
        for (Edge e : this.outEdges) {
            s = s + "\n\t" + e;
        }
        return s;
    }

    public Set<Edge> getInEdges() {
        return this.inEdges;
    }

    public Edge getSelfEdge() {
        for (Edge edge : this.inEdges) {
            if (edge.source != this) continue;
            return edge;
        }
        return null;
    }

    public Set<Edge> getOutEdges() {
        return this.outEdges;
    }

    public Edge[] getOutEdgesArray() {
        return this.outEdges.toArray(new Edge[this.outEdges.size()]);
    }

    public Edge[] getInEdgesArray() {
        return this.inEdges.toArray(new Edge[this.inEdges.size()]);
    }

    public int getPreOrderIndex() {
        return this.preOrderIndex;
    }

    public void setPreOrderIndex(int thePreOrderIndex) {
        this.preOrderIndex = thePreOrderIndex;
    }

    public Set<Node> succs() {
        LinkedHashSet<Node> list = new LinkedHashSet<Node>();
        Edge[] edges = this.getOutEdgesArray();
        for (int i = edges.length - 1; i >= 0; --i) {
            list.add(edges[i].target);
        }
        return list;
    }

    public Set<Node> preds() {
        LinkedHashSet<Node> list = new LinkedHashSet<Node>();
        for (Edge e : this.inEdges) {
            list.add(e.source);
        }
        return list;
    }

    public Node getPred() {
        int count = this.inEdges.size();
        if (count != 1) {
            throw new RuntimeException("Requested unique predecessor, found " + count);
        }
        return this.inEdges.iterator().next().source;
    }

    public Node getSucc() {
        return this.getOutEdge().target;
    }

    public Edge getLocalOutEdgeOrNull() {
        Edge outEdge = null;
        for (Edge edge : this.outEdges) {
            if (outEdge != null) {
                new RuntimeException("Found multiple local out-edges");
            }
            outEdge = edge;
        }
        return outEdge;
    }

    public Edge getOutEdge() {
        int count = this.outEdges.size();
        if (count != 1) {
            throw new RuntimeException("Requested unique successor, found " + count);
        }
        return this.outEdges.iterator().next();
    }

    public boolean isDomAncestor(Node node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getDomParent();
        }
        return false;
    }

    public Set<Node> getDomChildren() {
        return this.domChildren;
    }

    public Node getDomChild() {
        if (this.domChildren.size() != 1) {
            throw new RuntimeException("Node must have single child");
        }
        return this.getDomChildren().iterator().next();
    }

    public Node getDomParent() {
        return this.domParent;
    }

    public void setDomParent(Node newDomParent) {
        if (this.domParent != null) {
            this.domParent.domChildren.remove(this);
        }
        this.domParent = newDomParent;
        if (this.domParent != null) {
            this.domParent.domChildren.add(this);
        }
    }

    public boolean isBranch() {
        Edge[] edges = this.getOutEdgesArray();
        if (edges.length != 2) {
            return false;
        }
        if (edges[0] instanceof ConditionalEdge && edges[1] instanceof ConditionalEdge) {
            return true;
        }
        if (edges[0] instanceof ConditionalEdge || edges[1] instanceof ConditionalEdge) {
            throw new RuntimeException("Node must not have mixed edges");
        }
        return false;
    }

    public ConditionalEdge getConditionalEdge(boolean trueFalse) {
        if (!this.isBranch()) {
            throw new RuntimeException("Node must be a branch");
        }
        Iterator<Edge> iter = this.outEdges.iterator();
        Edge edge = iter.next();
        if (!trueFalse) {
            edge = iter.next();
        }
        return (ConditionalEdge)edge;
    }

    public String getId() {
        return this.id;
    }

    public int getInitialPc() {
        return this.initialPc;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setInitialPc(int theInitialPc) {
        this.initialPc = theInitialPc;
        this.currentPc = theInitialPc;
    }

    public boolean isLoopHeader() {
        for (Edge edge : this.inEdges) {
            if (!edge.isBackEdge()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelfEdges() {
        for (Edge edge : this.outEdges) {
            if (edge.target != this) continue;
            return true;
        }
        return false;
    }

    public class Reference {
        public Node source;
        public boolean isBackward = false;
    }
}

