/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.ast.TryStatement;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.EdgeType;
import com.dragome.compiler.graph.Graph;
import com.dragome.compiler.graph.Node;
import java.util.ArrayList;
import java.util.List;

public class TryHeaderNode
extends Node {
    public TryStatement tryStmt;

    public TryHeaderNode(Graph theGraph) {
        super(theGraph);
    }

    public void setTryBody(Node theTryBody) {
        Edge edge = this.graph.addEdge(this, theTryBody);
        edge.type = EdgeType.TRYBODY;
    }

    public void setFinallyNode(Node theFinallyNode) {
        Edge edge = this.graph.addEdge(this, theFinallyNode);
        edge.type = EdgeType.FINALLY;
    }

    public void addCatchNode(Node node) {
        Edge edge = this.graph.addEdge(this, node);
        edge.type = EdgeType.CATCH;
    }

    public Node getSuccessor() {
        for (Edge edge : this.outEdges) {
            if (edge.type != null) continue;
            return edge.target;
        }
        return null;
    }

    public Node getTryBody() {
        for (Edge edge : this.outEdges) {
            if (edge.type != EdgeType.TRYBODY) continue;
            return edge.target;
        }
        throw new RuntimeException();
    }

    public Node getFinallyNode() {
        for (Edge edge : this.outEdges) {
            if (edge.type != EdgeType.FINALLY) continue;
            return edge.target;
        }
        return null;
    }

    public List<Node> getCatchNodes() {
        ArrayList<Node> catchNodes = new ArrayList<Node>();
        for (Edge edge : this.outEdges) {
            if (edge.type != EdgeType.CATCH) continue;
            catchNodes.add(edge.target);
        }
        return catchNodes;
    }

    public TryStatement getTryStatement() {
        return this.tryStmt;
    }
}

