/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph.transformation;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.NumberLiteral;
import com.dragome.compiler.ast.SwitchCase;
import com.dragome.compiler.ast.SwitchStatement;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.SwitchEdge;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.ArrayList;
import java.util.List;

public class Switch
extends Transformation {
    private List<Node> caseGroups = new ArrayList<Node>();
    private List<List<NumberLiteral>> caseGroupExpressions = new ArrayList<List<NumberLiteral>>();

    @Override
    public boolean applies_() {
        return this.header.isSwitchHeader;
    }

    private void removeFallThroughEdgesl() {
        Edge prevPotentialFallThroughEdge = null;
        for (Edge e : this.header.getOutEdges()) {
            if (!(e instanceof SwitchEdge)) continue;
            SwitchEdge edge = (SwitchEdge)e;
            Node caseGroup = edge.target;
            if (prevPotentialFallThroughEdge != null && prevPotentialFallThroughEdge.target == caseGroup) {
                this.graph.removeEdge(prevPotentialFallThroughEdge);
            }
            prevPotentialFallThroughEdge = caseGroup.getLocalOutEdgeOrNull();
        }
    }

    @Override
    void apply_() {
        this.removeFallThroughEdgesl();
        for (Edge e : new ArrayList<Edge>(this.header.getOutEdges())) {
            if (!(e instanceof SwitchEdge)) continue;
            SwitchEdge edge = (SwitchEdge)e;
            Node caseGroup = edge.target;
            this.caseGroups.add(caseGroup);
            this.caseGroupExpressions.add(edge.expressions);
            this.graph.rerootOutEdges(caseGroup, this.newNode, true);
            this.graph.removeOutEdges(caseGroup);
            this.graph.removeInEdges(caseGroup);
            this.graph.removeNode(caseGroup);
        }
    }

    @Override
    void rollOut_(Block block) {
        SwitchStatement switchStmt = new SwitchStatement();
        switchStmt.setExpression(this.header.switchExpression);
        for (int i = 0; i < this.caseGroups.size(); ++i) {
            Node scNode = this.caseGroups.get(i);
            SwitchCase switchCase = new SwitchCase(scNode.getInitialPc());
            switchCase.setExpressions(this.caseGroupExpressions.get(i));
            switchStmt.appendChild(switchCase);
            this.graph.rollOut(scNode, switchCase);
        }
        block.appendChild(switchStmt);
    }

    @Override
    public String toString() {
        String s = super.toString() + "(" + this.header;
        for (int i = 0; i < this.caseGroups.size(); ++i) {
            s = s + ", " + this.caseGroups.get(i);
        }
        return s + ")";
    }
}

