/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph.transformation;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanExpression;
import com.dragome.compiler.ast.BreakStatement;
import com.dragome.compiler.ast.ContinueStatement;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.IfStatement;
import com.dragome.compiler.graph.ConditionalEdge;
import com.dragome.compiler.graph.ControlFlowGraph;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.Graph;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.transformation.Loop;
import com.dragome.compiler.graph.transformation.Merge;
import com.dragome.compiler.graph.transformation.Switch;
import com.dragome.compiler.graph.transformation.Try;
import com.dragome.compiler.parser.Optimizer;
import com.dragome.compiler.utils.Log;

public abstract class Transformation {
    static Class[] transformations = new Class[]{Switch.class, Try.class, Loop.class, Merge.class};
    ControlFlowGraph graph;
    public Node header;
    Node newNode;

    public static Transformation select(Graph graph, Node node) {
        for (int i = 0; i < transformations.length; ++i) {
            Transformation t = Transformation.fetch(i);
            if (!t.applies(node)) continue;
            return t;
        }
        return null;
    }

    static Transformation fetch(int index) {
        Transformation t = null;
        try {
            t = (Transformation)transformations[index].newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public Node apply() {
        this.newNode = this.graph.createNode(Node.class);
        this.newNode.setInitialPc(this.header.getInitialPc());
        this.newNode.trans = this;
        this.apply_();
        this.graph.replaceNode(this.header, this.newNode);
        Log.getLogger().debug(this.toString() + " -> " + this.newNode);
        return this.newNode;
    }

    public boolean applies(Node node) {
        this.graph = (ControlFlowGraph)node.getGraph();
        this.header = node;
        return this.applies_();
    }

    abstract boolean applies_();

    abstract void apply_();

    abstract void rollOut_(Block var1);

    public void rollOut(Block block) {
        this.rollOut_(block);
        block.appendChildren(this.newNode.block);
    }

    void produceJump(Edge edge, Block labeledBlock) {
        Block breakBlock;
        Node referer = edge.getOrgSource();
        if (edge instanceof ConditionalEdge) {
            ConditionalEdge condEdge = (ConditionalEdge)edge;
            BooleanExpression condExpr = condEdge.getBooleanExpression();
            Expression expr = Optimizer.simplifyBooleanExpression(condExpr.getExpression(), condEdge.isNegate());
            IfStatement ifStmt = new IfStatement();
            ifStmt.setExpression(expr);
            referer.block.appendChild(ifStmt);
            Block ifBlock = new Block();
            ifStmt.setIfBlock(ifBlock);
            breakBlock = ifBlock;
        } else {
            breakBlock = referer.block;
        }
        if (edge.isBackEdge()) {
            breakBlock.appendChild(new ContinueStatement(labeledBlock));
        } else {
            breakBlock.appendChild(new BreakStatement(labeledBlock));
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

