/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.parser;

import org.apache.bcel.generic.Type;

public class Form {
    public static int CATEGORY1 = 1;
    public static int CATEGORY2 = 2;
    private int index;
    private Value[] ins;
    private Value[] outs;
    private Value[] operands;
    private Type type;

    public Value[] getIns() {
        return this.ins;
    }

    public void setIns(Value[] theIns) {
        this.ins = theIns;
    }

    public Value[] getOperands() {
        return this.operands;
    }

    public void setOperands(Value[] theOperands) {
        this.operands = theOperands;
    }

    public Value[] getOuts() {
        return this.outs;
    }

    public void setOuts(Value[] theOuts) {
        this.outs = theOuts;
        if (theOuts.length != 1) {
            return;
        }
        String s = theOuts[0].type;
        if (s.equals("object")) {
            this.type = Type.OBJECT;
        } else if (s.equals("int")) {
            this.type = Type.INT;
        } else if (s.equals("short")) {
            this.type = Type.SHORT;
        } else if (s.equals("byte")) {
            this.type = Type.SHORT;
        } else if (s.equals("long")) {
            this.type = Type.LONG;
        } else if (s.equals("float")) {
            this.type = Type.FLOAT;
        } else if (s.equals("double")) {
            this.type = Type.DOUBLE;
        } else if (!(s.equals("cat1") || s.equals("returnAddress") || s.equals(""))) {
            throw new RuntimeException("Unhandled type: " + s);
        }
    }

    public int getOpStackDelta() {
        return this.getOuts().length - this.getIns().length;
    }

    public Type getResultType() {
        if (this.type == null) {
            throw new RuntimeException("Result type is not available for " + this);
        }
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int theIndex) {
        this.index = theIndex;
    }

    public static class Value {
        public String type;
        public String name;

        public Value(String theType, String theName) {
            this.type = theType;
            this.name = theName;
        }

        public int getCategory() {
            return this.type.equals("cat2") || this.type.equals("long") || this.type.equals("double") ? CATEGORY2 : CATEGORY1;
        }
    }
}

