/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.parser;

import com.dragome.compiler.ast.ASTNode;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;

public class LineNumberCursor {
    private LineNumber[] lineNumbers = null;
    private int index = 0;
    private int markedLineNumber = -1;
    private int length;

    public LineNumberCursor(Code code) {
        if (code == null) {
            return;
        }
        LineNumberTable table = code.getLineNumberTable();
        if (table == null) {
            return;
        }
        this.lineNumbers = table.getLineNumberTable();
        this.length = this.lineNumbers.length;
        Arrays.sort(this.lineNumbers, new LineNumberComparator());
    }

    public boolean hasLineNumbers() {
        return this.lineNumbers != null;
    }

    public int getLineNumber(ASTNode node) {
        block4: {
            int pc;
            block5: {
                if (!this.hasLineNumbers()) {
                    return -1;
                }
                while (node.getBeginIndex() == Integer.MAX_VALUE && node.getPreviousSibling() != null) {
                    node = node.getPreviousSibling();
                }
                pc = node.getBeginIndex();
                if (pc <= this.lineNumbers[this.index].getStartPC()) break block5;
                while (this.index + 1 != this.length) {
                    ++this.index;
                    if (pc >= this.lineNumbers[this.index].getStartPC()) continue;
                    --this.index;
                    break block4;
                }
                break block4;
            }
            if (pc >= this.lineNumbers[this.index].getStartPC()) break block4;
            while (this.index != 0) {
                --this.index;
                if (pc <= this.lineNumbers[this.index].getStartPC()) continue;
                ++this.index;
                break;
            }
        }
        return this.lineNumbers[this.index].getLineNumber();
    }

    public int getAndMarkLineNumber(ASTNode node) {
        if (!this.hasLineNumbers()) {
            return -1;
        }
        int lineNumber = this.getLineNumber(node);
        if (lineNumber == this.markedLineNumber) {
            return -1;
        }
        this.markedLineNumber = lineNumber;
        return lineNumber;
    }

    private class LineNumberComparator
    implements Comparator<LineNumber> {
        private LineNumberComparator() {
        }

        @Override
        public int compare(LineNumber arg0, LineNumber arg1) {
            return arg0.getStartPC() - arg1.getStartPC();
        }
    }
}

