/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.type;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import java.io.Serializable;

public class Signature
implements Serializable {
    private String signatureString;
    private int id;

    public Signature(String theSignatureString, int theId) {
        this.signatureString = theSignatureString;
        this.id = theId;
    }

    public int hashCode() {
        return this.signatureString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Signature) {
            return this.signatureString.equals(((Signature)obj).signatureString);
        }
        return false;
    }

    public String toString() {
        return this.signatureString;
    }

    public boolean isClass() {
        return this.signatureString.indexOf(35) == -1;
    }

    public boolean isArrayType() {
        return this.isClass() && this.signatureString.startsWith("[");
    }

    public boolean isConstructor() {
        return this.signatureString.startsWith("<init>");
    }

    public boolean isMethod() {
        return !this.isConstructor() && this.signatureString.indexOf(40) != -1;
    }

    public boolean isField() {
        return !this.isClass() && this.signatureString.indexOf(40) == -1;
    }

    public String className() {
        String[] array = this.signatureString.split("#");
        return array[0];
    }

    public String relativeSignature() {
        String[] array = this.signatureString.split("#");
        if (array.length != 2) {
            throw new RuntimeException("Not a method signature: " + this);
        }
        return array[1];
    }

    public Signature relative() {
        return Project.getSingleton().getSignature(this.relativeSignature());
    }

    public int getId() {
        return this.id;
    }

    public String getCommentedId() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getId()));
        if (!DragomeJsCompiler.compiler.isCompression()) {
            sb.append(" /*");
            sb.append(this.toString());
            sb.append("*/");
        }
        return sb.toString();
    }
}

