/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.units;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.generators.DragomeJavaScriptGenerator;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.type.TypeCollector;
import com.dragome.compiler.units.FieldUnit;
import com.dragome.compiler.units.MemberUnit;
import com.dragome.compiler.units.MethodUnit;
import com.dragome.compiler.units.ProcedureUnit;
import com.dragome.compiler.units.Unit;
import com.dragome.compiler.utils.FileObject;
import com.dragome.compiler.utils.Log;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.StringBuilderWriter;

public class ClassUnit
extends Unit {
    public static final String STATIC_MEMBER = "#static-member#";
    static final long serialVersionUID = 1L;
    private long lastCompiled;
    private Map<String, MemberUnit> declaredMembers;
    private ClassUnit superUnit;
    private Collection<ClassUnit> interfaces;
    private Collection<ClassUnit> subUnits;
    public boolean isInterface = false;
    public boolean isConstructorTainted = false;
    public Map<String, String>[] annotations;
    private Project project;
    private transient boolean isResolved = false;
    private transient FileObject classFile;
    private List<ClassUnit> implementors = new ArrayList<ClassUnit>();
    private transient boolean written = false;
    private String generatedJs;
    public static boolean oneWritten = false;
    public static List<MemberUnit> stringInits = new ArrayList<MemberUnit>();
    private List<String> dependencies = new ArrayList<String>();
    private byte[] bytecode;
    private List<String> notReversibleMethods = new ArrayList<String>();
    private String alternativeCompilation;
    public boolean isAbstract = false;
    private Map<String, String> annotationsValues;

    public long getLastModified() {
        return this.getClassFile().getLastModified();
    }

    public List<ClassUnit> getImplementors() {
        return this.implementors;
    }

    public void setImplementors(List<ClassUnit> implementors) {
        this.implementors = implementors;
    }

    public ClassUnit() {
    }

    public ClassUnit(Project theProject, Signature theSignature) {
        this.project = theProject;
        this.interfaces = new LinkedHashSet<ClassUnit>();
        this.declaredMembers = new LinkedHashMap<String, MemberUnit>();
        this.subUnits = new LinkedHashSet<ClassUnit>();
        this.lastCompiled = -1L;
        this.setSignature(theSignature);
    }

    public void clear() {
        this.lastCompiled = -1L;
        this.removeInterfaces();
        this.setSuperUnit(null);
        this.declaredMembers.clear();
        this.generatedJs = null;
    }

    public boolean isUpToDate() {
        return this.lastCompiled >= this.getLastModified();
    }

    public Collection<ClassUnit> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(ClassUnit interfaceUnit) {
        this.interfaces.add(interfaceUnit);
        interfaceUnit.addImplementor(this);
    }

    private void addImplementor(ClassUnit classUnit) {
        this.implementors.add(classUnit);
    }

    private void removeInterfaces() {
        Iterator<ClassUnit> iter = this.interfaces.iterator();
        while (iter.hasNext()) {
            ClassUnit interfaceUnit = iter.next();
            interfaceUnit.removeSubUnit(this);
            iter.remove();
        }
    }

    public void addSubUnit(ClassUnit subUnit) {
        if (subUnit == null) {
            throw new NullPointerException();
        }
        this.subUnits.add(subUnit);
    }

    public void removeSubUnit(ClassUnit subUnit) {
        if (subUnit == null) {
            throw new NullPointerException();
        }
        this.subUnits.remove(subUnit);
    }

    public Collection<ClassUnit> getSubUnits() {
        return this.subUnits;
    }

    public MemberUnit getDeclaredMember(String signature) {
        if (signature == null) {
            throw new NullPointerException();
        }
        return this.declaredMembers.get(signature);
    }

    public Collection<ClassUnit> getSupertypes() {
        TypeCollector collector = new TypeCollector();
        this.project.visitSuperTypes(this, collector);
        return collector.collectedTypes;
    }

    public Collection<MemberUnit> getMembers(String signature) {
        if (signature == null) {
            throw new NullPointerException();
        }
        ArrayList<MemberUnit> list = new ArrayList<MemberUnit>();
        for (ClassUnit clazz : this.getSupertypes()) {
            MemberUnit member = clazz.getDeclaredMember(signature);
            if (member == null) continue;
            list.add(member);
        }
        return list;
    }

    public Collection<MemberUnit> getDeclaredMembers() {
        if (!this.isResolved) {
            throw new RuntimeException("Class is not yet resolved: " + this.getName());
        }
        return this.declaredMembers.values();
    }

    public void addMemberUnit(MemberUnit unit) {
        this.declaredMembers.put(unit.getSignature().toString(), unit);
    }

    public ClassUnit getSuperUnit() {
        return this.superUnit;
    }

    public void setSuperUnit(ClassUnit theSuperUnit) {
        if (this.superUnit != null) {
            this.superUnit.removeSubUnit(this);
        }
        this.superUnit = theSuperUnit;
        if (this.superUnit != null) {
            this.superUnit.addSubUnit(this);
        }
    }

    @Override
    public void write(int depth, Writer writer2) throws IOException {
        if (!this.isTainted() || !this.isResolved() || this.isWritten()) {
            return;
        }
        StringBuilderWriter writer = new StringBuilderWriter();
        oneWritten = true;
        this.written = true;
        for (ClassUnit child : this.getSupertypes()) {
            child.setTainted();
            child.write(depth, writer2);
        }
        if (this.getSuperUnit() != null) {
            this.getSuperUnit().setTainted();
            this.getSuperUnit().write(depth, writer2);
        }
        for (ClassUnit child : this.getInterfaces()) {
            child.setTainted();
            child.write(depth, writer2);
        }
        if (this.generatedJs == null) {
            this.generatedJs = this.generateJsCode(depth, (Writer)writer);
        }
        writer2.write(this.generatedJs);
        this.taintRelated(depth, writer2);
    }

    private String generateJsCode(int depth, Writer writer) throws IOException {
        boolean bl;
        Log.getLogger().debug(this.getIndent(depth) + this);
        if (this.getData() == null) {
            throw new RuntimeException("Cannot compile the class: " + this.getName());
        }
        writer.write(this.getData());
        Set<MemberUnit> notImplementedMethods = this.getNotImplementedMethods();
        if (this.interfaces.size() > 0) {
            String extendOperator = "implement";
            if (this.isInterface) {
                extendOperator = "extend";
            }
            writer.write(extendOperator + ": [");
            int i = 0;
            for (ClassUnit classUnit : this.interfaces) {
                if (i++ > 0) {
                    writer.write(", ");
                }
                writer.write(DragomeJavaScriptGenerator.normalizeExpression(classUnit.getSignature().toString()));
            }
            writer.write("],\n");
        }
        writer.write("members:\n");
        writer.write("{\n");
        MemberUnit clinitMethod = null;
        ArrayList<MemberUnit> staticMethods = new ArrayList<MemberUnit>();
        boolean first = true;
        for (MemberUnit member : this.getDeclaredMembers()) {
            if (member.getData() != null && member.getData().startsWith(STATIC_MEMBER)) {
                staticMethods.add(member);
            } else if (member.getData() != null && member.getData().contains("_dragomeJs.StringInit")) {
                stringInits.add(member);
            } else if (member.getData() != null && member.getData().trim().length() > 0) {
                if (!first) {
                    writer.write(",\n");
                }
                first = false;
                this.writeMethodAlternative(depth, writer, member);
                if (member instanceof ProcedureUnit) {
                    ++this.project.currentGeneratedMethods;
                    writer.flush();
                }
            }
            if (!this.isClinit(member)) continue;
            clinitMethod = member;
        }
        for (MemberUnit member : notImplementedMethods) {
            if (!first) {
                writer.write(",\n");
            }
            first = false;
            String methodData = member.getData().replace(STATIC_MEMBER, "");
            methodData = methodData.substring(0, methodData.indexOf("{"));
            writer.write(methodData);
            writer.write("{\n return ");
            writer.write(member.getDeclaringClass().toString().replace(".", "_"));
            writer.write(".$$members.");
            writer.write(methodData.replace(": function ()", ".call (this)").replace(": function (", ".call (this, "));
            writer.write("}\n");
            if (!(member instanceof ProcedureUnit)) continue;
            ++this.project.currentGeneratedMethods;
            writer.flush();
        }
        writer.write("\n},\n");
        writer.write("statics:\n");
        writer.write("{\n");
        this.writeClinit(depth, writer, clinitMethod, staticMethods);
        boolean bl2 = bl = staticMethods.size() > 0;
        if (bl) {
            writer.write(",");
        }
        writer.write("\n");
        first = true;
        for (MemberUnit member : staticMethods) {
            if (member == clinitMethod) continue;
            if (!first) {
                writer.write(",\n");
            }
            first = false;
            String memberData = member.getData();
            member.setData(member.getData().replace(STATIC_MEMBER, ""));
            this.writeMethodAlternative(depth, writer, member);
            member.setData(memberData);
            if (!(member instanceof ProcedureUnit) && !(member instanceof FieldUnit)) continue;
            if (member instanceof ProcedureUnit) {
                ++this.project.currentGeneratedMethods;
            }
            writer.flush();
        }
        first = this.addSuperStaticMethods(writer, !bl ^ first, staticMethods);
        writer.write("\n}\n");
        writer.write("\n}\n\n");
        writer.write(");\n");
        return writer.toString();
    }

    private void writeClinit(int depth, Writer writer, MemberUnit clinitMethod, List<MemberUnit> staticMethods) throws IOException {
        String superStaticFields = this.createSuperStaticFieldsReferences(depth, clinitMethod, staticMethods);
        if (clinitMethod != null) {
            String name = DragomeJavaScriptGenerator.normalizeExpression(clinitMethod.getDeclaringClass().getName());
            String replace = clinitMethod.getData().replace("this.", name + ".");
            replace = replace.replace("{", "{ this.$$clinit_=function(){return this};\n" + superStaticFields);
            replace = replace.substring(0, replace.length() - 2) + "\n return this;\n}";
            String memberData = clinitMethod.getData();
            clinitMethod.setData(replace.replace(STATIC_MEMBER, ""));
            clinitMethod.write(depth, writer);
            clinitMethod.setData(memberData);
            String modifyMethodName = DragomeJavaScriptGenerator.normalizeExpression(clinitMethod.getSignature());
            this.project.getClinits().add("initClass(" + name + ");");
        } else {
            String replace = "$$clinit_: function(){this.$$clinit_=function(){return this};\n" + superStaticFields + " return this;}";
            writer.write(replace);
        }
    }

    private String createSuperStaticFieldsReferences(int depth, MemberUnit clinitMethod, List<MemberUnit> staticMethods) throws IOException {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        if (this.superUnit != null) {
            for (MemberUnit member : this.superUnit.getDeclaredMembers()) {
                if (member.getData() == null || !member.getData().startsWith(STATIC_MEMBER) || member instanceof MethodUnit || member.toString().equals("java.lang.Object#hashCodeCount") || this.containsSignature(member.getSignature(), staticMethods)) continue;
                String methodData = member.getData().replace(STATIC_MEMBER, "");
                String substring = methodData.substring(0, methodData.indexOf(":"));
                String fieldName = DragomeJavaScriptGenerator.normalizeExpression(this.getName()) + ".$$clinit_()." + substring + "=" + DragomeJavaScriptGenerator.normalizeExpression(member.getDeclaringClass().getName()) + ".$$clinit_()." + substring;
                result.append(fieldName);
                result.append(";\n");
                first = false;
                FieldUnit newField = new FieldUnit(member.getSignature(), this);
                newField.setData(member.getData());
                this.addMemberUnit(newField);
            }
        }
        return result.toString();
    }

    private void addAnnotationsAsStaticMember(Writer writer, boolean first) throws IOException {
        if (!first) {
            writer.write(",\n");
        }
        writer.write("{\n");
        for (Map.Entry<String, String> entry : this.annotationsValues.entrySet()) {
            writer.write(entry.getKey() + "\n");
            writer.write(entry.getValue() + "\n");
        }
        writer.write("}\n");
    }

    private Set<MemberUnit> getNotImplementedMethods() {
        HashSet<MemberUnit> interfacesMembers = new HashSet<MemberUnit>();
        this.getDeclaredMembersInInterfaces(this, interfacesMembers);
        HashSet<MemberUnit> implementedMembers = new HashSet<MemberUnit>();
        this.getImplementedMembersInHierarchy(this, implementedMembers);
        interfacesMembers.removeAll(implementedMembers);
        if (this.isImplementing(InvocationHandler.class) || this.isAbstract || this.isInterface || interfacesMembers.size() <= 0 || interfacesMembers.isEmpty()) {
            interfacesMembers.clear();
        }
        return interfacesMembers;
    }

    private boolean isImplementing(Class<InvocationHandler> class1) {
        if (this.getSuperUnit() != null && this.getSuperUnit().isImplementing(class1)) {
            return true;
        }
        for (ClassUnit interfaz : this.getInterfaces()) {
            if (!interfaz.toString().equals(class1.getName()) && !interfaz.isImplementing(class1)) continue;
            return true;
        }
        return false;
    }

    private void getImplementedMembersInHierarchy(ClassUnit classUnit, Collection<MemberUnit> implementedMembers) {
        if (classUnit != null) {
            if (this.isInterface) {
                return;
            }
            implementedMembers.addAll(this.filterMethods(classUnit.getDeclaredMembers()));
            this.getImplementedMembersInHierarchy(classUnit.getSuperUnit(), implementedMembers);
        }
    }

    private Collection<MethodUnit> filterMethods(Collection<MemberUnit> declaredMembers2) {
        ArrayList<MethodUnit> result = new ArrayList<MethodUnit>();
        for (MemberUnit memberUnit : declaredMembers2) {
            if (!(memberUnit instanceof MethodUnit)) continue;
            result.add((MethodUnit)memberUnit);
        }
        return result;
    }

    private void getDeclaredMembersInInterfaces(ClassUnit classUnit, Collection<MemberUnit> interfacesMembers) {
        if (classUnit != null) {
            if (this.isInterface) {
                interfacesMembers.addAll(this.filterMethods(classUnit.getDeclaredMembers()));
            }
            for (ClassUnit interfaceUnit : classUnit.getInterfaces()) {
                interfacesMembers.addAll(this.filterMethods(interfaceUnit.getDeclaredMembers()));
                interfaceUnit.getDeclaredMembersInInterfaces(interfaceUnit, interfacesMembers);
            }
            this.getDeclaredMembersInInterfaces(classUnit.getSuperUnit(), interfacesMembers);
        }
    }

    private boolean isClinit(MemberUnit member) {
        return member.getSignature().toString().equals("<clinit>()void");
    }

    private boolean addSuperStaticMethods(Writer writer, boolean first, List<MemberUnit> staticMethods) throws IOException {
        if (this.superUnit != null) {
            for (MemberUnit member : this.superUnit.getDeclaredMembers()) {
                if (member.getData() == null || !member.getData().startsWith(STATIC_MEMBER) || !(member instanceof MethodUnit) || this.isClinit(member) || this.containsSignature(member.getSignature(), staticMethods)) continue;
                this.addMemberUnit(member);
                String methodData = member.getData().replace(STATIC_MEMBER, "");
                String substring = methodData.substring(0, methodData.indexOf("{"));
                String methodName = substring.replace(": function", "").replace("\n", "");
                substring = substring + "{ \n\t return this.superclass." + methodName + ";\n}";
                if (!first) {
                    writer.write(",\n");
                }
                writer.write(substring);
                first = false;
            }
        }
        return first;
    }

    private boolean containsSignature(Signature signature, List<MemberUnit> staticMethods) {
        for (MemberUnit memberUnit : staticMethods) {
            if (!memberUnit.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    private void writeMethodAlternative(int depth, Writer writer, MemberUnit member) throws IOException {
        MethodUnit methodUnit;
        if (member instanceof MethodUnit) {
            methodUnit = (MethodUnit)member;
            String normalizedSignature = DragomeJavaScriptGenerator.normalizeExpression(methodUnit.getSignature());
            String normalizedClassname = DragomeJavaScriptGenerator.normalizeExpression(methodUnit.getDeclaringClass().getName());
            Project.getSingleton().getWrittenSignatures().add(normalizedClassname + "|" + normalizedSignature);
        }
        if (member instanceof MethodUnit && this.notReversibleMethods.contains(((MethodUnit)member).getNameAndSignature())) {
            methodUnit = (MethodUnit)member;
            writer.write(this.extractMethodDefinition(this.alternativeCompilation, methodUnit.getNameAndSignature()));
        } else {
            member.write(depth + 1, writer);
        }
    }

    private String extractMethodDefinition(String compiledCode, String nameAndSignature) {
        int startIndex = compiledCode.indexOf("start of " + nameAndSignature);
        int endIndex = compiledCode.indexOf("end of " + nameAndSignature);
        String part = compiledCode.substring(startIndex, endIndex);
        String result = part.substring(part.indexOf("*/"), part.lastIndexOf("}") + 1);
        result = result.substring(result.indexOf("$"));
        return result;
    }

    private void taintRelated(int depth, Writer writer) throws IOException {
        if (!"java.lang.Object".equals(this.toString())) {
            for (String dependency : this.dependencies) {
                ClassUnit dependencyClassUnit = this.project.getOrCreateClassUnit(dependency);
                dependencyClassUnit.setTainted();
            }
        }
        for (ClassUnit child : this.getSubUnits()) {
            child.setTainted();
            child.write(depth, writer);
        }
        for (ClassUnit child : this.getImplementors()) {
            child.setTainted();
        }
    }

    private boolean isWritten() {
        return this.written;
    }

    @Override
    void setSignature(Signature theSignature) {
        super.setSignature(theSignature);
    }

    public FileObject getClassFile() {
        if (this.classFile == null) {
            this.classFile = DragomeJsCompiler.compiler.fileManager.getFileForInput(this.getSignature().toString().replaceAll("\\.", "/") + ".class");
        }
        return this.classFile;
    }

    public void setClassFile(FileObject classFile) {
        this.classFile = classFile;
    }

    public void setLastCompiled(long theLastCompiled) {
        this.lastCompiled = theLastCompiled;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setSuperTainted() {
        ClassUnit clazz = this;
        do {
            clazz.setTainted();
        } while ((clazz = clazz.getSuperUnit()) != null);
        for (ClassUnit i : this.interfaces) {
            i.setSuperTainted();
        }
    }

    public void setResolved(boolean theIsResolved) {
        this.isResolved = theIsResolved;
    }

    public String getName() {
        return this.getSignature().className();
    }

    public Project getProject() {
        return this.project;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public List<String> getNotReversibleMethods() {
        return this.notReversibleMethods;
    }

    public void addDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    public void setBytecodeArrayI(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    public void addNotReversibleMethod(String methodNameSignature) {
        this.notReversibleMethods.add(methodNameSignature);
    }

    public void setAlternativeCompilation(String alternativeCompilation) {
        this.alternativeCompilation = alternativeCompilation;
    }

    public void setAnnotations(Map<String, String> annotationsValues) {
        this.annotationsValues = annotationsValues;
    }
}

