/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.units;

import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.units.MemberUnit;
import com.dragome.compiler.utils.Log;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public abstract class ProcedureUnit
extends MemberUnit {
    private Collection<Signature> targetSignatures = new LinkedHashSet<Signature>();

    public ProcedureUnit(Signature theSignature, ClassUnit theDeclaringClazz) {
        super(theSignature, theDeclaringClazz);
    }

    public void addTarget(Signature targetSignature) {
        if (!targetSignature.toString().contains("#")) {
            throw new IllegalArgumentException("Signature must be field or method: " + targetSignature);
        }
        this.targetSignatures.add(targetSignature);
    }

    public void removeTargets() {
        Iterator<Signature> iter = this.targetSignatures.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public void write(int depth, Writer writer) throws IOException {
        if (this.getData() == null) {
            return;
        }
        Log.getLogger().debug(this.getIndent(depth) + this.getSignature());
        writer.write(this.getData());
    }

    @Override
    public String getData() {
        if (!this.declaringClass.isResolved()) {
            throw new RuntimeException("Class must be resolved");
        }
        return super.getData();
    }

    public Collection<Signature> getTargetSignatures() {
        return this.targetSignatures;
    }
}

