/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.units;

import com.dragome.compiler.type.Signature;
import com.dragome.compiler.utils.Log;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Unit
implements Serializable {
    private Signature signature;
    private String data;
    private transient boolean isTainted = false;
    private static transient Map<Integer, String> indentPerDepth = new LinkedHashMap<Integer, String>();

    public abstract void write(int var1, Writer var2) throws IOException;

    String getIndent(int depth) {
        String indent = indentPerDepth.get(depth);
        if (indent == null) {
            indent = "";
            for (int i = 0; i < depth; ++i) {
                indent = indent + '\t';
            }
            indentPerDepth.put(depth, indent);
        }
        return indent;
    }

    public String toString() {
        return this.signature.toString();
    }

    public Signature getSignature() {
        return this.signature;
    }

    void setSignature(Signature theSignature) {
        this.signature = theSignature;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String theData) {
        this.data = theData;
    }

    public boolean isTainted() {
        return this.isTainted;
    }

    public void setTainted() {
        if (!this.isTainted) {
            Log.getLogger().debug("Taint " + this);
        }
        this.isTainted = true;
    }
}

