/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileObject {
    private long lastModified;
    private InputStream in;
    private File file;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileObject(JarFile jarFile, JarEntry entry) {
        try {
            this.in = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastModified = entry.getTime();
    }

    public FileObject(File file) {
        this.file = file;
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.lastModified = file.lastModified();
    }

    public InputStream openInputStream() throws IOException {
        return this.in;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

