/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.writer;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.generators.DragomeJavaScriptGenerator;
import com.dragome.compiler.generators.JavaScriptCompressor;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.units.ConstructorUnit;
import com.dragome.compiler.units.MemberUnit;
import com.dragome.compiler.units.ProcedureUnit;
import com.dragome.compiler.utils.FileObject;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.writer.JunkWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class Assembly {
    public List<String> entryPoints = new ArrayList<String>();
    private transient Log logger;
    private transient String entryPointClassName;
    private Project project;
    private Set<Signature> taintedSignatures = new LinkedHashSet<Signature>();
    private Set<Signature> unprocessedTaintedSignatures = new LinkedHashSet<Signature>();
    String[] patterns;
    private Collection<ClassUnit> resolvedTypes = new ArrayList<ClassUnit>();
    private transient File targetLocation;
    private FileFilter classpathFilter;

    private void pipeFileToStream(Writer writer, String relativeFilePath) throws IOException {
        String content;
        FileObject fileObject = DragomeJsCompiler.compiler.fileManager.getFileForInput(relativeFilePath);
        if (DragomeJsCompiler.compiler.isCompression()) {
            JavaScriptCompressor compressor = new JavaScriptCompressor();
            content = compressor.compress(fileObject.openInputStream());
        } else {
            content = IOUtils.toString((InputStream)fileObject.openInputStream());
        }
        writer.write(content);
        fileObject.close();
    }

    private void removeOldAssemblies(File assembly) {
        String numericPostfixPattern = "-[0-9]*$";
        final String prefix = assembly.getName().replaceAll("-[0-9]*$", "");
        File[] oldAssemblies = assembly.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir1, String name) {
                return name.matches(prefix + "-[0-9]*$");
            }
        });
        if (oldAssemblies == null) {
            return;
        }
        for (File oldAssemblyDir : oldAssemblies) {
            for (File file : oldAssemblyDir.listFiles()) {
                file.delete();
            }
            oldAssemblyDir.delete();
        }
    }

    public int createAssembly() throws IOException {
        Writer writer;
        this.logger = Log.getLogger();
        this.logger.debug("Packing ...");
        this.removeOldAssemblies(this.targetLocation);
        String loaderName = DragomeJsCompiler.compiler.getTargetPlatform().toLowerCase();
        if ("javascript".equals(loaderName)) {
            writer = new FileWriter(this.targetLocation);
            this.pipeFileToStream(writer, "dragome/javascript/loaders/" + loaderName + ".js");
        } else {
            this.targetLocation.mkdirs();
            writer = new JunkWriter(this.targetLocation);
        }
        writer.write("//***********************************************************************\n");
        writer.write("//* Generated with Dragome SDK Copyright (c) 2011-2014 Fernando Petrola *\n");
        writer.write("//***********************************************************************\n");
        writer.write("\n");
        this.pipeFileToStream(writer, "dragome/javascript/runtime.js");
        writer.write("dragomeJs.userData = {};\n");
        this.project.currentGeneratedMethods = 0;
        if (DragomeJsCompiler.compiler.getSingleEntryPoint() != null) {
            Signature signature = this.project.getSignature(DragomeJsCompiler.compiler.getSingleEntryPoint());
            ClassUnit clazz = this.project.getClassUnit(signature.className());
            clazz.write(0, writer);
        } else {
            ClassUnit object = this.project.getJavaLangObject();
            object.write(0, writer);
            do {
                ClassUnit.oneWritten = false;
                for (ClassUnit cu : this.project.getClasses()) {
                    cu.write(0, writer);
                }
            } while (ClassUnit.oneWritten);
        }
        ClassUnit stringClazz = this.project.getClassUnit(String.class.getName());
        ClassUnit stringSuperClazz = stringClazz.getSuperUnit();
        ArrayList<MemberUnit> declaredMembers = new ArrayList<MemberUnit>(stringClazz.getDeclaredMembers());
        declaredMembers.addAll(stringSuperClazz.getDeclaredMembers());
        for (MemberUnit memberUnit : declaredMembers) {
            Signature signature = memberUnit.getSignature();
            String normalizeExpression = DragomeJavaScriptGenerator.normalizeExpression(signature);
            writer.write("String.prototype." + normalizeExpression + "= java_lang_String.prototype." + normalizeExpression + ";\n");
        }
        writer.write("String.prototype.classname= \"java_lang_String\";\n");
        for (MemberUnit member : ClassUnit.stringInits) {
            String memberData = member.getData();
            member.setData(member.getData().substring(1));
            member.write(1, writer);
            member.setData(memberData);
            if (!(member instanceof ProcedureUnit)) continue;
            ++this.project.currentGeneratedMethods;
            writer.flush();
        }
        if (this.getProject().getOrCreateClassUnit("java.lang.String").isTainted()) {
            writer.write("String.prototype.clazz = java_lang_String;\n");
        }
        writer.write("javascript_Utils.$init$void();\n");
        this.project.writeSignatures(writer);
        writer.write("java_lang_Object.prototype.toString= function (){return this.$toString$java_lang_String();};\n");
        this.writeAnnotationsInsertion(writer);
        writer.write("$(function(){setupCheckCast(); _ed.executeMainClass();});");
        writer.close();
        return this.project.currentGeneratedMethods;
    }

    private void writeAnnotationsInsertion(Writer writer) throws IOException {
        Set<String> typeDeclarations = this.getProject().getTypeDeclarationsWithAnnotations();
        for (String typeDeclaration : typeDeclarations) {
            String[] key = typeDeclaration.split("#");
            if ("bytes".equals(key[2])) continue;
            writer.write(String.format("dragomeJs.addTypeAnnotation(\"%s\", \"%s\", \"%s\", \"%s\");\n", key[0], key[1], key[2], key[3]));
        }
    }

    public void processTainted() {
        while (this.unprocessedTaintedSignatures.size() > 0) {
            this.processSingle(this.popSignature());
            if (this.unprocessedTaintedSignatures.size() != 0) continue;
            this.processOverWrittenMembers();
        }
    }

    public void processSingle(Signature signature) {
        ClassUnit clazz = this.resolve(signature.className());
        if (this.classpathFilter.accept(new File(signature.className().replace(".", "/")))) {
            String methodPart = signature.relativeSignature();
            boolean found = false;
            for (MemberUnit member : clazz.getMembers(methodPart)) {
                this.taint(member);
                found = true;
            }
            if (!found) {
                Log.getLogger().debug("No such method: " + signature);
            }
        }
    }

    private ClassUnit resolve(String className) {
        ClassUnit clazz = this.project.getOrCreateClassUnit(className);
        if (className.startsWith("[")) {
            this.project.resolve(clazz);
        } else {
            this.project.resolve(clazz);
            this.taint(className + "#<clinit>()void");
        }
        this.resolvedTypes.add(clazz);
        return clazz;
    }

    public ClassUnit resolveNoTainting(String className) {
        ClassUnit clazz = this.project.getOrCreateClassUnit(className);
        if (className.startsWith("[")) {
            this.project.resolve(clazz);
        } else {
            this.project.resolve(clazz);
        }
        this.resolvedTypes.add(clazz);
        return clazz;
    }

    private void taintImplicitelyAccessedMembers(ClassUnit clazz) {
        for (MemberUnit member : clazz.getDeclaredMembers()) {
            this.taint(member.getAbsoluteSignature());
        }
    }

    private void taintIfSuperTainted(ClassUnit clazz) {
        if (clazz.getName().equals("java.lang.Object")) {
            return;
        }
        for (MemberUnit member : clazz.getDeclaredMembers()) {
            for (ClassUnit superType : clazz.getSupertypes()) {
                Signature signature = Project.getSingleton().getSignature(superType.getName(), member.getSignature().toString());
                this.taint(member);
            }
        }
    }

    private void taintTargetSignatures(ProcedureUnit method) {
        for (Signature targetSignature : method.getTargetSignatures()) {
            this.taint(targetSignature);
        }
    }

    private void processOverWrittenMembers() {
        for (ClassUnit clazz : this.resolvedTypes) {
            if (!clazz.isConstructorTainted) continue;
            this.taintIfSuperTainted(clazz);
        }
    }

    public void taint(String signature) {
        signature = signature.replaceAll("\\s", "");
        Signature s = Project.getSingleton().getSignature(signature);
        if (s.isClass()) {
            ClassUnit clazz = this.resolve(s.className());
            for (MemberUnit member : clazz.getDeclaredMembers()) {
                this.taint(member.getAbsoluteSignature());
            }
        } else {
            this.taint(s);
        }
    }

    private Signature popSignature() {
        Iterator<Signature> iter = this.unprocessedTaintedSignatures.iterator();
        Signature signature = iter.next();
        iter.remove();
        return signature;
    }

    public void taint(Signature signature) {
        if (!signature.toString().contains("#")) {
            throw new IllegalArgumentException("Signature must be field or method: " + signature);
        }
        if (this.taintedSignatures.contains(signature)) {
            return;
        }
        this.taintedSignatures.add(signature);
        this.unprocessedTaintedSignatures.add(signature);
    }

    public void taint(MemberUnit member) {
        member.setTainted();
        member.getDeclaringClass().setSuperTainted();
        if (member instanceof ProcedureUnit) {
            this.taintTargetSignatures((ProcedureUnit)member);
            if (member instanceof ConstructorUnit) {
                member.getDeclaringClass().isConstructorTainted = true;
                this.taintImplicitelyAccessedMembers(member.getDeclaringClass());
            }
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getEntryPointClassName() {
        return this.entryPointClassName;
    }

    public Assembly setEntryPointClassName(String entryPointClassName) {
        this.entryPointClassName = entryPointClassName;
        return this;
    }

    public File getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(File targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void addEntryPoint(String memberSignature) {
        this.entryPoints.add(memberSignature);
    }

    public void setClasspathFilter(FileFilter classpathFilter) {
        this.classpathFilter = classpathFilter;
    }
}

