/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss.SSS";
    private static final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    private static Level level = Level.ALL;

    private static void display(Level l, String message) {
        if (l.compareTo(level) <= 0 && message != null) {
            l.stream.println("[" + Log.getDate() + "] " + l.prefix + message);
        }
    }

    public static void error(String tag, String message) {
        Log.display(Level.ERROR, tag + ": " + message);
    }

    public static void error(String message) {
        Log.display(Level.ERROR, message);
    }

    public static void debug(String tag, String message) {
        Log.display(Level.ALL, tag + ": " + message);
    }

    public static void debug(String message) {
        Log.display(Level.ALL, message);
    }

    public static void warn(String tag, String message) {
        Log.display(Level.WARNING, tag + ": " + message);
    }

    public static void warn(String message) {
        Log.display(Level.WARNING, message);
    }

    private static String getDate() {
        return dateFormat.format(new Date());
    }

    public static void setLevel(Level newLevel) {
        if (newLevel != null) {
            level = newLevel;
        }
    }

    public static enum Level {
        NONE("          ", System.out),
        ERROR("   ERROR: ", System.err),
        WARNING(" WARNING: ", System.out),
        ALL("   DEBUG: ", System.out);

        private final String prefix;
        private final PrintStream stream;

        private Level(String prefix, PrintStream stream) {
            this.prefix = prefix;
            this.stream = stream;
        }

        public void flush() {
            this.stream.flush();
        }

        public static Level getLevel(String level) {
            try {
                return Level.valueOf(level.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

